/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class ColorBlindnessPanel
extends JPanel
implements ChangeListener {
    private final JCheckBox myCheckBox = new JCheckBox();
    private final JComboBox myComboBox = new ComboBox();

    public ColorBlindnessPanel() {
        super((LayoutManager)new HorizontalLayout(JBUI.scale((int)10)));
        this.add("LEFT", this.myCheckBox);
        this.add("LEFT", this.myComboBox);
        this.myCheckBox.setSelected(false);
        this.myCheckBox.addChangeListener(this);
        this.myCheckBox.setText(IdeBundle.message((String)"checkbox.color.blindness", (Object[])new Object[0]));
        int count = 0;
        for (ColorBlindness blindness : ColorBlindness.values()) {
            String name = IdeBundle.message((String)("combobox.color.blindness." + blindness.name()), (Object[])new Object[0]);
            if (name.isEmpty()) continue;
            this.myComboBox.addItem(new Item(blindness, name));
            ++count;
        }
        this.myComboBox.setEnabled(false);
        this.myComboBox.setVisible(count > 1);
        this.setVisible(count > 0);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.myComboBox.setEnabled(this.myCheckBox.isSelected());
    }

    public ColorBlindness getColorBlindness() {
        Object object;
        if (this.myCheckBox.isSelected() && (object = this.myComboBox.getSelectedItem()) instanceof Item) {
            Item item = (Item)object;
            return item.myBlindness;
        }
        return null;
    }

    public void setColorBlindness(ColorBlindness blindness) {
        Item item = null;
        if (blindness != null) {
            int count = this.myComboBox.getItemCount();
            for (int i = 0; i < count && item == null; ++i) {
                Object object = this.myComboBox.getItemAt(i);
                if (!(object instanceof Item) || (item = (Item)object).myBlindness == blindness) continue;
                item = null;
            }
        }
        this.myCheckBox.setSelected(item != null);
        if (item != null) {
            this.myComboBox.setSelectedItem(item);
        }
    }

    private static final class Item {
        private final ColorBlindness myBlindness;
        private final String myName;

        private Item(ColorBlindness blindness, String name) {
            this.myBlindness = blindness;
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

