/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PropertyName;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageDuplicateResultsDialog
extends DialogWrapper {
    private final Project myProject;
    private final List<VirtualFile> myImages;
    private final Map<String, Set<VirtualFile>> myDuplicates;
    private final Tree myTree;
    private final ResourceModules myResourceModules = new ResourceModules();

    public ImageDuplicateResultsDialog(Project project, List<VirtualFile> images, Map<String, Set<VirtualFile>> duplicates) {
        super(project);
        this.myProject = project;
        this.myImages = images;
        PropertiesComponent.getInstance((Project)this.myProject).loadFields((Object)this.myResourceModules);
        this.myDuplicates = duplicates;
        this.setModal(false);
        this.myTree = new Tree((TreeNode)new MyRootNode());
        this.myTree.setRootVisible(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyCellRenderer()));
        this.init();
        TreeUtil.expandAll((JTree)this.myTree);
        this.setTitle("Image Duplicates");
        TreeUtil.selectFirstNode((JTree)this.myTree);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actions2 = new Action[4];
        actions2[0] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        actions2[0].putValue("Name", "Fix all");
        actions2[0].putValue("DefaultAction", Boolean.TRUE);
        actions2[0].putValue("FocusedAction", Boolean.TRUE);
        actions2[1] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        actions2[1].putValue("Name", "Fix selected");
        actions2[2] = this.getCancelAction();
        actions2[3] = this.getHelpAction();
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/ImageDuplicateResultsDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        DataManager.registerDataProvider((JComponent)panel, (DataProvider)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                TreePath path = ImageDuplicateResultsDialog.this.myTree.getSelectionPath();
                if (path != null) {
                    Object component = path.getLastPathComponent();
                    VirtualFile file = null;
                    if (component instanceof MyFileNode) {
                        component = ((MyFileNode)component).getParent();
                    }
                    if (component instanceof MyDuplicatesNode) {
                        file = (VirtualFile)((MyDuplicatesNode)component).getUserObject().iterator().next();
                    }
                    if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                        return file;
                    }
                    if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && file != null) {
                        return new VirtualFile[]{file};
                    }
                }
                return null;
            }
        });
        final JBList list = new JBList(new ResourceModules().getModuleNames());
        NotNullFunction<Object, JComponent> modulesRenderer = new NotNullFunction<Object, JComponent>(){

            @NotNull
            public JComponent fun(Object dom) {
                JLabel jLabel = new JLabel(dom instanceof Module ? ((Module)dom).getName() : dom.toString(), PlatformIcons.SOURCE_FOLDERS_ICON, 2);
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/ImageDuplicateResultsDialog$4", "fun"));
                }
                return jLabel;
            }
        };
        list.installCellRenderer((NotNullFunction)modulesRenderer);
        JPanel modulesPanel = ToolbarDecorator.createDecorator((JList)list).setAddAction(new AnActionButtonRunnable((NotNullFunction)modulesRenderer, list){
            final /* synthetic */ NotNullFunction val$modulesRenderer;
            final /* synthetic */ JBList val$list;
            {
                this.val$modulesRenderer = notNullFunction;
                this.val$list = jBList;
            }

            public void run(AnActionButton button) {
                Object[] all = ModuleManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).getModules();
                Arrays.sort(all, new Comparator<Module>(){

                    @Override
                    public int compare(Module o1, Module o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                final JBList modules = new JBList(all);
                modules.installCellRenderer(this.val$modulesRenderer);
                JBPopupFactory.getInstance().createListPopupBuilder((JList)modules).setTitle("Add Resource Module").setFilteringEnabled((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return ((Module)o).getName();
                    }
                }).setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        Object value = modules.getSelectedValue();
                        if (value instanceof Module && !ImageDuplicateResultsDialog.this.myResourceModules.contains((Module)value)) {
                            ImageDuplicateResultsDialog.this.myResourceModules.add((Module)value);
                            ((DefaultListModel)val$list.getModel()).addElement(((Module)value).getName());
                        }
                        ((DefaultTreeModel)ImageDuplicateResultsDialog.this.myTree.getModel()).reload();
                        TreeUtil.expandAll((JTree)ImageDuplicateResultsDialog.this.myTree);
                    }
                }).createPopup().show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object[] values;
                for (Object value : values = list.getSelectedValues()) {
                    ImageDuplicateResultsDialog.this.myResourceModules.remove((String)value);
                    ((DefaultListModel)list.getModel()).removeElement(value);
                }
                ((DefaultTreeModel)ImageDuplicateResultsDialog.this.myTree.getModel()).reload();
                TreeUtil.expandAll((JTree)ImageDuplicateResultsDialog.this.myTree);
            }
        }).disableDownAction().disableUpAction().createPanel();
        modulesPanel.setPreferredSize(new Dimension(-1, 60));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)new JLabel("Image modules:"), "North");
        top.add((Component)modulesPanel, "Center");
        panel.add((Component)top, "North");
        panel.add((Component)new JBScrollPane((Component)this.myTree), "Center");
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                PsiFile psiFile;
                VirtualFile file = ImageDuplicateResultsDialog.this.getFileFromSelection();
                if (file != null && (psiFile = PsiManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).findFile(file)) != null) {
                    final ImplementationViewComponent viewComponent = new ImplementationViewComponent(new PsiElement[]{psiFile}, 0);
                    final TreeSelectionListener listener = new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            PsiFile newElement;
                            VirtualFile selection = ImageDuplicateResultsDialog.this.getFileFromSelection();
                            if (selection != null && (newElement = PsiManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).findFile(selection)) != null) {
                                viewComponent.update(new PsiElement[]{newElement}, 0);
                            }
                        }
                    };
                    ImageDuplicateResultsDialog.this.myTree.addTreeSelectionListener(listener);
                    JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)viewComponent, viewComponent.getPreferredFocusableComponent()).setProject(ImageDuplicateResultsDialog.this.myProject).setDimensionServiceKey(ImageDuplicateResultsDialog.this.myProject, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(false).setCancelCallback((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            ImageDuplicateResultsDialog.this.myTree.removeTreeSelectionListener(listener);
                            return true;
                        }
                    }).setTitle("Image Preview").createPopup();
                    Window window = ImageDuplicateResultsDialog.this.getWindow();
                    popup.show(new RelativePoint((Component)window, new Point(window.getWidth(), 0)));
                    viewComponent.setHint(popup, "Image Preview");
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), (JComponent)panel);
        int total = 0;
        for (Set<VirtualFile> set : this.myDuplicates.values()) {
            total += set.size();
        }
        JLabel label = new JLabel("<html>Press <b>Enter</b> to preview image<br>Total images found: " + this.myImages.size() + ". Total duplicates found: " + (total -= this.myDuplicates.size()) + "</html>");
        panel.add((Component)label, "South");
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "image.duplicates.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    private VirtualFile getFileFromSelection() {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            Object component = path.getLastPathComponent();
            VirtualFile file = null;
            if (component instanceof MyFileNode) {
                component = ((MyFileNode)component).getParent();
            }
            if (component instanceof MyDuplicatesNode) {
                file = (VirtualFile)((MyDuplicatesNode)component).getUserObject().iterator().next();
            }
            return file;
        }
        return null;
    }

    private static String getRelativePathToProject(Project project, VirtualFile file) {
        String path = project.getBasePath();
        assert (path != null);
        String result = FileUtil.getRelativePath((String)path, (String)file.getPath().replace('/', File.separatorChar), (char)File.separatorChar);
        assert (result != null);
        return result;
    }

    static class ResourceModules {
        @PropertyName(value="resource.modules", defaultValue="icons")
        public String modules;

        ResourceModules() {
        }

        public List<String> getModuleNames() {
            return Arrays.asList(StringUtil.splitByLines((String)(this.modules == null ? "icons" : this.modules)));
        }

        public boolean contains(Module module) {
            return this.getModuleNames().contains(module.getName());
        }

        public void add(Module module) {
            this.modules = StringUtil.isEmpty((String)this.modules) ? module.getName() : this.modules + "\n" + module.getName();
        }

        public void remove(String value) {
            ArrayList<String> names = new ArrayList<String>(this.getModuleNames());
            names.remove(value);
            this.modules = StringUtil.join(names, (String)"\n");
        }
    }

    private class MyCellRenderer
    extends ColoredTreeCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof MyFileNode) {
                VirtualFile file = ((MyFileNode)value).getUserObject();
                Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)ImageDuplicateResultsDialog.this.myProject);
                if (module != null) {
                    this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
                    this.append("[" + module.getName() + "] ", new SimpleTextAttributes(1, UIUtil.getTreeForeground()));
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file));
                } else {
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file));
                }
            } else if (value instanceof MyDuplicatesNode) {
                Object files = ((MyDuplicatesNode)value).getUserObject();
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    VirtualFile file = (VirtualFile)iterator.next();
                    Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)ImageDuplicateResultsDialog.this.myProject);
                    if (module == null || !ImageDuplicateResultsDialog.this.myResourceModules.contains(module)) continue;
                    this.append("Icons can be replaced to ");
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file), new SimpleTextAttributes(1, ColorUtil.fromHex((String)"008000")));
                    return;
                }
                this.append("Icon conflict");
            } else if (value instanceof MyRootNode) {
                this.append("All conflicts");
            }
        }
    }

    private static class MyFileNode
    extends DefaultMutableTreeNode {
        public MyFileNode(DefaultMutableTreeNode node, VirtualFile file) {
            super(file);
            this.setParent(node);
        }

        public VirtualFile getUserObject() {
            return (VirtualFile)super.getUserObject();
        }
    }

    private class MyDuplicatesNode
    extends DefaultMutableTreeNode {
        private final Set<VirtualFile> myFiles;

        public MyDuplicatesNode(DefaultMutableTreeNode node, Set<VirtualFile> files) {
            super(files);
            this.myFiles = files;
            this.setParent(node);
            Vector<MyFileNode> vector = new Vector<MyFileNode>();
            for (VirtualFile file : files) {
                vector.add(new MyFileNode(this, file));
            }
            this.children = vector;
        }

        @Override
        public Set<VirtualFile> getUserObject() {
            return (Set)super.getUserObject();
        }
    }

    private class MyRootNode
    extends DefaultMutableTreeNode {
        private MyRootNode() {
            Vector<MyDuplicatesNode> vector = new Vector<MyDuplicatesNode>();
            for (Set files : ImageDuplicateResultsDialog.this.myDuplicates.values()) {
                vector.add(new MyDuplicatesNode(this, files));
            }
            this.children = vector;
        }
    }
}

