/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.FilteredTraverser;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ToolbarUpdater
implements Activatable {
    private final ActionManagerEx myActionManager;
    private final KeymapManagerEx myKeymapManager;
    private final JComponent myComponent;
    private final KeymapManagerListener myKeymapManagerListener;
    private final TimerListener myTimerListener;
    private final WeakTimerListener myWeakTimerListener;
    private boolean myListenersArmed;

    public ToolbarUpdater(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "<init>"));
        }
        this(ActionManagerEx.getInstanceEx(), KeymapManagerEx.getInstanceEx(), component);
    }

    public ToolbarUpdater(@NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager, @NotNull JComponent component) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "<init>"));
        }
        if (keymapManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymapManager", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "<init>"));
        }
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myTimerListener = new MyTimerListener();
        this.myActionManager = actionManager;
        this.myKeymapManager = keymapManager;
        this.myComponent = component;
        this.myWeakTimerListener = new WeakTimerListener(actionManager, this.myTimerListener);
        new UiNotifyConnector((Component)component, (Activatable)this);
    }

    public void showNotify() {
        if (this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = true;
        this.myActionManager.addTimerListener(500, (TimerListener)this.myWeakTimerListener);
        this.myActionManager.addTransparentTimerListener(500, (TimerListener)this.myWeakTimerListener);
        this.myKeymapManager.addWeakListener(this.myKeymapManagerListener);
        this.updateActionTooltips();
    }

    public void hideNotify() {
        if (!this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = false;
        this.myActionManager.removeTimerListener((TimerListener)this.myWeakTimerListener);
        this.myActionManager.removeTransparentTimerListener((TimerListener)this.myWeakTimerListener);
        this.myKeymapManager.removeWeakListener(this.myKeymapManagerListener);
    }

    @NotNull
    public KeymapManagerEx getKeymapManager() {
        KeymapManagerEx keymapManagerEx = this.myKeymapManager;
        if (keymapManagerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "getKeymapManager"));
        }
        return keymapManagerEx;
    }

    @NotNull
    public ActionManagerEx getActionManager() {
        ActionManagerEx actionManagerEx = this.myActionManager;
        if (actionManagerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "getActionManager"));
        }
        return actionManagerEx;
    }

    public void updateActions(boolean now, boolean forced) {
        this.updateActions(now, false, forced);
    }

    private void updateActions(boolean now, boolean transparentOnly, boolean forced) {
        final MyUpdateRunnable updateRunnable = new MyUpdateRunnable(this, transparentOnly, forced);
        Application app = ApplicationManager.getApplication();
        if (now || app.isUnitTestMode()) {
            updateRunnable.run();
        } else {
            final IdeFocusManager fm = IdeFocusManager.getInstance(null);
            if (!app.isHeadlessEnvironment()) {
                if (app.isDispatchThread() && this.myComponent.isShowing()) {
                    fm.doWhenFocusSettlesDown((Runnable)updateRunnable);
                } else {
                    UiNotifyConnector.doWhenFirstShown((JComponent)this.myComponent, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            fm.doWhenFocusSettlesDown(updateRunnable);
                        }
                    });
                }
            }
        }
    }

    protected abstract void updateActionsImpl(boolean var1, boolean var2);

    protected void updateActionTooltips() {
        for (ActionButton actionButton : ((FilteredTraverser)JBSwingUtilities.uiTraverser().withRoot((Object)this.myComponent)).preOrderDfsTraversal().filter(ActionButton.class)) {
            actionButton.updateToolTipText();
        }
    }

    private static class MyUpdateRunnable
    implements Runnable {
        private final boolean myTransparentOnly;
        private final boolean myForced;
        @NotNull
        private final WeakReference<ToolbarUpdater> myUpdaterRef;
        private final int myHash;

        public MyUpdateRunnable(@NotNull ToolbarUpdater updater, boolean transparentOnly, boolean forced) {
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyUpdateRunnable", "<init>"));
            }
            this.myTransparentOnly = transparentOnly;
            this.myForced = forced;
            this.myHash = updater.hashCode();
            this.myUpdaterRef = new WeakReference<ToolbarUpdater>(updater);
        }

        @Override
        public void run() {
            ToolbarUpdater updater = (ToolbarUpdater)this.myUpdaterRef.get();
            if (updater == null) {
                return;
            }
            if (!updater.myComponent.isVisible()) {
                return;
            }
            updater.updateActionsImpl(this.myTransparentOnly, this.myForced);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyUpdateRunnable)) {
                return false;
            }
            MyUpdateRunnable that = (MyUpdateRunnable)obj;
            if (this.myHash != that.myHash) {
                return false;
            }
            ToolbarUpdater updater1 = (ToolbarUpdater)this.myUpdaterRef.get();
            ToolbarUpdater updater2 = (ToolbarUpdater)that.myUpdaterRef.get();
            return Comparing.equal((Object)updater1, (Object)updater2);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)ToolbarUpdater.this.myComponent);
        }

        public void run() {
            if (!ToolbarUpdater.this.myComponent.isShowing()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(ToolbarUpdater.this.myComponent, window)) {
                return;
            }
            ToolbarUpdater.this.updateActions(false, ToolbarUpdater.this.myActionManager.isTransparentOnlyActionsUpdateNow(), false);
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public void activeKeymapChanged(Keymap keymap) {
            ToolbarUpdater.this.updateActionTooltips();
        }
    }
}

