/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StateStorageBase<T>
implements StateStorage {
    protected static final Logger LOG = Logger.getInstance(StateStorageBase.class);
    private boolean mySavingDisabled = false;
    protected final AtomicReference<T> storageDataRef = new AtomicReference();

    @Nullable
    public final <S> S getState(Object component, @NotNull String componentName, @NotNull Class<S> stateClass, @Nullable S mergeInto, boolean reload) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getState"));
        }
        return this.deserializeState(this.getStateAndArchive(this.getStorageData(reload), component, componentName), stateClass, mergeInto);
    }

    public final <S> S getState(@Nullable Object component, @NotNull String componentName, @NotNull Class<S> stateClass) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getState"));
        }
        return this.getState(component, componentName, stateClass, null, false);
    }

    @Nullable
    protected <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/StateStorageBase", "deserializeState"));
        }
        return DefaultStateSerializer.deserializeState(serializedState, stateClass, mergeInto);
    }

    @Nullable
    protected abstract Element getStateAndArchive(@NotNull T var1, Object var2, @NotNull String var3);

    protected abstract boolean hasState(@NotNull T var1, @NotNull String var2);

    public final boolean hasState(@NotNull String componentName, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageBase", "hasState"));
        }
        return this.hasState(this.getStorageData(reloadData), componentName);
    }

    @NotNull
    public final T getStorageData() {
        T t = this.getStorageData(false);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getStorageData"));
        }
        return t;
    }

    @NotNull
    protected final T getStorageData(boolean reload) {
        T storageData = this.storageDataRef.get();
        if (storageData != null && !reload) {
            T t = storageData;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getStorageData"));
            }
            return t;
        }
        T newStorageData = this.loadData();
        if (this.storageDataRef.compareAndSet(storageData, newStorageData)) {
            T t = newStorageData;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getStorageData"));
            }
            return t;
        }
        T t = this.getStorageData(false);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageBase", "getStorageData"));
        }
        return t;
    }

    protected abstract T loadData();

    public final void disableSaving() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disabled saving for " + this.toString());
        }
        this.mySavingDisabled = true;
    }

    public final void enableSaving() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled saving " + this.toString());
        }
        this.mySavingDisabled = false;
    }

    protected final boolean checkIsSavingDisabled() {
        if (this.mySavingDisabled && LOG.isDebugEnabled()) {
            LOG.debug("Saving disabled for " + this.toString());
        }
        return this.mySavingDisabled;
    }
}

