/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapHelper;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretImpl
extends UserDataHolderBase
implements Caret {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.CaretImpl");
    private final EditorImpl myEditor;
    private boolean isValid = true;
    private LogicalPosition myLogicalCaret;
    private VerticalInfo myCaretInfo;
    private VisualPosition myVisibleCaret;
    private int myOffset;
    private int myVirtualSpaceOffset;
    private int myVisualLineStart;
    private int myVisualLineEnd;
    private RangeMarker savedBeforeBulkCaretMarker;
    private boolean mySkipChangeRequests;
    private int myLastColumnNumber = 0;
    private int myDesiredSelectionStartColumn = -1;
    private int myDesiredSelectionEndColumn = -1;
    private boolean myReportCaretMoves;
    private int myDesiredX = -1;
    private volatile RangeMarker mySelectionMarker;
    private volatile VisualPosition myRangeMarkerStartPosition;
    private volatile VisualPosition myRangeMarkerEndPosition;
    private volatile boolean myRangeMarkerEndPositionIsLead;
    private int startBefore;
    private int endBefore;
    boolean myUnknownDirection;
    private int myStartVirtualOffset;
    private int myEndVirtualOffset;

    CaretImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myLogicalCaret = new LogicalPosition(0, 0);
        this.myVisibleCaret = new VisualPosition(0, 0);
        this.myCaretInfo = new VerticalInfo(0, 0);
        this.myOffset = 0;
        this.myVisualLineStart = 0;
        DocumentEx doc = this.myEditor.getDocument();
        this.myVisualLineEnd = doc.getLineCount() > 1 ? doc.getLineStartOffset(1) : (doc.getLineCount() == 0 ? 0 : doc.getLineEndOffset(0));
    }

    void onBulkDocumentUpdateStarted() {
        DocumentEx doc = this.myEditor.getDocument();
        if (this.myOffset > doc.getTextLength() || this.savedBeforeBulkCaretMarker != null) {
            return;
        }
        this.savedBeforeBulkCaretMarker = doc.createRangeMarker(this.myOffset, this.myOffset);
    }

    void onBulkDocumentUpdateFinished() {
        DocumentEx doc = this.myEditor.getDocument();
        if (this.myEditor.getCaretModel().myIsInUpdate) {
            return;
        }
        LOG.assertTrue(!this.myReportCaretMoves);
        if (this.savedBeforeBulkCaretMarker != null) {
            if (this.savedBeforeBulkCaretMarker.isValid()) {
                if (this.savedBeforeBulkCaretMarker.getStartOffset() != this.myOffset) {
                    this.moveToOffset(this.savedBeforeBulkCaretMarker.getStartOffset());
                }
            } else if (this.myOffset > doc.getTextLength()) {
                this.moveToOffset(doc.getTextLength());
            }
            this.releaseBulkCaretMarker();
        }
    }

    public void beforeDocumentChange() {
        RangeMarker marker = this.mySelectionMarker;
        if (marker != null && marker.isValid()) {
            this.startBefore = marker.getStartOffset();
            this.endBefore = marker.getEndOffset();
        }
    }

    public void documentChanged() {
        RangeMarker marker = this.mySelectionMarker;
        if (marker != null) {
            int endAfter;
            int startAfter;
            if (marker.isValid()) {
                startAfter = marker.getStartOffset();
                endAfter = marker.getEndOffset();
                if (!(this.myEndVirtualOffset <= 0 || this.isVirtualSelectionEnabled() && EditorUtil.isAtLineEnd(this.myEditor, endAfter) && this.myEditor.getDocument().getLineNumber(startAfter) == this.myEditor.getDocument().getLineNumber(endAfter))) {
                    this.myStartVirtualOffset = 0;
                    this.myEndVirtualOffset = 0;
                }
            } else {
                startAfter = endAfter = this.getOffset();
                marker.dispose();
                this.myStartVirtualOffset = 0;
                this.myEndVirtualOffset = 0;
                this.mySelectionMarker = null;
            }
            if (this.startBefore != startAfter || this.endBefore != endAfter) {
                this.myEditor.getSelectionModel().fireSelectionChanged(this.startBefore, this.endBefore, startAfter, endAfter);
            }
        }
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(final int offset, final boolean locateBeforeSoftWrap) {
        CaretImpl.assertIsDispatchThread();
        this.validateCallContext();
        if (this.mySkipChangeRequests) {
            return;
        }
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                LogicalPosition logicalPosition = CaretImpl.this.myEditor.offsetToLogicalPosition(offset);
                CaretEvent event = CaretImpl.this.moveToLogicalPosition(logicalPosition, locateBeforeSoftWrap, null, false);
                LogicalPosition positionByOffsetAfterMove = CaretImpl.this.myEditor.offsetToLogicalPosition(CaretImpl.this.myOffset);
                if (!positionByOffsetAfterMove.equals((Object)logicalPosition)) {
                    StringBuilder debugBuffer = new StringBuilder();
                    CaretImpl.this.moveToLogicalPosition(logicalPosition, locateBeforeSoftWrap, debugBuffer, true);
                    int textStart = Math.max(0, Math.min(offset, CaretImpl.this.myOffset) - 1);
                    DocumentEx document = CaretImpl.this.myEditor.getDocument();
                    int textEnd = Math.min(document.getTextLength() - 1, Math.max(offset, CaretImpl.this.myOffset) + 1);
                    CharSequence text = document.getCharsSequence().subSequence(textStart, textEnd);
                    int inverseOffset = CaretImpl.this.myEditor.logicalPositionToOffset(logicalPosition);
                    LogMessageEx.error(LOG, "caret moved to wrong offset. Please submit a dedicated ticket and attach current editor's text to it.", "Requested: offset=" + offset + ", logical position='" + logicalPosition + "' but actual: offset=" + CaretImpl.this.myOffset + ", logical position='" + CaretImpl.this.myLogicalCaret + "' (" + positionByOffsetAfterMove + "). " + CaretImpl.this.myEditor.dumpState() + "\ninterested text [" + textStart + ";" + textEnd + "): '" + text + "'\n debug trace: " + debugBuffer + "\nLogical position -> offset ('" + logicalPosition + "'->'" + inverseOffset + "')");
                }
                if (event != null) {
                    CaretImpl.this.myEditor.getCaretModel().fireCaretPositionChanged(event);
                    EditorActionUtil.selectNonexpandableFold(CaretImpl.this.myEditor);
                }
            }
        });
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModelImpl caretModelImpl = this.myEditor.getCaretModel();
        if (caretModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getCaretModel"));
        }
        return caretModelImpl;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void moveCaretRelatively(final int columnShift, final int lineShift, final boolean withSelection, final boolean scrollToCaret) {
        CaretImpl.assertIsDispatchThread();
        if (this.mySkipChangeRequests) {
            return;
        }
        if (this.myReportCaretMoves) {
            LogMessageEx.error(LOG, "Unexpected caret move request", new String[0]);
        }
        if (!this.myEditor.isStickySelection() && !this.myEditor.getCaretModel().isDocumentChanged) {
            CopyPasteManager.getInstance().stopKillRings();
        }
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                boolean newLeansRight;
                int oldOffset = CaretImpl.this.myOffset;
                int leadSelectionOffset = CaretImpl.this.getLeadSelectionOffset();
                VisualPosition leadSelectionPosition = CaretImpl.this.getLeadSelectionPosition();
                EditorSettings editorSettings = CaretImpl.this.myEditor.getSettings();
                VisualPosition visualCaret = CaretImpl.this.getVisualPosition();
                int lastColumnNumber = CaretImpl.this.myLastColumnNumber;
                int desiredX = CaretImpl.this.myDesiredX;
                if (columnShift == 0) {
                    if (CaretImpl.this.myDesiredX < 0) {
                        desiredX = CaretImpl.this.getCurrentX();
                    }
                } else {
                    desiredX = -1;
                    CaretImpl.this.myDesiredX = -1;
                }
                int newLineNumber = visualCaret.line + lineShift;
                int newColumnNumber = visualCaret.column + columnShift;
                boolean bl = lineShift == 0 && columnShift != 0 ? columnShift < 0 : (newLeansRight = visualCaret.leansRight);
                if (desiredX >= 0) {
                    newColumnNumber = ((CaretImpl)CaretImpl.this).myEditor.xyToVisualPosition((Point)new Point((int)desiredX, (int)(Math.max((int)0, (int)newLineNumber) * ((CaretImpl)CaretImpl.this).myEditor.getLineHeight()))).column;
                }
                DocumentEx document = CaretImpl.this.myEditor.getDocument();
                if (!editorSettings.isVirtualSpace() && lineShift == 0 && columnShift == 1) {
                    int lastLine = document.getLineCount() - 1;
                    if (lastLine < 0) {
                        lastLine = 0;
                    }
                    if (newColumnNumber > EditorUtil.getLastVisualLineColumnNumber(CaretImpl.this.myEditor, newLineNumber) && newLineNumber < ((CaretImpl)CaretImpl.this).myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lastLine, (int)0)).line) {
                        newColumnNumber = 0;
                        ++newLineNumber;
                    }
                } else if (!editorSettings.isVirtualSpace() && lineShift == 0 && columnShift == -1 && newColumnNumber < 0 && newLineNumber > 0) {
                    newColumnNumber = EditorUtil.getLastVisualLineColumnNumber(CaretImpl.this.myEditor, --newLineNumber);
                }
                if (newColumnNumber < 0) {
                    newColumnNumber = 0;
                }
                boolean selectToDocumentStart = false;
                if (newLineNumber < 0) {
                    selectToDocumentStart = true;
                    newLineNumber = 0;
                    newColumnNumber = 0;
                    desiredX = -1;
                    lastColumnNumber = -1;
                }
                VisualPosition pos = new VisualPosition(newLineNumber, newColumnNumber);
                if (!CaretImpl.this.myEditor.getSoftWrapModel().isInsideSoftWrap(pos)) {
                    int lastOffsetColumn;
                    LogicalPosition log = CaretImpl.this.myEditor.visualToLogicalPosition(new VisualPosition(newLineNumber, newColumnNumber, newLeansRight));
                    int offset = CaretImpl.this.myEditor.logicalPositionToOffset(log);
                    if (!(offset < document.getTextLength() || ((CaretImpl)CaretImpl.this).myEditor.myUseNewRendering && columnShift != 0 || (lastOffsetColumn = ((CaretImpl)CaretImpl.this).myEditor.offsetToVisualPosition((int)document.getTextLength(), (boolean)true, (boolean)false).column) <= newColumnNumber)) {
                        newColumnNumber = lastOffsetColumn;
                        newLeansRight = true;
                        desiredX = -1;
                        lastColumnNumber = -1;
                    }
                    if (!editorSettings.isCaretInsideTabs()) {
                        CharSequence text = document.getCharsSequence();
                        if (offset >= 0 && offset < document.getTextLength() && text.charAt(offset) == '\t' && (columnShift <= 0 || offset == CaretImpl.this.myOffset)) {
                            SoftWrap softWrap;
                            newColumnNumber = columnShift <= 0 ? ((CaretImpl)CaretImpl.this).myEditor.offsetToVisualPosition((int)offset, (boolean)true, (boolean)false).column : ((softWrap = CaretImpl.this.myEditor.getSoftWrapModel().getSoftWrap(offset + 1)) == null ? ((CaretImpl)CaretImpl.this).myEditor.offsetToVisualPosition((int)(offset + 1)).column : EditorUtil.getLastVisualLineColumnNumber(CaretImpl.this.myEditor, newLineNumber));
                        }
                    }
                }
                pos = new VisualPosition(newLineNumber, newColumnNumber, newLeansRight);
                if (columnShift != 0 && lineShift == 0 && CaretImpl.this.myEditor.getSoftWrapModel().isInsideSoftWrap(pos)) {
                    LogicalPosition logical = CaretImpl.this.myEditor.visualToLogicalPosition(pos);
                    int softWrapOffset = CaretImpl.this.myEditor.logicalPositionToOffset(logical);
                    if (columnShift >= 0) {
                        CaretImpl.this.moveToOffset(softWrapOffset);
                    } else {
                        int line = CaretImpl.this.myEditor.offsetToVisualLine(softWrapOffset - 1);
                        CaretImpl.this.moveToVisualPosition(new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(CaretImpl.this.myEditor, line)));
                    }
                } else {
                    CaretImpl.this.moveToVisualPosition(pos);
                    if (!editorSettings.isVirtualSpace() && columnShift == 0 && lastColumnNumber >= 0) {
                        CaretImpl.this.setLastColumnNumber(lastColumnNumber);
                    }
                }
                if (withSelection) {
                    if (selectToDocumentStart) {
                        CaretImpl.this.setSelection(leadSelectionPosition, leadSelectionOffset, CaretImpl.this.myEditor.offsetToVisualPosition(0), 0);
                    } else if (pos.line >= CaretImpl.this.myEditor.getVisibleLineCount()) {
                        int endOffset = document.getTextLength();
                        if (leadSelectionOffset < endOffset) {
                            CaretImpl.this.setSelection(leadSelectionPosition, leadSelectionOffset, CaretImpl.this.myEditor.offsetToVisualPosition(endOffset), endOffset);
                        }
                    } else {
                        int selectionStartToUse = leadSelectionOffset;
                        VisualPosition selectionStartPositionToUse = leadSelectionPosition;
                        if (CaretImpl.this.isUnknownDirection() || oldOffset > CaretImpl.this.getSelectionStart() && oldOffset < CaretImpl.this.getSelectionEnd()) {
                            if (CaretImpl.this.getOffset() > leadSelectionOffset ^ CaretImpl.this.getSelectionStart() < CaretImpl.this.getSelectionEnd()) {
                                selectionStartToUse = CaretImpl.this.getSelectionEnd();
                                selectionStartPositionToUse = CaretImpl.this.getSelectionEndPosition();
                            } else {
                                selectionStartToUse = CaretImpl.this.getSelectionStart();
                                selectionStartPositionToUse = CaretImpl.this.getSelectionStartPosition();
                            }
                        }
                        CaretImpl.this.setSelection(selectionStartPositionToUse, selectionStartToUse, CaretImpl.this.getVisualPosition(), CaretImpl.this.getOffset());
                    }
                } else {
                    CaretImpl.this.removeSelection();
                }
                if (scrollToCaret) {
                    CaretImpl.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
                if (desiredX >= 0) {
                    CaretImpl.this.myDesiredX = desiredX;
                }
                EditorActionUtil.selectNonexpandableFold(CaretImpl.this.myEditor);
            }
        });
    }

    public void moveToLogicalPosition(final @NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToLogicalPosition"));
        }
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                CaretImpl.this.moveToLogicalPosition(pos, false, null, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaretEvent doMoveToLogicalPosition(@NotNull LogicalPosition pos, boolean locateBeforeSoftWrap, @NonNls @Nullable StringBuilder debugBuffer, boolean fireListeners) {
        int lineToUse;
        FoldRegion collapsedAt;
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "doMoveToLogicalPosition"));
        }
        CaretImpl.assertIsDispatchThread();
        if (debugBuffer != null) {
            debugBuffer.append("Start moveToLogicalPosition(). Locate before soft wrap: ").append(locateBeforeSoftWrap).append(", position: ").append(pos).append("\n");
        }
        this.myDesiredX = -1;
        this.validateCallContext();
        int column = pos.column;
        int line = pos.line;
        int softWrapLinesBefore = pos.softWrapLinesBeforeCurrentLogicalLine;
        int softWrapLinesCurrent = pos.softWrapLinesOnCurrentLogicalLine;
        int softWrapColumns = pos.softWrapColumnDiff;
        boolean leansForward = pos.leansForward;
        boolean leansRight = pos.visualPositionLeansRight;
        DocumentEx doc = this.myEditor.getDocument();
        int lineCount = doc.getLineCount();
        if (lineCount == 0) {
            if (debugBuffer != null) {
                debugBuffer.append("Resetting target logical line to zero as the document is empty\n");
            }
            line = 0;
        } else if (line > lineCount - 1) {
            if (debugBuffer != null) {
                debugBuffer.append("Resetting target logical line (").append(line).append(") to ").append(lineCount - 1).append(" as it is greater than total document lines number\n");
            }
            line = lineCount - 1;
            softWrapLinesBefore = 0;
            softWrapLinesCurrent = 0;
        }
        EditorSettings editorSettings = this.myEditor.getSettings();
        if (!editorSettings.isVirtualSpace() && line < lineCount) {
            int lineEndOffset = doc.getLineEndOffset(line);
            LogicalPosition endLinePosition = this.myEditor.offsetToLogicalPosition(lineEndOffset);
            int lineEndColumnNumber = endLinePosition.column;
            if (column > lineEndColumnNumber) {
                int oldColumn = column;
                column = lineEndColumnNumber;
                leansForward = true;
                leansRight = true;
                if (softWrapColumns != 0) {
                    softWrapColumns -= column - lineEndColumnNumber;
                }
                if (debugBuffer != null) {
                    debugBuffer.append("Resetting target logical column (").append(oldColumn).append(") to ").append(lineEndColumnNumber).append(" because caret is not allowed to be located after line end (offset: ").append(lineEndOffset).append(", ").append("logical position: ").append(endLinePosition).append("). Current soft wrap columns value: ").append(softWrapColumns).append("\n");
                }
            }
        }
        this.myEditor.getFoldingModel().flushCaretPosition();
        VerticalInfo oldInfo = this.myCaretInfo;
        LogicalPosition oldCaretPosition = this.myLogicalCaret;
        LogicalPosition logicalPositionToUse = pos.visualPositionAware ? new LogicalPosition(line, column, softWrapLinesBefore, softWrapLinesCurrent, softWrapColumns, pos.foldedLines, pos.foldingColumnDiff, leansForward, leansRight) : new LogicalPosition(line, column, leansForward);
        final int offset = this.myEditor.logicalPositionToOffset(logicalPositionToUse);
        if (debugBuffer != null) {
            debugBuffer.append("Resulting logical position to use: ").append(logicalPositionToUse).append(". It's mapped to offset ").append(offset).append("\n");
        }
        if ((collapsedAt = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset)) != null && offset > collapsedAt.getStartOffset()) {
            if (debugBuffer != null) {
                debugBuffer.append("Scheduling expansion of fold region ").append(collapsedAt).append("\n");
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FoldRegion[] allCollapsedAt;
                    for (FoldRegion foldRange : allCollapsedAt = CaretImpl.this.myEditor.getFoldingModel().fetchCollapsedAt(offset)) {
                        foldRange.setExpanded(true);
                    }
                }
            };
            this.mySkipChangeRequests = true;
            try {
                this.myEditor.getFoldingModel().runBatchFoldingOperation(runnable, false);
            }
            finally {
                this.mySkipChangeRequests = false;
            }
            logicalPositionToUse = logicalPositionToUse.visualPositionAware ? logicalPositionToUse.withoutVisualPositionInfo() : logicalPositionToUse;
        }
        this.setCurrentLogicalCaret(logicalPositionToUse);
        this.setLastColumnNumber(this.myLogicalCaret.column);
        this.myDesiredSelectionEndColumn = -1;
        this.myDesiredSelectionStartColumn = -1;
        this.myVisibleCaret = this.myEditor.logicalToVisualPosition(this.myLogicalCaret);
        this.updateOffsetsFromLogicalPosition();
        if (debugBuffer != null) {
            debugBuffer.append("Storing offset ").append(this.myOffset).append(" (mapped from logical position ").append(this.myLogicalCaret).append(")\n");
        }
        LOG.assertTrue(this.myOffset >= 0 && this.myOffset <= this.myEditor.getDocument().getTextLength());
        this.updateVisualLineInfo();
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldInfo);
        if (locateBeforeSoftWrap && SoftWrapHelper.isCaretAfterSoftWrap(this) && (lineToUse = this.myVisibleCaret.line - 1) >= 0) {
            LogicalPosition logicalPosition;
            int tmpOffset;
            VisualPosition visualPosition = new VisualPosition(lineToUse, EditorUtil.getLastVisualLineColumnNumber(this.myEditor, lineToUse));
            if (debugBuffer != null) {
                debugBuffer.append("Adjusting caret position by moving it before soft wrap. Moving to visual position ").append(visualPosition).append("\n");
            }
            if ((tmpOffset = this.myEditor.logicalPositionToOffset(logicalPosition = this.myEditor.visualToLogicalPosition(visualPosition))) == this.myOffset) {
                boolean restore = this.myReportCaretMoves;
                this.myReportCaretMoves = false;
                try {
                    this.moveToVisualPosition(visualPosition);
                    CaretEvent caretEvent = null;
                    return caretEvent;
                }
                finally {
                    this.myReportCaretMoves = restore;
                }
            }
            LogMessageEx.error(LOG, "Invalid editor dimension mapping", "Expected to map visual position '" + visualPosition + "' to offset " + this.myOffset + " but got the following: -> logical position '" + logicalPosition + "'; -> offset " + tmpOffset + ". State: " + this.myEditor.dumpState());
        }
        if (!oldCaretPosition.toVisualPosition().equals((Object)this.myLogicalCaret.toVisualPosition())) {
            CaretEvent event = new CaretEvent((Editor)this.myEditor, (Caret)this, oldCaretPosition, this.myLogicalCaret);
            if (fireListeners) {
                this.myEditor.getCaretModel().fireCaretPositionChanged(event);
            } else {
                return event;
            }
        }
        return null;
    }

    private void updateOffsetsFromLogicalPosition() {
        this.myOffset = this.myEditor.logicalPositionToOffset(this.myLogicalCaret);
        this.myVirtualSpaceOffset = this.myLogicalCaret.column - this.myEditor.offsetToLogicalPosition((int)this.myOffset).column;
    }

    private void setLastColumnNumber(int lastColumnNumber) {
        this.myLastColumnNumber = lastColumnNumber;
        this.myEditor.setLastColumnNumber(lastColumnNumber);
    }

    private void requestRepaint(VerticalInfo oldCaretInfo) {
        int lineHeight = this.myEditor.getLineHeight();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        EditorGutterComponentImpl gutter = this.myEditor.getGutterComponentEx();
        EditorComponentImpl content = this.myEditor.getContentComponent();
        int updateWidth = this.myEditor.getScrollPane().getHorizontalScrollBar().getValue() + visibleArea.width;
        if (Math.abs(this.myCaretInfo.y - oldCaretInfo.y) <= 2 * lineHeight) {
            int minY = Math.min(oldCaretInfo.y, this.myCaretInfo.y);
            int maxY = Math.max(oldCaretInfo.y + oldCaretInfo.height, this.myCaretInfo.y + this.myCaretInfo.height);
            content.repaintEditorComponent(0, minY, updateWidth, maxY - minY);
            gutter.repaint(0, minY, gutter.getWidth(), maxY - minY);
        } else {
            content.repaintEditorComponent(0, oldCaretInfo.y, updateWidth, oldCaretInfo.height + lineHeight);
            gutter.repaint(0, oldCaretInfo.y, updateWidth, oldCaretInfo.height + lineHeight);
            content.repaintEditorComponent(0, this.myCaretInfo.y, updateWidth, this.myCaretInfo.height + lineHeight);
            gutter.repaint(0, this.myCaretInfo.y, updateWidth, this.myCaretInfo.height + lineHeight);
        }
    }

    public void moveToVisualPosition(final @NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToVisualPosition"));
        }
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                CaretImpl.this.moveToVisualPosition(pos, true);
            }
        });
    }

    void moveToVisualPosition(@NotNull VisualPosition pos, boolean fireListeners) {
        EditorSettings editorSettings;
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToVisualPosition"));
        }
        CaretImpl.assertIsDispatchThread();
        this.validateCallContext();
        if (this.mySkipChangeRequests) {
            return;
        }
        if (this.myReportCaretMoves) {
            LogMessageEx.error(LOG, "Unexpected caret move request", new String[0]);
        }
        if (!(this.myEditor.isStickySelection() || this.myEditor.getCaretModel().isDocumentChanged || pos.equals((Object)this.myVisibleCaret))) {
            CopyPasteManager.getInstance().stopKillRings();
        }
        this.myDesiredX = -1;
        int column = pos.column;
        int line = pos.line;
        boolean leanRight = pos.leansRight;
        int lastLine = this.myEditor.getVisibleLineCount() - 1;
        if (lastLine <= 0) {
            lastLine = 0;
        }
        if (line > lastLine) {
            line = lastLine;
        }
        if (!(editorSettings = this.myEditor.getSettings()).isVirtualSpace()) {
            int lineEndColumn = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, line);
            if (!(column <= lineEndColumn || this.myEditor.myUseNewRendering && this.myEditor.getSoftWrapModel().isInsideSoftWrap(pos))) {
                column = lineEndColumn;
                leanRight = true;
            }
            if (!this.myEditor.myUseNewRendering && column < 0 && line > 0) {
                column = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, --line);
            }
        }
        this.myVisibleCaret = new VisualPosition(line, column, leanRight);
        VerticalInfo oldInfo = this.myCaretInfo;
        LogicalPosition oldPosition = this.myLogicalCaret;
        this.setCurrentLogicalCaret(this.myEditor.visualToLogicalPosition(this.myVisibleCaret));
        this.updateOffsetsFromLogicalPosition();
        LOG.assertTrue(this.myOffset >= 0 && this.myOffset <= this.myEditor.getDocument().getTextLength());
        this.updateVisualLineInfo();
        this.myEditor.getFoldingModel().flushCaretPosition();
        this.setLastColumnNumber(this.myLogicalCaret.column);
        this.myDesiredSelectionEndColumn = -1;
        this.myDesiredSelectionStartColumn = -1;
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldInfo);
        if (fireListeners && !oldPosition.equals((Object)this.myLogicalCaret)) {
            CaretEvent event = new CaretEvent((Editor)this.myEditor, (Caret)this, oldPosition, this.myLogicalCaret);
            this.myEditor.getCaretModel().fireCaretPositionChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CaretEvent moveToLogicalPosition(@NotNull LogicalPosition pos, boolean locateBeforeSoftWrap, @Nullable StringBuilder debugBuffer, boolean fireListeners) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToLogicalPosition"));
        }
        if (this.mySkipChangeRequests) {
            return null;
        }
        if (this.myReportCaretMoves) {
            LogMessageEx.error(LOG, "Unexpected caret move request", new String[0]);
        }
        if (!(this.myEditor.isStickySelection() || this.myEditor.getCaretModel().isDocumentChanged || pos.equals((Object)this.myLogicalCaret))) {
            CopyPasteManager.getInstance().stopKillRings();
        }
        this.myReportCaretMoves = true;
        try {
            CaretEvent caretEvent = this.doMoveToLogicalPosition(pos, locateBeforeSoftWrap, debugBuffer, fireListeners);
            return caretEvent;
        }
        finally {
            this.myReportCaretMoves = false;
        }
    }

    private static void assertIsDispatchThread() {
        EditorImpl.assertIsDispatchThread();
    }

    private void validateCallContext() {
        LOG.assertTrue(!this.myEditor.getCaretModel().myIsInUpdate, (Object)"Caret model is in its update process. All requests are illegal at this point.");
    }

    private void releaseBulkCaretMarker() {
        if (this.savedBeforeBulkCaretMarker != null) {
            this.savedBeforeBulkCaretMarker.dispose();
            this.savedBeforeBulkCaretMarker = null;
        }
    }

    public void dispose() {
        if (this.mySelectionMarker != null) {
            this.mySelectionMarker.dispose();
            this.mySelectionMarker = null;
        }
        this.releaseBulkCaretMarker();
        this.isValid = false;
    }

    public boolean isUpToDate() {
        return !this.myEditor.getCaretModel().myIsInUpdate && !this.myReportCaretMoves;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        this.validateCallContext();
        LogicalPosition logicalPosition = this.myLogicalCaret;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        this.validateCallContext();
        VisualPosition visualPosition = this.myVisibleCaret;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getVisualPosition"));
        }
        return visualPosition;
    }

    public int getOffset() {
        this.validateCallContext();
        return this.myOffset;
    }

    public int getVisualLineStart() {
        return this.myVisualLineStart;
    }

    public int getVisualLineEnd() {
        return this.myVisualLineEnd;
    }

    @NotNull
    private VerticalInfo createVerticalInfo(LogicalPosition position) {
        int lineHeight;
        int logicalLine = position.line;
        DocumentEx document = this.myEditor.getDocument();
        if (logicalLine >= document.getLineCount()) {
            logicalLine = Math.max(0, document.getLineCount() - 1);
        }
        int startOffset = document.getLineStartOffset(logicalLine);
        int endOffset = document.getLineEndOffset(logicalLine);
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(document.getLineStartOffset(logicalLine));
        int y = this.myEditor.myUseNewRendering ? this.myEditor.visibleLineToY(visualPosition.line) : this.myEditor.visualPositionToXY((VisualPosition)visualPosition).y;
        int height = lineHeight = this.myEditor.getLineHeight();
        List<? extends SoftWrap> softWraps = this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset);
        for (SoftWrap softWrap : softWraps) {
            height += StringUtil.countNewLines((CharSequence)softWrap.getText()) * lineHeight;
        }
        VerticalInfo verticalInfo = new VerticalInfo(y, height);
        if (verticalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "createVerticalInfo"));
        }
        return verticalInfo;
    }

    void updateVisualPosition() {
        VerticalInfo oldInfo = this.myCaretInfo;
        LogicalPosition visUnawarePos = new LogicalPosition(this.myLogicalCaret.line, this.myLogicalCaret.column);
        this.setCurrentLogicalCaret(visUnawarePos);
        this.myVisibleCaret = this.myEditor.logicalToVisualPosition(this.myLogicalCaret);
        this.updateVisualLineInfo();
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldInfo);
    }

    private void updateVisualLineInfo() {
        this.myVisualLineStart = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line, 0)));
        this.myVisualLineEnd = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line + 1, 0)));
    }

    void updateCaretPosition(@NotNull DocumentEventImpl event) {
        boolean performSoftWrapAdjustment;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/CaretImpl", "updateCaretPosition"));
        }
        DocumentEx document = this.myEditor.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        boolean bl = performSoftWrapAdjustment = event.getNewLength() > 0 || this.myEditor.getSoftWrapModel().getSoftWrap(event.getOffset()) != null;
        if (event.isWholeTextReplaced()) {
            int newLength = document.getTextLength();
            if (this.myOffset == newLength - event.getNewLength() + event.getOldLength() || newLength == 0) {
                this.moveToOffset(newLength, performSoftWrapAdjustment);
            } else {
                try {
                    int line = event.translateLineViaDiff(this.myLogicalCaret.line);
                    this.moveToLogicalPosition(new LogicalPosition(line, this.myLogicalCaret.column), performSoftWrapAdjustment, null, true);
                }
                catch (FilesTooBigForDiffException e1) {
                    LOG.info((Throwable)e1);
                    this.moveToOffset(0);
                }
            }
        } else {
            int startOffset = event.getOffset();
            int oldEndOffset = startOffset + event.getOldLength();
            int newOffset = this.myOffset;
            if (this.myOffset > oldEndOffset || this.myOffset == oldEndOffset && this.needToShiftWhiteSpaces(event)) {
                newOffset += event.getNewLength() - event.getOldLength();
            } else if (this.myOffset >= startOffset && this.myOffset <= oldEndOffset) {
                newOffset = Math.min(newOffset, startOffset + event.getNewLength());
            }
            newOffset = Math.min(newOffset, document.getTextLength());
            if (this.myOffset != startOffset) {
                LogicalPosition pos = this.myEditor.offsetToLogicalPosition(newOffset);
                this.moveToLogicalPosition(new LogicalPosition(pos.line, pos.column + this.myVirtualSpaceOffset), performSoftWrapAdjustment, null, true);
            } else {
                this.moveToOffset(newOffset, performSoftWrapAdjustment);
            }
        }
        this.updateVisualLineInfo();
    }

    private boolean needToShiftWhiteSpaces(DocumentEvent e) {
        if (!CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)e.getNewFragment()) || CharArrayUtil.containLineBreaks((CharSequence)e.getNewFragment())) {
            return e.getOldLength() > 0;
        }
        if (e.getOffset() == 0) {
            return false;
        }
        char charBefore = this.myEditor.getDocument().getCharsSequence().charAt(e.getOffset() - 1);
        return Character.isWhitespace(charBefore);
    }

    private void setCurrentLogicalCaret(@NotNull LogicalPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/CaretImpl", "setCurrentLogicalCaret"));
        }
        this.myLogicalCaret = position;
        this.myCaretInfo = this.createVerticalInfo(position);
    }

    int getWordAtCaretStart() {
        int newOffset;
        DocumentEx document = this.myEditor.getDocument();
        int offset = this.getOffset();
        if (offset == 0) {
            return 0;
        }
        int lineNumber = this.getLogicalPosition().line;
        int minOffset = lineNumber > 0 ? document.getLineEndOffset(lineNumber - 1) : 0;
        boolean camel = this.myEditor.getSettings().isCamelWords();
        for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordOrLexemeStart(this.myEditor, newOffset, camel); --newOffset) {
        }
        return newOffset;
    }

    int getWordAtCaretEnd() {
        DocumentEx document = this.myEditor.getDocument();
        int offset = this.getOffset();
        if (offset >= document.getTextLength() - 1 || document.getLineCount() == 0) {
            return offset;
        }
        int newOffset = offset + 1;
        int lineNumber = this.getLogicalPosition().line;
        int maxOffset = document.getLineEndOffset(lineNumber);
        if (newOffset > maxOffset) {
            if (lineNumber + 1 >= document.getLineCount()) {
                return offset;
            }
            maxOffset = document.getLineEndOffset(lineNumber + 1);
        }
        boolean camel = this.myEditor.getSettings().isCamelWords();
        while (newOffset < maxOffset && !EditorActionUtil.isWordOrLexemeEnd(this.myEditor, newOffset, camel)) {
            ++newOffset;
        }
        return newOffset;
    }

    private CaretImpl cloneWithoutSelection() {
        CaretImpl clone = new CaretImpl(this.myEditor);
        clone.myLogicalCaret = this.myLogicalCaret;
        clone.myCaretInfo = this.myCaretInfo;
        clone.myVisibleCaret = this.myVisibleCaret;
        clone.myOffset = this.myOffset;
        clone.myVirtualSpaceOffset = this.myVirtualSpaceOffset;
        clone.myVisualLineStart = this.myVisualLineStart;
        clone.myVisualLineEnd = this.myVisualLineEnd;
        clone.savedBeforeBulkCaretMarker = this.savedBeforeBulkCaretMarker;
        clone.mySkipChangeRequests = this.mySkipChangeRequests;
        clone.myLastColumnNumber = this.myLastColumnNumber;
        clone.myReportCaretMoves = this.myReportCaretMoves;
        clone.myDesiredX = this.myDesiredX;
        clone.myDesiredSelectionStartColumn = -1;
        clone.myDesiredSelectionEndColumn = -1;
        return clone;
    }

    @Nullable
    public Caret clone(boolean above) {
        boolean hasNewSelection;
        VisualPosition newSelectionEndPosition;
        VisualPosition newSelectionStartPosition;
        int newSelectionEndOffset;
        int newSelectionStartOffset;
        int newSelectionEndColumn;
        int newSelectionStartColumn;
        CaretImpl.assertIsDispatchThread();
        int lineShift = above ? -1 : 1;
        final CaretImpl clone = this.cloneWithoutSelection();
        if (this.hasSelection() || this.myDesiredSelectionStartColumn >= 0 || this.myDesiredSelectionEndColumn >= 0) {
            VisualPosition startPosition = this.getSelectionStartPosition();
            VisualPosition endPosition = this.getSelectionEndPosition();
            VisualPosition leadPosition = this.getLeadSelectionPosition();
            boolean leadIsStart = leadPosition.equals((Object)startPosition);
            boolean leadIsEnd = leadPosition.equals((Object)endPosition);
            LogicalPosition selectionStart = this.myEditor.visualToLogicalPosition(leadIsStart || leadIsEnd ? leadPosition : startPosition);
            LogicalPosition selectionEnd = this.myEditor.visualToLogicalPosition(leadIsEnd ? startPosition : endPosition);
            newSelectionStartColumn = this.myDesiredSelectionStartColumn < 0 ? selectionStart.column : this.myDesiredSelectionStartColumn;
            newSelectionEndColumn = this.myDesiredSelectionEndColumn < 0 ? selectionEnd.column : this.myDesiredSelectionEndColumn;
            LogicalPosition newSelectionStart = this.truncate(selectionStart.line + lineShift, newSelectionStartColumn);
            LogicalPosition newSelectionEnd = this.truncate(selectionEnd.line + lineShift, newSelectionEndColumn);
            newSelectionStartOffset = this.myEditor.logicalPositionToOffset(newSelectionStart);
            newSelectionEndOffset = this.myEditor.logicalPositionToOffset(newSelectionEnd);
            newSelectionStartPosition = this.myEditor.logicalToVisualPosition(newSelectionStart);
            newSelectionEndPosition = this.myEditor.logicalToVisualPosition(newSelectionEnd);
            hasNewSelection = !newSelectionStart.equals((Object)newSelectionEnd);
        } else {
            newSelectionStartOffset = 0;
            newSelectionEndOffset = 0;
            newSelectionStartPosition = null;
            newSelectionEndPosition = null;
            hasNewSelection = false;
            newSelectionStartColumn = -1;
            newSelectionEndColumn = -1;
        }
        LogicalPosition oldPosition = this.getLogicalPosition();
        int newLine = oldPosition.line + lineShift;
        if (newLine < 0 || newLine >= this.myEditor.getDocument().getLineCount()) {
            Disposer.dispose((Disposable)clone);
            return null;
        }
        clone.moveToLogicalPosition(new LogicalPosition(newLine, this.myLastColumnNumber), false, null, false);
        clone.myLastColumnNumber = this.myLastColumnNumber;
        clone.myDesiredX = this.myDesiredX >= 0 ? this.myDesiredX : this.getCurrentX();
        clone.myDesiredSelectionStartColumn = newSelectionStartColumn;
        clone.myDesiredSelectionEndColumn = newSelectionEndColumn;
        if (this.myEditor.getCaretModel().addCaret(clone)) {
            if (hasNewSelection) {
                this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

                    @Override
                    public void run() {
                        clone.setSelection(newSelectionStartPosition, newSelectionStartOffset, newSelectionEndPosition, newSelectionEndOffset);
                    }
                });
                if (!clone.isValid()) {
                    return null;
                }
            }
            this.myEditor.getScrollingModel().scrollTo(clone.getLogicalPosition(), ScrollType.RELATIVE);
            return clone;
        }
        Disposer.dispose((Disposable)clone);
        return null;
    }

    private LogicalPosition truncate(int line, int column) {
        if (line < 0) {
            return new LogicalPosition(0, 0);
        }
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return this.myEditor.offsetToLogicalPosition(this.myEditor.getDocument().getTextLength());
        }
        return new LogicalPosition(line, column);
    }

    boolean isUnknownDirection() {
        return this.myUnknownDirection;
    }

    void setUnknownDirection(boolean unknownDirection) {
        this.myUnknownDirection = unknownDirection;
    }

    public int getSelectionStart() {
        RangeMarker marker;
        this.validateContext(false);
        if (this.hasSelection() && (marker = this.mySelectionMarker) != null) {
            return marker.getStartOffset();
        }
        return this.getOffset();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition position;
        this.validateContext(false);
        if (this.hasSelection() && this.mySelectionMarker != null) {
            position = this.getRangeMarkerStartPosition();
            if (position == null) {
                VisualPosition endPosition;
                VisualPosition startPosition = this.myEditor.offsetToVisualPosition(this.mySelectionMarker.getStartOffset(), true, false);
                position = startPosition.after(endPosition = this.myEditor.offsetToVisualPosition(this.mySelectionMarker.getEndOffset(), false, true)) ? endPosition : startPosition;
            }
        } else {
            VisualPosition visualPosition = position = this.isVirtualSelectionEnabled() ? this.getVisualPosition() : this.myEditor.offsetToVisualPosition(this.getOffset(), this.myLogicalCaret.leansForward, false);
        }
        if (this.hasVirtualSelection()) {
            position = new VisualPosition(position.line, position.column + this.myStartVirtualOffset);
        }
        VisualPosition visualPosition = position;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getSelectionStartPosition"));
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        RangeMarker marker;
        this.validateContext(false);
        if (this.hasSelection() && (marker = this.mySelectionMarker) != null) {
            return marker.getEndOffset();
        }
        return this.getOffset();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition position;
        this.validateContext(false);
        if (this.hasSelection() && this.mySelectionMarker != null) {
            position = this.getRangeMarkerEndPosition();
            if (position == null) {
                VisualPosition endPosition;
                VisualPosition startPosition = this.myEditor.offsetToVisualPosition(this.mySelectionMarker.getStartOffset(), true, false);
                position = startPosition.after(endPosition = this.myEditor.offsetToVisualPosition(this.mySelectionMarker.getEndOffset(), false, true)) ? startPosition : endPosition;
            }
        } else {
            VisualPosition visualPosition = position = this.isVirtualSelectionEnabled() ? this.getVisualPosition() : this.myEditor.offsetToVisualPosition(this.getOffset(), this.myLogicalCaret.leansForward, false);
        }
        if (this.hasVirtualSelection()) {
            position = new VisualPosition(position.line, position.column + this.myEndVirtualOffset);
        }
        VisualPosition visualPosition = position;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getSelectionEndPosition"));
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        this.validateContext(false);
        RangeMarker marker = this.mySelectionMarker;
        return marker != null && marker.isValid() && (marker.getEndOffset() > marker.getStartOffset() || this.isVirtualSelectionEnabled() && this.myEndVirtualOffset > this.myStartVirtualOffset);
    }

    public void setSelection(int startOffset, int endOffset) {
        this.setSelection(startOffset, endOffset, true);
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.doSetSelection(this.myEditor.offsetToVisualPosition(startOffset, true, false), startOffset, this.myEditor.offsetToVisualPosition(endOffset, false, true), endOffset, false, updateSystemSelection);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        VisualPosition startPosition = this.hasSelection() ? this.getLeadSelectionPosition() : this.myEditor.offsetToVisualPosition(startOffset, true, false);
        this.setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startPosition, startOffset, endPosition, endOffset, true);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        VisualPosition startPositionToUse = startPosition == null ? this.myEditor.offsetToVisualPosition(startOffset, true, false) : startPosition;
        VisualPosition endPositionToUse = endPosition == null ? this.myEditor.offsetToVisualPosition(endOffset, false, true) : endPosition;
        this.doSetSelection(startPositionToUse, startOffset, endPositionToUse, endOffset, true, updateSystemSelection);
    }

    private void doSetSelection(final @NotNull VisualPosition startPosition, final int _startOffset, final @NotNull VisualPosition endPosition, final int _endOffset, final boolean visualPositionAware, final boolean updateSystemSelection) {
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/CaretImpl", "doSetSelection"));
        }
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/CaretImpl", "doSetSelection"));
        }
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                RangeMarker marker;
                int oldSelectionEnd;
                int oldSelectionStart;
                FoldRegion endFold;
                FoldingModelImpl foldingModel;
                FoldRegion startFold;
                int startOffset = _startOffset;
                int endOffset = _endOffset;
                CaretImpl.this.myUnknownDirection = false;
                DocumentEx doc = CaretImpl.this.myEditor.getDocument();
                CaretImpl.this.validateContext(true);
                int textLength = doc.getTextLength();
                if (startOffset < 0 || startOffset > textLength) {
                    LOG.error("Wrong startOffset: " + startOffset + ", textLength=" + textLength);
                }
                if (endOffset < 0 || endOffset > textLength) {
                    LOG.error("Wrong endOffset: " + endOffset + ", textLength=" + textLength);
                }
                if (!visualPositionAware && startOffset == endOffset) {
                    CaretImpl.this.removeSelection();
                    return;
                }
                boolean switchedOffsets = false;
                if (startOffset > endOffset) {
                    int tmp = startOffset;
                    startOffset = endOffset;
                    endOffset = tmp;
                    switchedOffsets = true;
                }
                if ((startFold = (foldingModel = CaretImpl.this.myEditor.getFoldingModel()).getCollapsedRegionAtOffset(startOffset)) != null && startFold.getStartOffset() < startOffset) {
                    startOffset = startFold.getStartOffset();
                }
                if ((endFold = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && endFold.getStartOffset() < endOffset) {
                    endOffset = endFold.getEndOffset();
                }
                if (CaretImpl.this.hasSelection()) {
                    oldSelectionStart = CaretImpl.this.getSelectionStart();
                    oldSelectionEnd = CaretImpl.this.getSelectionEnd();
                    if (oldSelectionStart == startOffset && oldSelectionEnd == endOffset && !visualPositionAware) {
                        return;
                    }
                } else {
                    oldSelectionStart = oldSelectionEnd = CaretImpl.this.getOffset();
                }
                if ((marker = CaretImpl.this.mySelectionMarker) != null) {
                    marker.dispose();
                }
                marker = doc.createRangeMarker(startOffset, endOffset);
                CaretImpl.this.myStartVirtualOffset = 0;
                CaretImpl.this.myEndVirtualOffset = 0;
                if (visualPositionAware) {
                    if (endPosition.after(startPosition)) {
                        CaretImpl.this.setRangeMarkerStartPosition(startPosition);
                        CaretImpl.this.setRangeMarkerEndPosition(endPosition);
                        CaretImpl.this.setRangeMarkerEndPositionIsLead(false);
                    } else {
                        CaretImpl.this.setRangeMarkerStartPosition(endPosition);
                        CaretImpl.this.setRangeMarkerEndPosition(startPosition);
                        CaretImpl.this.setRangeMarkerEndPositionIsLead(true);
                    }
                    if (CaretImpl.this.isVirtualSelectionEnabled() && CaretImpl.this.myEditor.getDocument().getLineNumber(startOffset) == CaretImpl.this.myEditor.getDocument().getLineNumber(endOffset)) {
                        int endLineColumn = ((CaretImpl)CaretImpl.this).myEditor.offsetToVisualPosition((int)endOffset).column;
                        int startDiff = EditorUtil.isAtLineEnd(CaretImpl.this.myEditor, switchedOffsets ? endOffset : startOffset) ? startPosition.column - endLineColumn : 0;
                        int endDiff = EditorUtil.isAtLineEnd(CaretImpl.this.myEditor, switchedOffsets ? startOffset : endOffset) ? endPosition.column - endLineColumn : 0;
                        CaretImpl.this.myStartVirtualOffset = Math.max(0, Math.min(startDiff, endDiff));
                        CaretImpl.this.myEndVirtualOffset = Math.max(0, Math.max(startDiff, endDiff));
                    }
                }
                CaretImpl.this.mySelectionMarker = marker;
                CaretImpl.this.myEditor.getSelectionModel().fireSelectionChanged(oldSelectionStart, oldSelectionEnd, startOffset, endOffset);
                if (updateSystemSelection) {
                    CaretImpl.this.updateSystemSelection();
                }
            }
        });
    }

    private void updateSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Clipboard clip = this.myEditor.getComponent().getToolkit().getSystemSelection();
        if (clip != null) {
            clip.setContents(new StringSelection(this.myEditor.getSelectionModel().getSelectedText(true)), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
    }

    public void removeSelection() {
        if (this.myEditor.isStickySelection()) {
            return;
        }
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                CaretImpl.this.validateContext(true);
                int caretOffset = CaretImpl.this.getOffset();
                RangeMarker marker = CaretImpl.this.mySelectionMarker;
                if (marker != null) {
                    int startOffset = marker.getStartOffset();
                    int endOffset = marker.getEndOffset();
                    marker.dispose();
                    CaretImpl.this.mySelectionMarker = null;
                    CaretImpl.this.myStartVirtualOffset = 0;
                    CaretImpl.this.myEndVirtualOffset = 0;
                    CaretImpl.this.myEditor.getSelectionModel().fireSelectionChanged(startOffset, endOffset, caretOffset, caretOffset);
                }
            }
        });
    }

    public int getLeadSelectionOffset() {
        RangeMarker marker;
        this.validateContext(false);
        int caretOffset = this.getOffset();
        if (this.hasSelection() && (marker = this.mySelectionMarker) != null) {
            FoldingModelImpl foldingModel;
            FoldRegion foldRegion;
            int startOffset = marker.getStartOffset();
            int endOffset = marker.getEndOffset();
            if (caretOffset != startOffset && caretOffset != endOffset && (foldRegion = (foldingModel = this.myEditor.getFoldingModel()).getCollapsedRegionAtOffset(caretOffset)) != null) {
                if (foldRegion.getStartOffset() == startOffset) {
                    return endOffset;
                }
                if (foldRegion.getEndOffset() == endOffset) {
                    return startOffset;
                }
            }
            if (caretOffset == endOffset) {
                return startOffset;
            }
            return endOffset;
        }
        return caretOffset;
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        RangeMarker marker = this.mySelectionMarker;
        VisualPosition caretPosition = this.getVisualPosition();
        if (this.isVirtualSelectionEnabled() && !this.hasSelection()) {
            VisualPosition visualPosition = caretPosition;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        if (marker == null) {
            VisualPosition visualPosition = caretPosition;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        if (this.isRangeMarkerEndPositionIsLead()) {
            VisualPosition result = this.getRangeMarkerEndPosition();
            if (result == null) {
                VisualPosition visualPosition = this.getSelectionEndPosition();
                if (visualPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
                }
                return visualPosition;
            }
            if (this.hasVirtualSelection()) {
                result = new VisualPosition(result.line, result.column + this.myEndVirtualOffset);
            }
            VisualPosition visualPosition = result;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        VisualPosition result = this.getRangeMarkerStartPosition();
        if (result == null) {
            VisualPosition visualPosition = this.getSelectionStartPosition();
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        if (this.hasVirtualSelection()) {
            result = new VisualPosition(result.line, result.column + this.myStartVirtualOffset);
        }
        VisualPosition visualPosition = result;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
        }
        return visualPosition;
    }

    public void selectLineAtCaret() {
        this.validateContext(true);
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                SelectionModelImpl.doSelectLineAtCaret(CaretImpl.this.myEditor);
            }
        });
    }

    public void selectWordAtCaret(final boolean honorCamelWordsSettings) {
        this.validateContext(true);
        this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean needOverrideSetting;
                CaretImpl.this.removeSelection();
                EditorSettings settings = CaretImpl.this.myEditor.getSettings();
                boolean camelTemp = settings.isCamelWords();
                boolean bl = needOverrideSetting = camelTemp && !honorCamelWordsSettings;
                if (needOverrideSetting) {
                    settings.setCamelWords(false);
                }
                try {
                    EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
                    handler.execute((Editor)CaretImpl.this.myEditor, (Caret)CaretImpl.this, CaretImpl.this.myEditor.getDataContext());
                }
                finally {
                    if (needOverrideSetting) {
                        settings.resetCamelWords();
                    }
                }
            }
        });
    }

    @Nullable
    public String getSelectedText() {
        if (!this.hasSelection()) {
            return null;
        }
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        String selectedText = text.subSequence(selectionStart, selectionEnd).toString();
        if (this.isVirtualSelectionEnabled() && this.myEndVirtualOffset > this.myStartVirtualOffset) {
            int padding = this.myEndVirtualOffset - this.myStartVirtualOffset;
            StringBuilder builder = new StringBuilder(selectedText.length() + padding);
            builder.append(selectedText);
            for (int i = 0; i < padding; ++i) {
                builder.append(' ');
            }
            return builder.toString();
        }
        return selectedText;
    }

    private void validateContext(boolean isWrite) {
        if (!this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (isWrite) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        } else {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
    }

    private boolean isVirtualSelectionEnabled() {
        return this.myEditor.isColumnMode();
    }

    boolean hasVirtualSelection() {
        this.validateContext(false);
        RangeMarker marker = this.mySelectionMarker;
        return marker != null && marker.isValid() && this.isVirtualSelectionEnabled() && this.myEndVirtualOffset > this.myStartVirtualOffset;
    }

    private int getCurrentX() {
        return this.myEditor.visualPositionToXY((VisualPosition)this.myVisibleCaret).x;
    }

    @NotNull
    public EditorImpl getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getEditor"));
        }
        return editorImpl;
    }

    public String toString() {
        return "Caret at " + this.myVisibleCaret + (this.mySelectionMarker == null ? "" : ", selection marker: " + this.mySelectionMarker.toString());
    }

    public boolean isAtRtlLocation() {
        return this.myEditor.myUseNewRendering && this.myEditor.myView.isRtlLocation(this.myVisibleCaret);
    }

    public boolean isAtBidiRunBoundary() {
        return this.myEditor.myUseNewRendering && this.myEditor.myView.isAtBidiRunBoundary(this.myVisibleCaret);
    }

    @Nullable
    private VisualPosition getRangeMarkerStartPosition() {
        this.invalidateRangeMarkerVisualPositions(this.mySelectionMarker);
        return this.myRangeMarkerStartPosition;
    }

    private void setRangeMarkerStartPosition(@NotNull VisualPosition startPosition) {
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/CaretImpl", "setRangeMarkerStartPosition"));
        }
        this.myRangeMarkerStartPosition = startPosition;
    }

    @Nullable
    private VisualPosition getRangeMarkerEndPosition() {
        this.invalidateRangeMarkerVisualPositions(this.mySelectionMarker);
        return this.myRangeMarkerEndPosition;
    }

    void setRangeMarkerEndPosition(@NotNull VisualPosition endPosition) {
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/CaretImpl", "setRangeMarkerEndPosition"));
        }
        this.myRangeMarkerEndPosition = endPosition;
    }

    private boolean isRangeMarkerEndPositionIsLead() {
        return this.myRangeMarkerEndPositionIsLead;
    }

    void setRangeMarkerEndPositionIsLead(boolean endPositionIsLead) {
        this.myRangeMarkerEndPositionIsLead = endPositionIsLead;
    }

    private void invalidateRangeMarkerVisualPositions(RangeMarker marker) {
        SoftWrapModelImpl model = this.myEditor.getSoftWrapModel();
        if (!this.myEditor.offsetToVisualPosition(marker.getStartOffset(), true, false).equals((Object)this.myRangeMarkerStartPosition) && model.getSoftWrap(marker.getStartOffset()) == null || !this.myEditor.offsetToVisualPosition(marker.getEndOffset(), false, true).equals((Object)this.myRangeMarkerEndPosition) && model.getSoftWrap(marker.getEndOffset()) == null) {
            this.myRangeMarkerStartPosition = null;
            this.myRangeMarkerEndPosition = null;
        }
    }

    private static class VerticalInfo {
        public final int y;
        public final int height;

        private VerticalInfo(int y, int height) {
            this.y = y;
            this.height = height;
        }
    }
}

