/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class FontInfo {
    private static final boolean USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE = SystemInfo.isAppleJvm && Registry.is((String)"ide.mac.fix.font.fallback");
    private static final FontRenderContext DUMMY_CONTEXT = new FontRenderContext(null, false, false);
    private static final boolean ENABLE_OPTIONAL_LIGATURES = Registry.is((String)"editor.enable.optional.ligatures");
    private final TIntHashSet mySymbolsToBreakDrawingIteration = new TIntHashSet();
    private final Font myFont;
    private final int mySize;
    @JdkConstants.FontStyle
    private final int myStyle;
    private final TIntHashSet mySafeCharacters = new TIntHashSet();
    private FontMetrics myFontMetrics = null;
    private final int[] charWidth = new int[128];
    private boolean myHasGlyphsToBreakDrawingIteration;
    private boolean myCheckedForProblemGlyphs;

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style) {
        this.mySize = size;
        this.myStyle = style;
        Font font = new Font(familyName, style, size);
        this.myFont = ENABLE_OPTIONAL_LIGATURES ? FontInfo.getFontWithLigaturesEnabled(font) : font;
    }

    @NotNull
    private static Font getFontWithLigaturesEnabled(Font font) {
        if (SystemInfo.isMac) {
            File fontFile = FontInfo.findFileForFont(font, true);
            if (fontFile == null && font.getStyle() != 0) {
                fontFile = FontInfo.findFileForFont(font.deriveFont(0), true);
            }
            if (fontFile == null) {
                fontFile = FontInfo.findFileForFont(font, false);
            }
            if (fontFile == null) {
                Font font2 = font;
                if (font2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getFontWithLigaturesEnabled"));
                }
                return font2;
            }
            try {
                font = Font.createFont(0, fontFile).deriveFont(font.getStyle(), font.getSize());
            }
            catch (Exception e) {
                Font font3 = font;
                if (font3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getFontWithLigaturesEnabled"));
                }
                return font3;
            }
        }
        Font font4 = font.deriveFont(Collections.singletonMap(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON));
        if (font4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getFontWithLigaturesEnabled"));
        }
        return font4;
    }

    private static File findFileForFont(Font font, final boolean matchStyle) {
        final String normalizedFamilyName = font.getFamily().toLowerCase(Locale.getDefault()).replace(" ", "");
        final int fontStyle = font.getStyle();
        File[] files = new File(System.getProperty("user.home"), "Library/Fonts").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                String normalizedName = name.toLowerCase(Locale.getDefault());
                return !(!normalizedName.startsWith(normalizedFamilyName) || !normalizedName.endsWith(".otf") && !normalizedName.endsWith(".ttf") || matchStyle && fontStyle != ComplementaryFontsRegistry.getFontStyle(name));
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        return Collections.min(Arrays.asList(files), new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.getName().compareTo(file2.getName());
            }
        });
    }

    private void parseProblemGlyphs() {
        this.myCheckedForProblemGlyphs = true;
        BufferedImage buffer = UIUtil.createImage((int)20, (int)20, (int)1);
        Graphics graphics = buffer.getGraphics();
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        FontRenderContext context = ((Graphics2D)graphics).getFontRenderContext();
        char[] charBuffer = new char[1];
        for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            if (!this.myFont.canDisplay(c)) continue;
            charBuffer[0] = c;
            GlyphVector vector = this.myFont.createGlyphVector(context, charBuffer);
            float y = vector.getGlyphMetrics(0).getAdvanceY();
            if (Math.round(y) == 0) continue;
            this.mySymbolsToBreakDrawingIteration.add((int)c);
        }
        this.myHasGlyphsToBreakDrawingIteration = !this.mySymbolsToBreakDrawingIteration.isEmpty();
    }

    public boolean hasGlyphsToBreakDrawingIteration() {
        if (!this.myCheckedForProblemGlyphs) {
            this.parseProblemGlyphs();
        }
        return this.myHasGlyphsToBreakDrawingIteration;
    }

    @NotNull
    public TIntHashSet getSymbolsToBreakDrawingIteration() {
        if (!this.myCheckedForProblemGlyphs) {
            this.parseProblemGlyphs();
        }
        TIntHashSet tIntHashSet = this.mySymbolsToBreakDrawingIteration;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getSymbolsToBreakDrawingIteration"));
        }
        return tIntHashSet;
    }

    public boolean canDisplay(char c) {
        try {
            if (c < '\u0080') {
                return true;
            }
            if (this.mySafeCharacters.contains((int)c)) {
                return true;
            }
            if (this.canDisplayImpl(c)) {
                this.mySafeCharacters.add((int)c);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canDisplayImpl(char c) {
        if (USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE) {
            return this.myFont.createGlyphVector(DUMMY_CONTEXT, new char[]{c}).getGlyphCode(0) > 0;
        }
        return this.myFont.canDisplay(c);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(char c) {
        FontMetrics metrics = this.fontMetrics();
        if (c < '\u0080') {
            return this.charWidth[c];
        }
        return metrics.charWidth(c);
    }

    private FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            Graphics graphics = UIUtil.createImage((int)1, (int)1, (int)1).getGraphics();
            EditorUIUtil.setupAntialiasing(graphics);
            graphics.setFont(this.myFont);
            this.myFontMetrics = graphics.getFontMetrics();
            for (int i = 0; i < 128; ++i) {
                this.charWidth[i] = this.myFontMetrics.charWidth(i);
            }
        }
        return this.myFontMetrics;
    }

    void reset() {
        this.myFontMetrics = null;
    }

    public int getSize() {
        return this.mySize;
    }

    @JdkConstants.FontStyle
    public int getStyle() {
        return this.myStyle;
    }
}

