/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483647)
public class ModuleDataService
extends AbstractProjectDataService<ModuleData, Module> {
    public static final com.intellij.openapi.util.Key<ModuleData> MODULE_DATA_KEY = com.intellij.openapi.util.Key.create((String)"MODULE_DATA_KEY");
    private static final Logger LOG = Logger.getInstance((String)("#" + ModuleDataService.class.getName()));

    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(final @NotNull Collection<DataNode<ModuleData>> toImport, @Nullable ProjectData projectData, final @NotNull Project project, final @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                Collection toCreate = ModuleDataService.filterExistingModules(toImport, project, platformFacade);
                if (!toCreate.isEmpty()) {
                    ModuleDataService.createModules(toCreate, project, platformFacade);
                }
                for (DataNode node : toImport) {
                    Module module = platformFacade.findIdeModule((ModuleData)node.getData(), project);
                    if (module == null) continue;
                    ModuleDataService.syncPaths(module, platformFacade, (ModuleData)node.getData());
                }
            }
        });
    }

    private static void createModules(final @NotNull Collection<DataNode<ModuleData>> toCreate, final @NotNull Project project, final @NotNull PlatformFacade platformFacade) {
        if (toCreate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCreate", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        Application application = ApplicationManager.getApplication();
        final HashMap moduleMappings = ContainerUtilRt.newHashMap();
        application.runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (DataNode module : toCreate) {
                    this.importModule((DataNode<ModuleData>)module);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void importModule(@NotNull DataNode<ModuleData> module) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$2", "importModule"));
                }
                ModuleData data2 = (ModuleData)module.getData();
                Module created = platformFacade.newModule(project, data2.getModuleFilePath(), data2.getModuleTypeId());
                final ModifiableRootModel moduleRootModel = platformFacade.getModuleModifiableModel(created);
                moduleRootModel.inheritSdk();
                ModuleDataService.setModuleOptions(created, (DataNode<ModuleData>)module);
                RootPolicy<Object> visitor = new RootPolicy<Object>(){

                    public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
                        moduleRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                        return value;
                    }

                    public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
                        moduleRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                        return value;
                    }
                };
                try {
                    for (OrderEntry orderEntry : moduleRootModel.getOrderEntries()) {
                        orderEntry.accept((RootPolicy)visitor, null);
                    }
                }
                finally {
                    moduleRootModel.commit();
                }
                moduleMappings.put(module, created);
            }
        });
    }

    @NotNull
    private static Collection<DataNode<ModuleData>> filterExistingModules(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull Project project, @NotNull PlatformFacade platformFacade) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        for (DataNode<ModuleData> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module = platformFacade.findIdeModule(moduleData, project);
            if (module == null) {
                result.add(node);
                continue;
            }
            ModuleDataService.setModuleOptions(module, node);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncPaths(@NotNull Module module, @NotNull PlatformFacade platformFacade, @NotNull ModuleData data2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        ModifiableRootModel modifiableModel = platformFacade.getModuleModifiableModel(module);
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            modifiableModel.dispose();
            LOG.warn(String.format("Can't sync paths for module '%s'. Reason: no compiler extension is found for it", module.getName()));
            return;
        }
        try {
            String testCompileOutputPath;
            String compileOutputPath = data2.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
            if (compileOutputPath != null) {
                extension.setCompilerOutputPath(VfsUtilCore.pathToUrl((String)compileOutputPath));
            }
            if ((testCompileOutputPath = data2.getCompileOutputPath(ExternalSystemSourceType.TEST)) != null) {
                extension.setCompilerOutputPathForTests(VfsUtilCore.pathToUrl((String)testCompileOutputPath));
            }
            extension.inheritCompilerOutputPath(data2.isInheritProjectCompileOutputPath());
        }
        finally {
            modifiableModel.commit();
        }
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(final @NotNull Collection<DataNode<ModuleData>> toImport, final @NotNull ProjectData projectData, final @NotNull Project project, final @NotNull PlatformFacade platformFacade) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        Computable<Collection<Module>> computable = new Computable<Collection<Module>>(){

            public Collection<Module> compute() {
                List orphanIdeModules = ContainerUtil.newSmartList();
                for (Module module : platformFacade.getModules(project)) {
                    if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module)) continue;
                    String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                    if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath)) continue;
                    final String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
                    final String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
                    DataNode found = (DataNode)ContainerUtil.find((Iterable)toImport, (Condition)new Condition<DataNode<ModuleData>>(){

                        public boolean value(DataNode<ModuleData> node) {
                            ModuleData moduleData = (ModuleData)node.getData();
                            return moduleData.getId().equals(projectId) && moduleData.getLinkedExternalProjectPath().equals(projectPath);
                        }
                    });
                    if (found != null) continue;
                    orphanIdeModules.add(module);
                }
                return orphanIdeModules;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        return computable;
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<ModuleData>> toIgnore, @NotNull ProjectData projectData, final @NotNull Project project, @NotNull PlatformFacade platformFacade, final boolean synchronous) {
        if (toRemoveComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveComputable", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<ModuleData> moduleDataNode : toIgnore) {
            Module module = platformFacade.findIdeModule((ModuleData)moduleDataNode.getData(), project);
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project, (List)modules){
            final /* synthetic */ List val$modules;
            {
                this.val$modules = list;
                super(arg0);
            }

            public void execute() {
                for (Module module : this.val$modules) {
                    if (module.isDisposed()) continue;
                    ModuleDataService.unlinkModuleFromExternalSystem(module);
                }
            }
        });
        ModuleDataService.ruleOrphanModules((List<Module>)modules, project, projectData.getOwner(), new Consumer<List<Module>>(){

            public void consume(final List<Module> modules) {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                    public void execute() {
                        for (Module module : modules) {
                            boolean success;
                            if (module.isDisposed()) continue;
                            ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
                            String path = module.getModuleFilePath();
                            moduleManager.disposeModule(module);
                            File file = new File(path);
                            if (!file.isFile() || (success = file.delete())) continue;
                            LOG.warn("Can't remove module file at '" + path + "'");
                        }
                    }
                });
            }
        });
    }

    private static void ruleOrphanModules(final @NotNull List<Module> orphanModules, final @NotNull Project project, final @NotNull ProjectSystemId externalSystemId, final @NotNull Consumer<List<Module>> result) {
        if (orphanModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphanModules", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                List toRemove = ContainerUtil.newSmartList();
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    toRemove.addAll(orphanModules);
                } else {
                    final JPanel content = new JPanel(new GridBagLayout());
                    content.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{externalSystemId.getReadableName()})), ExternalSystemUiUtil.getFillLineConstraints(0));
                    CheckBoxList orphanModulesList = new CheckBoxList();
                    orphanModulesList.setSelectionMode(2);
                    orphanModulesList.setItems(orphanModules, (Function)new Function<Module, String>(){

                        public String fun(Module module) {
                            return module.getName();
                        }
                    });
                    for (Module module : orphanModules) {
                        orphanModulesList.setItemSelected((Object)module, true);
                    }
                    orphanModulesList.setBorder(IdeBorderFactory.createEmptyBorder((int)8));
                    content.add((Component)orphanModulesList, ExternalSystemUiUtil.getFillLineConstraints(0));
                    content.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)8, (int)0));
                    DialogWrapper dialog = new DialogWrapper(project){
                        {
                            super(arg0);
                            this.setTitle(ExternalSystemBundle.message((String)"import.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
                            this.init();
                        }

                        @Nullable
                        protected JComponent createCenterPanel() {
                            return new JBScrollPane((Component)content);
                        }

                        @NotNull
                        protected Action[] createActions() {
                            Action[] actionArray = new Action[]{this.getOKAction()};
                            if (actionArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$6$2", "createActions"));
                            }
                            return actionArray;
                        }
                    };
                    dialog.showAndGet();
                    for (int i = 0; i < orphanModules.size(); ++i) {
                        Module module = (Module)orphanModules.get(i);
                        if (!orphanModulesList.isItemSelected(i)) continue;
                        toRemove.add(module);
                    }
                }
                result.consume((Object)toRemove);
            }
        });
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "unlinkModuleFromExternalSystem"));
        }
        module.clearOption("external.system.id");
        module.clearOption("external.linked.project.id");
        module.clearOption("external.linked.project.path");
        module.clearOption("external.root.project.path");
        module.clearOption("external.system.module.group");
        module.clearOption("external.system.module.version");
    }

    private static void setModuleOptions(Module module, DataNode<ModuleData> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        module.setOption("external.system.id", moduleData.getOwner().toString());
        module.setOption("external.linked.project.id", moduleData.getId());
        module.setOption("external.linked.project.path", moduleData.getLinkedExternalProjectPath());
        ProjectData projectData = (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT);
        module.setOption("external.root.project.path", projectData != null ? projectData.getLinkedExternalProjectPath() : "");
        if (moduleData.getGroup() != null) {
            module.setOption("external.system.module.group", moduleData.getGroup());
        }
        if (moduleData.getVersion() != null) {
            module.setOption("external.system.module.version", moduleData.getVersion());
        }
        module.clearOption("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule");
    }
}

