/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.CommonBundle;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private ProjectImpl myDefaultProject;
    private Project[] myOpenProjects = new Project[0];
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS = true;
    private static final int MAX_LEAKY_PROJECTS = 42;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
        }
        List array = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            List<ProjectManagerListener> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
            }
            return list;
        }
        List list = array;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getListeners"));
        }
        return list;
    }

    public ProjectManagerImpl(ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        final ProjectManagerListener busPublisher = (ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(Project project) {
                busPublisher.projectOpened(project);
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    listener.projectOpened(project);
                }
            }

            public void projectClosed(Project project) {
                busPublisher.projectClosed(project);
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    listener.projectClosed(project);
                }
            }

            public boolean canCloseProject(Project project) {
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    if (listener.canCloseProject(project)) continue;
                    return false;
                }
                return true;
            }

            public void projectClosing(Project project) {
                busPublisher.projectClosing(project);
                for (ProjectManagerListener listener : ProjectManagerImpl.getListeners(project)) {
                    listener.projectClosing(project);
                }
            }
        });
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "newProject"));
        }
        return this.newProject(projectName, filePath, useDefaultProjectSettings, isDummy, ApplicationManager.getApplication().isUnitTestMode());
    }

    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy, boolean optimiseTestLoadSpeed) {
        File projectFile;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "newProject"));
        }
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
            for (int i = 0; i < 42 && this.myProjects.size() >= 42; ++i) {
                System.gc();
                TimeoutUtil.sleep((long)100L);
                System.gc();
            }
            if (this.myProjects.size() >= 42) {
                ArrayList<Project> copy = new ArrayList<Project>(this.myProjects.keySet());
                this.myProjects.clear();
                throw new TooManyProjectLeakedException(copy);
            }
        }
        if ((projectFile = new File(filePath)).isFile()) {
            FileUtil.delete((File)projectFile);
        } else {
            File[] files = new File(projectFile, ".idea").listFiles();
            if (files != null) {
                for (File file : files) {
                    FileUtil.delete((File)file);
                }
            }
        }
        ProjectImpl project = this.createProject(projectName, filePath, false, optimiseTestLoadSpeed);
        try {
            this.initProject(project, useDefaultProjectSettings ? this.getDefaultProject() : null);
            this.myProjects.put(project, null);
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
        }
        String message = e.getMessage();
        if (message != null) {
            String string = message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
            }
            return string;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            String string = message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
            }
            return string;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            String string = message + " (cause: " + causeMessage + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
            }
            return string;
        }
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "message"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectImpl project, @Nullable Project template) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "initProject"));
        }
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null && !project.isDefault()) {
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project.getName()}));
            indicator.setIndeterminate(true);
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project);
        boolean succeed = false;
        try {
            if (template != null) {
                project.getStateStore().loadProjectFromTemplate(template);
            }
            project.init();
            succeed = true;
        }
        finally {
            if (!succeed) {
                ProjectManagerImpl.scheduleDispose(project);
            }
        }
    }

    private ProjectImpl createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault, boolean isOptimiseTestLoadSpeed) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "createProject"));
        }
        return isDefault ? new DefaultProject(this, "", isOptimiseTestLoadSpeed) : new ProjectImpl(this, new File(filePath).getAbsolutePath(), isOptimiseTestLoadSpeed, projectName);
    }

    private static void scheduleDispose(final @NotNull ProjectImpl project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "scheduleDispose"));
        }
        if (project.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            Disposer.dispose((Disposable)project);
                        }
                    }
                });
            }
        });
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadProject"));
        }
        try {
            ProjectImpl project = this.createProject(null, filePath, false, false);
            this.initProject(project, null);
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
        }
        try {
            string = FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            String string2 = filePath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "toCanonicalName"));
        }
        return string;
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectManagerImpl.this.myDefaultProject = ProjectManagerImpl.this.createProject(null, "", true, ApplicationManager.getApplication().isUnitTestMode());
                        ProjectManagerImpl.this.initProject(ProjectManagerImpl.this.myDefaultProject, null);
                    }
                    catch (Throwable t) {
                        PluginManager.processException(t);
                    }
                }
            });
        }
        ProjectImpl projectImpl = this.myDefaultProject;
        if (projectImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getDefaultProject"));
        }
        return projectImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object object = this.lock;
        // MONITORENTER : object
        // MONITOREXIT : object
        if (this.myOpenProjects != null) return this.myOpenProjects;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "getOpenProjects"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "openProject"));
        }
        if (ProjectManagerImpl.isLight(project)) {
            ((ProjectImpl)project).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project);
                return true;
            }
        }
        if (!this.addToOpened(project)) {
            return false;
        }
        this.fireProjectOpened(project);
        DumbService.getInstance((Project)project).queueTask(new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/impl/ProjectManagerImpl$4", "performInDumbMode"));
                }
                ProjectManagerImpl.waitForFileWatcher(indicator);
            }

            public String toString() {
                return "wait for file watcher";
            }
        });
        final StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project);
        boolean ok = this.myProgressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                startupManager.runStartupActivities();
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        startupManager.startCacheUpdate();
                    }
                });
                startupManager.runPostStartupActivitiesFromExtensions();
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            startupManager.runPostStartupActivities();
                        }
                    }
                });
            }
        }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), project);
        if (!ok) {
            this.closeProject(project, false, false, true);
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        StorageUtil.checkUnknownMacros((ComponentManager)project, project);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addToOpened"));
        }
        assert (!project.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? project : null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Collection<Project> removeFromOpened(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeFromOpened"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project);
        ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? this.myOpenProjects[0] : null;
        List<Project> list = Arrays.asList(this.myOpenProjects);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeFromOpened"));
    }

    private static boolean canCancelProjectLoading() {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        return !(indicator instanceof NonCancelableSection);
    }

    private static void waitForFileWatcher(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/impl/ProjectManagerImpl", "waitForFileWatcher"));
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational() || !watcher.isSettingRoots()) {
            return;
        }
        LOG.info("FW/roots waiting started");
        indicator.setIndeterminate(true);
        indicator.setText(ProjectBundle.message((String)"project.load.waiting.watcher", (Object[])new Object[0]));
        if (indicator instanceof ProgressWindow) {
            ((ProgressWindow)indicator).setCancelButtonText(CommonBundle.message((String)"button.skip", (Object[])new Object[0]));
        }
        while (watcher.isSettingRoots() && !indicator.isCanceled()) {
            TimeoutUtil.sleep((long)10L);
        }
        LOG.info("FW/roots waiting finished");
    }

    public Project loadAndOpenProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadAndOpenProject"));
        }
        final Project project = this.convertAndLoadProject(filePath);
        if (project == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!this.openProject(project)) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        return project;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(@NotNull String filePath) throws IOException {
        Project project;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "convertAndLoadProject"));
        }
        String fp = ProjectManagerImpl.toCanonicalName(filePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(fp);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        try {
            project = this.loadProjectWithProgress(filePath);
            if (project == null) {
                return null;
            }
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
        if (!conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    conversionResult.postStartupActivity(project);
                }
            });
        }
        return project;
    }

    @Nullable
    private Project loadProjectWithProgress(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectManagerImpl", "loadProjectWithProgress"));
        }
        final ProjectImpl project = this.createProject(null, ProjectManagerImpl.toCanonicalName(filePath), false, false);
        try {
            this.myProgressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Object, RuntimeException>(){

                @Nullable
                public Project compute() {
                    ProjectManagerImpl.this.initProject(project, null);
                    return project;
                }
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), (Project)project);
        }
        catch (ProcessCanceledException ignore) {
            return null;
        }
        return project;
    }

    private static void notifyProjectOpenFailed() {
        ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        WelcomeFrame.showIfNoProjectOpened();
    }

    @Override
    public void openTestProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "openTestProject"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    @NotNull
    public Collection<Project> closeTestProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeTestProject"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.closeProject(project);
        List<Project> list = Arrays.asList(this.getOpenProjects());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeTestProject"));
        }
        return list;
    }

    public void reloadProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "reloadProject"));
        }
        ProjectManagerImpl.doReloadProject(project);
    }

    public static void doReloadProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "doReloadProject"));
        }
        final Ref projectRef = Ref.create((Object)project);
        ProjectReloadState.getInstance((Project)project).onBeforeAutomaticProjectReload();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Reloading project.");
                Project project = (Project)projectRef.get();
                projectRef.set(null);
                if (project.isDisposed()) {
                    return;
                }
                String presentableUrl = project.getPresentableUrl();
                if (!ProjectUtil.closeAndDispose(project)) {
                    return;
                }
                ProjectUtil.openProject(presentableUrl, null, true);
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeProject"));
        }
        return this.closeProject(project, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeProject(final @NotNull Project project, boolean save, final boolean dispose, boolean checkCanClose) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeProject"));
        }
        if (ProjectManagerImpl.isLight(project)) {
            if (!((ProjectImpl)project).isTemporarilyDisposed()) {
                ((ProjectImpl)project).setTemporarilyDisposed(true);
                this.removeFromOpened(project);
                return true;
            }
            ((ProjectImpl)project).setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (save) {
                FileDocumentManager.getInstance().saveAllDocuments();
                project.save();
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ProjectManagerImpl.this.removeFromOpened(project);
                    ProjectManagerImpl.this.fireProjectClosed(project);
                    if (dispose) {
                        Disposer.dispose((Disposable)project);
                    }
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "isLight"));
        }
        return project instanceof ProjectImpl && ((ProjectImpl)project).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "closeAndDispose"));
        }
        return this.closeProject(project, true, true, true);
    }

    private void fireProjectClosing(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "fireProjectClosing"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectClosing(project);
            }
            catch (Exception e) {
                LOG.error("From listener " + listener + " (" + listener.getClass() + ")", (Throwable)e);
            }
        }
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        this.myListeners.add(listener);
    }

    public void addProjectManagerListener(final @NotNull ProjectManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        this.addProjectManagerListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectManagerImpl.this.removeProjectManagerListener(listener);
            }
        });
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        boolean removed = this.myListeners.remove(listener);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "addProjectManagerListener"));
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener);
    }

    public void removeProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/project/impl/ProjectManagerImpl", "removeProjectManagerListener"));
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "fireProjectOpened"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectOpened(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void fireProjectClosed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "fireProjectClosed"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectClosed(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "canClose"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                if (listener.canCloseProject(project)) continue;
                return false;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return true;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project) {
        VirtualFile[] files;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "ensureCouldCloseIfUnableToSave"));
        }
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        for (VirtualFile file : files = notifications[0].myFiles) {
            if (count == 10) {
                message.append('\n').append("and ").append(files.length - count).append(" more").append('\n');
                continue;
            }
            message.append(file.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project, (String)message.toString(), (String)"Unsaved Project", (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/impl/ProjectManagerImpl", "saveChangedProjectFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl", "saveChangedProjectFile"));
        }
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        public VirtualFile[] myFiles;

        public UnableToSaveProjectNotification(@NotNull Project project, @NotNull VirtualFile[] readOnlyFiles) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification", "<init>"));
            }
            if (readOnlyFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnlyFiles", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification", "<init>"));
            }
            super("Project Settings", "Could not save project", "Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.", NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification$1", "hyperlinkUpdate"));
                    }
                    UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                    Project _project = unableToSaveProjectNotification.myProject;
                    notification.expire();
                    if (_project != null && !_project.isDisposed()) {
                        _project.save();
                    }
                }
            });
            this.myProject = project;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }
}

