/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectModelModificationService {
    public static ProjectModelModificationService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ProjectModelModificationService", "getInstance"));
        }
        return (ProjectModelModificationService)ServiceManager.getService((Project)project, ProjectModelModificationService.class);
    }

    public void addDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        this.addDependency(from, to, DependencyScope.COMPILE);
    }

    public abstract void addDependency(@NotNull Module var1, @NotNull Module var2, @NotNull DependencyScope var3);

    public void addDependency(@NotNull Module from, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        if (libraryDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescriptor", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        this.addDependency(from, libraryDescriptor, DependencyScope.COMPILE);
    }

    public void addDependency(Module from, ExternalLibraryDescriptor descriptor, DependencyScope scope) {
        this.addDependency(Collections.singletonList(from), descriptor, scope);
    }

    public abstract void addDependency(@NotNull Collection<Module> var1, @NotNull ExternalLibraryDescriptor var2, @NotNull DependencyScope var3);

    public abstract void addDependency(@NotNull Module var1, @NotNull Library var2, @NotNull DependencyScope var3);
}

