/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelModifier;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IdeaProjectModelModifier
extends ProjectModelModifier {
    private static final Logger LOG = Logger.getInstance(IdeaProjectModelModifier.class);
    private final Project myProject;

    public IdeaProjectModelModifier(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addModuleDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addModuleDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addModuleDependency"));
        }
        ModuleRootModificationUtil.addDependency((Module)from, (Module)to, (DependencyScope)scope, (boolean)false);
        return true;
    }

    @Override
    public boolean addExternalLibraryDependency(final @NotNull Collection<Module> modules, final @NotNull ExternalLibraryDescriptor descriptor, final @NotNull DependencyScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addExternalLibraryDependency"));
        }
        List<String> defaultRoots = descriptor.getLibraryClassesRoots();
        Module firstModule = (Module)ContainerUtil.getFirstItem(modules);
        LOG.assertTrue(firstModule != null);
        LocateLibraryDialog dialog = new LocateLibraryDialog(firstModule, defaultRoots, descriptor.getPresentableName());
        List<String> classesRoots = dialog.showAndGetResult();
        if (!classesRoots.isEmpty()) {
            String libraryName = classesRoots.size() > 1 ? descriptor.getPresentableName() : null;
            final List<String> urls = OrderEntryFix.refreshAndConvertToUrls(classesRoots);
            if (modules.size() == 1) {
                ModuleRootModificationUtil.addModuleLibrary((Module)firstModule, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
            } else {
                new WriteAction(){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier$1", "run"));
                        }
                        Library library = LibraryUtil.createLibrary((LibraryTable)LibraryTablesRegistrar.getInstance().getLibraryTable(IdeaProjectModelModifier.this.myProject), (String)descriptor.getPresentableName());
                        Library.ModifiableModel model = library.getModifiableModel();
                        for (String url : urls) {
                            model.addRoot(url, OrderRootType.CLASSES);
                        }
                        model.commit();
                        for (Module module : modules) {
                            ModuleRootModificationUtil.addDependency((Module)module, (Library)library, (DependencyScope)scope, (boolean)false);
                        }
                    }
                }.execute();
            }
        }
        return true;
    }

    @Override
    public boolean addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addLibraryDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/IdeaProjectModelModifier", "addLibraryDependency"));
        }
        OrderEntryUtil.addLibraryToRoots(from, library);
        return true;
    }
}

