/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactEditorContextImpl
implements ArtifactEditorContext {
    private final ArtifactsStructureConfigurableContext myParent;
    private final ArtifactEditorEx myEditor;

    public ArtifactEditorContextImpl(ArtifactsStructureConfigurableContext parent, ArtifactEditorEx editor) {
        this.myParent = parent;
        this.myEditor = editor;
    }

    @NotNull
    public ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        ModifiableArtifactModel modifiableArtifactModel = this.myParent.getOrCreateModifiableArtifactModel();
        if (modifiableArtifactModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getOrCreateModifiableArtifactModel"));
        }
        return modifiableArtifactModel;
    }

    public ModifiableModuleModel getModifiableModuleModel() {
        return this.myParent.getModifiableModuleModel();
    }

    @NotNull
    public ModifiableRootModel getOrCreateModifiableRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getOrCreateModifiableRootModel"));
        }
        ModifiableRootModel modifiableRootModel = this.myParent.getOrCreateModifiableRootModel(module);
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getOrCreateModifiableRootModel"));
        }
        return modifiableRootModel;
    }

    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType) {
        return this.myParent.getManifestFile(element, artifactType);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myParent.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getProject"));
        }
        return project;
    }

    public CompositePackagingElement<?> getRootElement(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getRootElement"));
        }
        return this.myParent.getRootElement(artifact);
    }

    public void editLayout(@NotNull Artifact artifact, Runnable runnable) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "editLayout"));
        }
        this.myParent.editLayout(artifact, runnable);
    }

    public ArtifactEditor getOrCreateEditor(Artifact artifact) {
        return this.myParent.getOrCreateEditor(artifact);
    }

    public ArtifactEditor getThisArtifactEditor() {
        return this.myEditor;
    }

    public void selectArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "selectArtifact"));
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(artifact, true);
    }

    public void selectFacet(@NotNull Facet<?> facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "selectFacet"));
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(facet, true);
    }

    public void selectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "selectModule"));
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(module.getName(), null, true);
    }

    public void selectLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "selectLibrary"));
        }
        LibraryTable table = library.getTable();
        if (table != null) {
            ProjectStructureConfigurable.getInstance(this.getProject()).selectProjectOrGlobalLibrary(library, true);
        } else {
            Module module = ((LibraryImpl)library).getModule();
            if (module != null) {
                ModuleRootModel rootModel = this.myParent.getModulesProvider().getRootModel(module);
                String libraryName = library.getName();
                for (OrderEntry entry : rootModel.getOrderEntries()) {
                    if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                    ModuleLibraryOrderEntryImpl libraryEntry = (ModuleLibraryOrderEntryImpl)entry;
                    if ((libraryName == null || !libraryName.equals(libraryEntry.getLibraryName())) && (libraryName != null || !library.equals(libraryEntry.getLibrary()))) continue;
                    ProjectStructureConfigurable.getInstance(this.getProject()).selectOrderEntry(module, libraryEntry);
                    return;
                }
            }
        }
    }

    public List<Artifact> chooseArtifacts(List<? extends Artifact> artifacts, String title) {
        ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(this.getProject(), artifacts, title, null);
        return dialog.showAndGet() ? dialog.getChosenElements() : Collections.emptyList();
    }

    @NotNull
    public ArtifactModel getArtifactModel() {
        ArtifactModel artifactModel = this.myParent.getArtifactModel();
        if (artifactModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getArtifactModel"));
        }
        return artifactModel;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        ModulesProvider modulesProvider = this.myParent.getModulesProvider();
        if (modulesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getModulesProvider"));
        }
        return modulesProvider;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        FacetsProvider facetsProvider = this.myParent.getFacetsProvider();
        if (facetsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getFacetsProvider"));
        }
        return facetsProvider;
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "findLibrary"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "findLibrary"));
        }
        return this.myParent.findLibrary(level, libraryName);
    }

    @NotNull
    public ManifestFileProvider getManifestFileProvider() {
        ManifestFileProvider manifestFileProvider = this.myParent.getManifestFileProvider();
        if (manifestFileProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getManifestFileProvider"));
        }
        return manifestFileProvider;
    }

    public void queueValidation() {
        this.myParent.queueValidation(this.getArtifact());
    }

    @NotNull
    public ArtifactType getArtifactType() {
        ArtifactType artifactType = this.myEditor.getArtifact().getArtifactType();
        if (artifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl", "getArtifactType"));
        }
        return artifactType;
    }

    public List<Module> chooseModules(List<Module> modules, String title) {
        return new ChooseModulesDialog(this.getProject(), (List<? extends Module>)modules, title, null).showAndGetResult();
    }

    public List<Library> chooseLibraries(String title) {
        ChooseLibrariesFromTablesDialog dialog = ChooseLibrariesFromTablesDialog.createDialog(title, this.getProject(), false);
        return dialog.showAndGet() ? dialog.getSelectedLibraries() : Collections.emptyList();
    }

    public Artifact getArtifact() {
        return this.myEditor.getArtifact();
    }

    public ArtifactsStructureConfigurableContext getParent() {
        return this.myParent;
    }
}

