/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware,
LineNumberListener {
    private final UpToDateLineNumberProvider myGetUpToDateLineNumber;
    @NotNull
    private final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;
    private int currentLine;

    public AnnotateRevisionAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, @NotNull UpToDateLineNumberProvider getUpToDateLineNumber, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        if (getUpToDateLineNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getUpToDateLineNumber", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        super(text, description, icon);
        this.myGetUpToDateLineNumber = getUpToDateLineNumber;
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "update"));
        }
        if (this.getRevisions() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        super.update(e);
    }

    @Nullable
    protected abstract List<VcsFileRevision> getRevisions();

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getVcs"));
        }
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getFile"));
        }
        VcsFileRevision revision = this.getFileRevision(e);
        if (revision == null) {
            return null;
        }
        final FileType currentFileType = this.myAnnotation.getFile().getFileType();
        FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((VirtualFile)this.myAnnotation.getFile());
        return new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance()){

            @NotNull
            public FileType getFileType() {
                FileType type = super.getFileType();
                FileType fileType = type.isBinary() ? currentFileType : type;
                if (fileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$1", "getFileType"));
                }
                return fileType;
            }
        };
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getFileRevision"));
        }
        List<VcsFileRevision> revisions = this.getRevisions();
        assert (this.getRevisions() != null);
        if (this.currentLine < 0) {
            return null;
        }
        int corrected = this.myGetUpToDateLineNumber.getLineNumber(this.currentLine);
        if (corrected < 0 || corrected >= revisions.size()) {
            return null;
        }
        return revisions.get(corrected);
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }
}

