/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeletedFilesHolder
implements FileHolder {
    private final Map<String, LocallyDeletedChange> myFiles = new HashMap<String, LocallyDeletedChange>();

    @Override
    public void cleanAll() {
        this.myFiles.clear();
    }

    public void takeFrom(DeletedFilesHolder holder) {
        this.myFiles.clear();
        this.myFiles.putAll(holder.myFiles);
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        if (scope == null) {
            this.myFiles.clear();
        }
        ArrayList<LocallyDeletedChange> currentFiles = new ArrayList<LocallyDeletedChange>(this.myFiles.values());
        for (LocallyDeletedChange change : currentFiles) {
            if (!scope.belongsTo(change.getPath())) continue;
            this.myFiles.remove(change.getPresentableUrl());
        }
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.DELETED;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs scope) {
    }

    public void addFile(LocallyDeletedChange change) {
        this.myFiles.put(change.getPresentableUrl(), change);
    }

    public List<LocallyDeletedChange> getFiles() {
        return new ArrayList<LocallyDeletedChange>(this.myFiles.values());
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        String url = filePath.getPresentableUrl();
        return this.myFiles.containsKey(url);
    }

    @Override
    public DeletedFilesHolder copy() {
        DeletedFilesHolder copyHolder = new DeletedFilesHolder();
        copyHolder.myFiles.putAll(this.myFiles);
        return copyHolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletedFilesHolder that = (DeletedFilesHolder)o;
        return this.myFiles.equals(that.myFiles);
    }

    public int hashCode() {
        return this.myFiles.hashCode();
    }
}

