/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.patch.PatchNameChecker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePatchConfigurationPanel {
    private static final String SYSTEM_DEFAULT = IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()});
    public static final String ALL = "(All)";
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myFileNameField;
    private JCheckBox myReversePatchCheckbox;
    private JComboBox myEncoding;
    private JLabel myErrorLabel;
    private JCheckBox myIncludeBaseRevisionTextCheckBox;
    private Consumer<Boolean> myOkEnabledListener;
    private final Project myProject;
    private List<Change> myChanges;
    private Collection<Change> myIncludedChanges;
    private SelectFilesToAddTextsToPatchPanel mySelectFilesToAddTextsToPatchPanel;
    private HideableTitledPanel myHideableTitledPanel;
    private JPanel myPanelWithSelectedFiles;
    private boolean myExecute;

    public CreatePatchConfigurationPanel(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel", "<init>"));
        }
        this.myProject = project;
        this.initMainPanel();
        this.myFileNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name;
                FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save patch to", "", new String[0]), (Component)CreatePatchConfigurationPanel.this.myMainPanel);
                String path = FileUtil.toSystemIndependentName((String)CreatePatchConfigurationPanel.this.getFileName());
                int idx = path.lastIndexOf("/");
                VirtualFile baseDir = idx == -1 ? project.getBaseDir() : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path.substring(0, idx)));
                VirtualFileWrapper fileWrapper = dialog.save(baseDir = baseDir == null ? project.getBaseDir() : baseDir, name = idx == -1 ? path : path.substring(idx + 1));
                if (fileWrapper != null) {
                    CreatePatchConfigurationPanel.this.myFileNameField.setText(fileWrapper.getFile().getPath());
                    CreatePatchConfigurationPanel.this.checkName();
                }
            }
        });
        this.myIncludeBaseRevisionTextCheckBox.setVisible(false);
        this.myFileNameField.getTextField().addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                CreatePatchConfigurationPanel.this.checkName();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        this.myFileNameField.setTextFieldPreferredWidth(70);
        this.myFileNameField.getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                CreatePatchConfigurationPanel.this.checkName();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                CreatePatchConfigurationPanel.this.checkName();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CreatePatchConfigurationPanel.this.checkName();
            }
        });
        this.myErrorLabel.setForeground(Color.RED);
        this.checkName();
        this.initEncodingCombo();
    }

    private void initEncodingCombo() {
        DefaultComboBoxModel<Charset> encodingsModel = new DefaultComboBoxModel<Charset>(CharsetToolkit.getAvailableCharsets());
        encodingsModel.insertElementAt((Charset)((Object)SYSTEM_DEFAULT), 0);
        this.myEncoding.setModel(encodingsModel);
        String name = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharsetName();
        if (StringUtil.isEmpty((String)name)) {
            this.myEncoding.setSelectedItem(SYSTEM_DEFAULT);
        } else {
            this.myEncoding.setSelectedItem(EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
        }
    }

    @Nullable
    public Charset getEncoding() {
        Object selectedItem = this.myEncoding.getSelectedItem();
        if (SYSTEM_DEFAULT.equals(selectedItem)) {
            return CharsetToolkit.getDefaultSystemCharset();
        }
        return (Charset)selectedItem;
    }

    private void initMainPanel() {
        this.myFileNameField = new TextFieldWithBrowseButton();
        this.myReversePatchCheckbox = new JCheckBox(VcsBundle.message((String)"create.patch.reverse.checkbox", (Object[])new Object[0]));
        this.myEncoding = new JComboBox();
        this.myIncludeBaseRevisionTextCheckBox = new JCheckBox(VcsBundle.message((String)"create.patch.base.revision", (Object[])new Object[]{0}));
        this.myErrorLabel = new JLabel();
        this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent(VcsBundle.message((String)"create.patch.file.path", (Object[])new Object[0]), (JComponent)this.myFileNameField).addComponent((JComponent)this.myReversePatchCheckbox).addComponent((JComponent)this.myIncludeBaseRevisionTextCheckBox).addLabeledComponent(VcsBundle.message((String)"create.patch.encoding", (Object[])new Object[0]), (JComponent)this.myEncoding).addComponent((JComponent)this.myErrorLabel).getPanel();
    }

    private void initPanelWithSelectedFiles(Runnable inclusionListener) {
        this.mySelectFilesToAddTextsToPatchPanel = new SelectFilesToAddTextsToPatchPanel(this.myProject, this.myChanges, this.myIncludedChanges, inclusionListener);
        this.myHideableTitledPanel = new HideableTitledPanel("", this.mySelectFilesToAddTextsToPatchPanel.getPanel(), false);
        this.myPanelWithSelectedFiles = new JPanel(new BorderLayout());
        this.myPanelWithSelectedFiles.add((Component)this.myMainPanel, "North");
        this.myPanelWithSelectedFiles.add((Component)this.myHideableTitledPanel, "Center");
    }

    public void showTextStoreOption() {
        if (this.myChanges.size() > 0) {
            this.myIncludeBaseRevisionTextCheckBox.setVisible(true);
            Runnable inclusionListener = new Runnable(){

                @Override
                public void run() {
                    if (CreatePatchConfigurationPanel.this.mySelectFilesToAddTextsToPatchPanel != null) {
                        CreatePatchConfigurationPanel.this.myIncludedChanges = CreatePatchConfigurationPanel.this.mySelectFilesToAddTextsToPatchPanel.getIncludedChanges();
                        CreatePatchConfigurationPanel.this.myHideableTitledPanel.setTitle("Included &Files: " + (CreatePatchConfigurationPanel.this.myIncludedChanges.size() == CreatePatchConfigurationPanel.this.myChanges.size() ? "All" : CreatePatchConfigurationPanel.this.myIncludedChanges.size() + " of " + CreatePatchConfigurationPanel.this.myChanges.size()));
                    }
                }
            };
            this.initPanelWithSelectedFiles(inclusionListener);
            inclusionListener.run();
            VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myIncludeBaseRevisionTextCheckBox.setSelected(configuration.INCLUDE_TEXT_INTO_PATCH);
            this.myIncludeBaseRevisionTextCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreatePatchConfigurationPanel.this.myHideableTitledPanel.setEnabled(CreatePatchConfigurationPanel.this.myIncludeBaseRevisionTextCheckBox.isSelected());
                    CreatePatchConfigurationPanel.this.mySelectFilesToAddTextsToPatchPanel.setEnabled(CreatePatchConfigurationPanel.this.myIncludeBaseRevisionTextCheckBox.isSelected());
                }
            });
            this.myHideableTitledPanel.setEnabled(this.myIncludeBaseRevisionTextCheckBox.isSelected());
            this.mySelectFilesToAddTextsToPatchPanel.setEnabled(this.myIncludeBaseRevisionTextCheckBox.isSelected());
        }
    }

    private void checkName() {
        PatchNameChecker patchNameChecker = new PatchNameChecker(this.getFileName());
        if (patchNameChecker.nameOk()) {
            this.myErrorLabel.setText("");
        } else {
            this.myErrorLabel.setText(patchNameChecker.getError());
        }
        boolean bl = this.myExecute = patchNameChecker.nameOk() || !patchNameChecker.isPreventsOk();
        if (this.myOkEnabledListener != null) {
            this.myOkEnabledListener.consume((Object)this.myExecute);
        }
    }

    public void onOk() {
        if (this.myIncludeBaseRevisionTextCheckBox.isVisible()) {
            VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            vcsConfiguration.INCLUDE_TEXT_INTO_PATCH = this.myIncludeBaseRevisionTextCheckBox.isSelected();
        }
    }

    public boolean isStoreTexts() {
        return this.myIncludeBaseRevisionTextCheckBox.isSelected();
    }

    public Collection<Change> getIncludedChanges() {
        return this.myIncludedChanges;
    }

    public JComponent getPanel() {
        return !this.myIncludeBaseRevisionTextCheckBox.isVisible() || this.myChanges.isEmpty() ? this.myMainPanel : this.myPanelWithSelectedFiles;
    }

    public void installOkEnabledListener(Consumer<Boolean> runnable) {
        this.myOkEnabledListener = runnable;
    }

    public String getFileName() {
        return FileUtil.expandUserHome((String)this.myFileNameField.getText().trim());
    }

    public void setFileName(File file) {
        this.myFileNameField.setText(file.getPath());
        this.checkName();
    }

    public boolean isReversePatch() {
        return this.myReversePatchCheckbox.isSelected();
    }

    public void setReversePatch(boolean reverse) {
        this.myReversePatchCheckbox.setSelected(reverse);
    }

    public boolean isOkToExecute() {
        return this.myExecute;
    }

    public String getError() {
        return this.myErrorLabel.getText() == null ? "" : this.myErrorLabel.getText();
    }

    public void setChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel", "setChanges"));
        }
        this.myChanges = new ArrayList<Change>(changes);
        this.myIncludedChanges = new ArrayList<Change>(this.myChanges);
        this.myIncludedChanges.removeAll(SelectFilesToAddTextsToPatchPanel.getBig(this.myChanges));
        this.updateIncludeBaseRevisionText();
    }

    private void updateIncludeBaseRevisionText() {
        this.myIncludeBaseRevisionTextCheckBox.setText(VcsBundle.message((String)"create.patch.base.revision", (Object[])new Object[]{this.myIncludedChanges != null ? this.myIncludedChanges.size() : 0}));
    }
}

