/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.BinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchPatchPaths {
    private static final int BIG_FILE_BOUND = 100000;
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public MatchPatchPaths(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir();
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "execute"));
        }
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        ArrayList<PatchAndVariants> candidates = new ArrayList<PatchAndVariants>(list.size());
        ArrayList<FilePatch> newOrWithoutMatches = new ArrayList<FilePatch>();
        this.findCandidates(list, directoryDetector, candidates, newOrWithoutMatches);
        MultiMap result = new MultiMap();
        MatchPatchPaths.filterExactMatches(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result);
        MatchPatchPaths.selectByContextOrByStrip(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result);
        this.workWithNotExisting(directoryDetector, newOrWithoutMatches, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result);
        return new ArrayList<AbstractFilePatchInProgress>(result.values());
    }

    private void workWithNotExisting(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<FilePatch> newOrWithoutMatches, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result) {
        if (directoryDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "workWithNotExisting"));
        }
        if (newOrWithoutMatches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOrWithoutMatches", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "workWithNotExisting"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "workWithNotExisting"));
        }
        for (FilePatch patch : newOrWithoutMatches) {
            AbstractFilePatchInProgress patchInProgress;
            String[] strings = patch.getAfterName().replace('\\', '/').split("/");
            Pair<VirtualFile, Integer> best = null;
            for (int i = strings.length - 2; i >= 0; --i) {
                String name = strings[i];
                Collection<VirtualFile> files = this.findFilesFromIndex(directoryDetector, name);
                if (files.isEmpty()) continue;
                for (VirtualFile file : files) {
                    Pair<VirtualFile, Integer> pair = MatchPatchPaths.compareNamesImpl(strings, file, i);
                    if (pair == null || (Integer)pair.getSecond() >= i || best != null && (Integer)pair.getSecond() >= (Integer)best.getSecond()) continue;
                    best = pair;
                }
            }
            if (best != null) {
                patchInProgress = MatchPatchPaths.createPatchInProgress(patch, (VirtualFile)best.getFirst());
                if (patchInProgress == null) break;
                AutoMatchStrategy.processStipUp(patchInProgress, (Integer)best.getSecond());
                result.putValue(best.getFirst(), (Object)patchInProgress);
                continue;
            }
            patchInProgress = MatchPatchPaths.createPatchInProgress(patch, this.myBaseDir);
            if (patchInProgress == null) break;
            result.putValue((Object)this.myBaseDir, (Object)patchInProgress);
        }
    }

    private static void selectByContextOrByStrip(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "selectByContextOrByStrip"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "selectByContextOrByStrip"));
        }
        for (PatchAndVariants candidate : candidates) {
            candidate.findAndAddBestVariant(result);
        }
    }

    private static void filterExactMatches(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "filterExactMatches"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "filterExactMatches"));
        }
        Iterator<PatchAndVariants> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            PatchAndVariants candidate = iterator.next();
            if (candidate.getVariants().size() == 1) {
                AbstractFilePatchInProgress oneCandidate = candidate.getVariants().get(0);
                result.putValue((Object)oneCandidate.getBase(), (Object)oneCandidate);
                iterator.remove();
                continue;
            }
            ArrayList<AbstractFilePatchInProgress> exact = new ArrayList<AbstractFilePatchInProgress>(candidate.getVariants().size());
            for (AbstractFilePatchInProgress patch : candidate.getVariants()) {
                if (patch.getCurrentStrip() != 0) continue;
                exact.add(patch);
            }
            if (exact.size() == 1) {
                AbstractFilePatchInProgress patchInProgress = (AbstractFilePatchInProgress)exact.get(0);
                MatchPatchPaths.putSelected(result, candidate.getVariants(), patchInProgress);
                iterator.remove();
                continue;
            }
            if (exact.isEmpty()) continue;
            candidate.getVariants().retainAll(exact);
        }
    }

    private void findCandidates(@NotNull List<? extends FilePatch> list, @NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<PatchAndVariants> candidates, @NotNull List<FilePatch> newOrWithoutMatches) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        if (directoryDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        if (newOrWithoutMatches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOrWithoutMatches", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        for (final FilePatch filePatch : list) {
            VirtualFile relativeFile;
            String fileName = filePatch.getBeforeFileName();
            if (filePatch.isNewFile() || filePatch.getBeforeName() == null) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            Collection<VirtualFile> files = this.findFilesFromIndex(directoryDetector, fileName);
            if (filePatch.getBeforeName() != null && filePatch.getBeforeName().startsWith("..") && (relativeFile = VfsUtil.findRelativeFile((VirtualFile)this.myBaseDir, (String[])filePatch.getBeforeName().replace('\\', '/').split("/"))) != null) {
                files.add(relativeFile);
            }
            if (files.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            List<AbstractFilePatchInProgress> variants = ObjectsConvertor.convert(files, new Convertor<VirtualFile, AbstractFilePatchInProgress>(){

                public AbstractFilePatchInProgress convert(VirtualFile o) {
                    return MatchPatchPaths.processMatch(filePatch, o);
                }
            }, ObjectsConvertor.NOT_NULL);
            if (variants.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            candidates.add(new PatchAndVariants(variants));
        }
    }

    private Collection<VirtualFile> findFilesFromIndex(final @NotNull PatchBaseDirectoryDetector directoryDetector, final @NotNull String fileName) {
        if (directoryDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findFilesFromIndex"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findFilesFromIndex"));
        }
        Collection files = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

            public Collection<VirtualFile> compute() {
                return directoryDetector.findFiles(fileName);
            }
        });
        final File shelfResourcesDirectory = ShelveChangesManager.getInstance(this.myProject).getShelfResourcesDirectory();
        return ContainerUtil.filter((Collection)files, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return !FileUtil.isAncestor((File)shelfResourcesDirectory, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (boolean)false);
            }
        });
    }

    private static void putSelected(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result, @NotNull List<AbstractFilePatchInProgress> variants, @NotNull AbstractFilePatchInProgress patchInProgress) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "putSelected"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "putSelected"));
        }
        if (patchInProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchInProgress", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "putSelected"));
        }
        patchInProgress.setAutoBases(ObjectsConvertor.convert(variants, new Convertor<AbstractFilePatchInProgress, VirtualFile>(){

            public VirtualFile convert(AbstractFilePatchInProgress o) {
                return o.getBase();
            }
        }, ObjectsConvertor.NOT_NULL));
        result.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
    }

    private static int getMatchingLines(AbstractFilePatchInProgress<TextFilePatch> patch) {
        String text;
        VirtualFile base = patch.getCurrentBase();
        if (base == null) {
            return -1;
        }
        try {
            text = base.getLength() > 100000L ? VfsUtilCore.loadText((VirtualFile)base, (int)100000) : VfsUtilCore.loadText((VirtualFile)base);
        }
        catch (IOException e) {
            return 0;
        }
        return new GenericPatchApplier(text, patch.getPatch().getHunks()).weightContextMatch(100, 5);
    }

    private static Pair<VirtualFile, Integer> compareNames(String beforeName, VirtualFile file) {
        if (beforeName == null) {
            return null;
        }
        String[] parts = beforeName.replace('\\', '/').split("/");
        return MatchPatchPaths.compareNamesImpl(parts, file.getParent(), parts.length - 2);
    }

    private static Pair<VirtualFile, Integer> compareNamesImpl(String[] parts, VirtualFile parent, int idx) {
        while (parent != null && idx >= 0) {
            if (!parent.getName().equals(parts[idx])) {
                return new Pair((Object)parent, (Object)(idx + 1));
            }
            parent = parent.getParent();
            --idx;
        }
        return new Pair((Object)parent, (Object)(idx + 1));
    }

    @Nullable
    private static AbstractFilePatchInProgress processMatch(FilePatch patch, VirtualFile file) {
        String beforeName = patch.getBeforeName();
        Pair<VirtualFile, Integer> pair = MatchPatchPaths.compareNames(beforeName, file);
        if (pair == null) {
            return null;
        }
        VirtualFile parent = (VirtualFile)pair.getFirst();
        if (parent == null) {
            return null;
        }
        AbstractFilePatchInProgress result = MatchPatchPaths.createPatchInProgress(patch, parent);
        if (result != null) {
            AutoMatchStrategy.processStipUp(result, (Integer)pair.getSecond());
        }
        return result;
    }

    @Nullable
    private static AbstractFilePatchInProgress createPatchInProgress(@NotNull FilePatch patch, @NotNull VirtualFile dir) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "createPatchInProgress"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "createPatchInProgress"));
        }
        return patch instanceof TextFilePatch ? new TextFilePatchInProgress((TextFilePatch)patch, null, dir) : (patch instanceof ShelveChangesManager.ShelvedBinaryFilePatch ? new BinaryFilePatchInProgress((ShelveChangesManager.ShelvedBinaryFilePatch)patch, null, dir) : null);
    }

    private class PatchAndVariants {
        @NotNull
        private final List<AbstractFilePatchInProgress> myVariants;

        private PatchAndVariants(List<AbstractFilePatchInProgress> variants) {
            if (variants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants", "<init>"));
            }
            this.myVariants = variants;
        }

        @NotNull
        public List<AbstractFilePatchInProgress> getVariants() {
            List<AbstractFilePatchInProgress> list = this.myVariants;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants", "getVariants"));
            }
            return list;
        }

        public void findAndAddBestVariant(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants", "findAndAddBestVariant"));
            }
            AbstractFilePatchInProgress best = (AbstractFilePatchInProgress)ContainerUtil.getFirstItem(this.myVariants);
            if (best == null) {
                return;
            }
            if (best instanceof TextFilePatchInProgress) {
                int maxLines = -100;
                for (AbstractFilePatchInProgress variant : this.myVariants) {
                    TextFilePatchInProgress textFilePAch = (TextFilePatchInProgress)variant;
                    int lines = MatchPatchPaths.getMatchingLines(textFilePAch);
                    if (lines <= maxLines) continue;
                    maxLines = lines;
                    best = textFilePAch;
                }
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result, this.myVariants, best);
            } else {
                int stripCounter = Integer.MAX_VALUE;
                for (AbstractFilePatchInProgress variant : this.myVariants) {
                    int currentStrip = variant.getCurrentStrip();
                    if (currentStrip == 0 && MatchPatchPaths.this.myProject.getBaseDir().equals(variant.getBase())) {
                        best = variant;
                        break;
                    }
                    if (currentStrip >= stripCounter) continue;
                    best = variant;
                    stripCounter = currentStrip;
                }
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result, this.myVariants, best);
            }
        }
    }
}

