/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchDiffRequestFactory {
    @NotNull
    public static DiffRequest createFromChange(@Nullable Project project, @NotNull Change change, @NotNull String name, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createFromChange"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createFromChange"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createFromChange"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createFromChange"));
        }
        ChangeDiffRequestProducer proxyProducer = ChangeDiffRequestProducer.create(project, change);
        if (proxyProducer == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name + "'");
        }
        DiffRequest diffRequest = proxyProducer.process(context, indicator);
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createFromChange"));
        }
        return diffRequest;
    }

    public static DiffRequest createConflict(@Nullable Project project, @Nullable VirtualFile file, @NotNull String afterTitle, final @NotNull Getter<ApplyPatchForBaseRevisionTexts> textsGetter, @NotNull String name, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (afterTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterTitle", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflict"));
        }
        if (textsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textsGetter", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflict"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflict"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflict"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflict"));
        }
        if (file == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name + "'");
        }
        if (file.getFileType().isBinary()) {
            throw new DiffRequestProducerException("Can't show diff for binary file '" + name + "'");
        }
        final Ref textsRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                textsRef.set(textsGetter.get());
            }
        }, indicator.getModalityState());
        ApplyPatchForBaseRevisionTexts texts = (ApplyPatchForBaseRevisionTexts)textsRef.get();
        if (texts.getBase() == null) {
            return ApplyPatchAction.createBadDiffRequest(project, file, texts);
        }
        String path = FileUtil.toSystemDependentName((String)file.getPresentableUrl());
        FileType type = file.getFileType();
        String windowTitle = VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{path});
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent localContent = contentFactory.createDocument(project, file);
        if (localContent == null) {
            localContent = contentFactory.create(texts.getLocal().toString(), type);
        }
        DocumentContent baseContent = contentFactory.create(texts.getBase().toString(), type);
        DocumentContent patchedContent = contentFactory.create(texts.getPatched(), type);
        return new SimpleDiffRequest(windowTitle, (DiffContent)localContent, (DiffContent)baseContent, (DiffContent)patchedContent, "Current Version", "Base Version", afterTitle);
    }
}

