/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import com.intellij.util.StringLenComparator;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootIterator {
    private final Map<String, MyRootFilter> myOtherVcsFolders;
    private final FileIndexFacade myExcludedFileIndex;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;

    public VcsRootIterator(Project project, AbstractVcs vcs) {
        VirtualFile[] roots;
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myOtherVcsFolders = new HashMap<String, MyRootFilter>();
        this.myExcludedFileIndex = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(project, FileIndexFacade.class);
        VcsRoot[] allRoots = this.myVcsManager.getAllVcsRoots();
        for (VirtualFile root : roots = this.myVcsManager.getRootsUnderVcs(vcs)) {
            MyRootFilter rootPresentFilter = new MyRootFilter(root, vcs.getName());
            rootPresentFilter.init(allRoots);
            this.myOtherVcsFolders.put(root.getUrl(), rootPresentFilter);
        }
    }

    public boolean acceptFolderUnderVcs(VirtualFile vcsRoot, VirtualFile file) {
        String vcsUrl = vcsRoot.getUrl();
        MyRootFilter rootFilter = this.myOtherVcsFolders.get(vcsUrl);
        if (rootFilter != null && !rootFilter.accept(file)) {
            return false;
        }
        return !VcsRootIterator.isIgnoredByVcs(this.myVcsManager, this.myProject, file);
    }

    private static boolean isIgnoredByVcs(final ProjectLevelVcsManager vcsManager, final Project project, final VirtualFile file) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return project.isDisposed() || vcsManager.isIgnored(file);
            }
        });
    }

    public static void iterateVfUnderVcsRoot(Project project, VirtualFile root, Processor<VirtualFile> processor) {
        MyRootIterator rootIterator = new MyRootIterator(project, root, null, processor, null);
        rootIterator.iterate();
    }

    public static void iterateVcsRoot(Project project, VirtualFile root, Processor<FilePath> processor) {
        VcsRootIterator.iterateVcsRoot(project, root, processor, null);
    }

    public static void iterateVcsRoot(Project project, VirtualFile root, Processor<FilePath> processor, @Nullable VirtualFileFilter directoryFilter) {
        MyRootIterator rootIterator = new MyRootIterator(project, root, processor, null, directoryFilter);
        rootIterator.iterate();
    }

    private static class MyRootIterator {
        private final Project myProject;
        private final Processor<FilePath> myPathProcessor;
        private final Processor<VirtualFile> myFileProcessor;
        @Nullable
        private final VirtualFileFilter myDirectoryFilter;
        private final VirtualFile myRoot;
        private final MyRootFilter myRootPresentFilter;
        private final ProjectLevelVcsManager myVcsManager;

        private MyRootIterator(Project project, VirtualFile root, @Nullable Processor<FilePath> pathProcessor, @Nullable Processor<VirtualFile> fileProcessor, @Nullable VirtualFileFilter directoryFilter) {
            this.myProject = project;
            this.myPathProcessor = pathProcessor;
            this.myFileProcessor = fileProcessor;
            this.myDirectoryFilter = directoryFilter;
            this.myRoot = root;
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            AbstractVcs vcs = this.myVcsManager.getVcsFor(root);
            MyRootFilter myRootFilter = this.myRootPresentFilter = vcs == null ? null : new MyRootFilter(root, vcs.getName());
            if (this.myRootPresentFilter != null) {
                this.myRootPresentFilter.init(this.myVcsManager.getAllVcsRoots());
            }
        }

        public void iterate() {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

                public void afterChildrenVisited(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "afterChildrenVisited"));
                    }
                    if (MyRootIterator.this.myDirectoryFilter != null) {
                        MyRootIterator.this.myDirectoryFilter.afterChildrenVisited(file);
                    }
                }

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "visitFileEx"));
                    }
                    if (VcsRootIterator.isIgnoredByVcs(MyRootIterator.this.myVcsManager, MyRootIterator.this.myProject, file)) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "visitFileEx"));
                        }
                        return result;
                    }
                    if (MyRootIterator.this.myRootPresentFilter != null && !MyRootIterator.this.myRootPresentFilter.accept(file)) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "visitFileEx"));
                        }
                        return result;
                    }
                    if (MyRootIterator.this.myProject.isDisposed() || !MyRootIterator.this.process(file)) {
                        VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)MyRootIterator.this.myRoot);
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "visitFileEx"));
                        }
                        return result;
                    }
                    if (MyRootIterator.this.myDirectoryFilter != null && file.isDirectory() && !MyRootIterator.this.myDirectoryFilter.shouldGoIntoDirectory(file)) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "visitFileEx"));
                        }
                        return result;
                    }
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1", "visitFileEx"));
                    }
                    return result;
                }
            });
        }

        private boolean process(VirtualFile current) {
            if (this.myPathProcessor != null) {
                return this.myPathProcessor.process((Object)VcsUtil.getFilePath((VirtualFile)current));
            }
            if (this.myFileProcessor != null) {
                return this.myFileProcessor.process((Object)current);
            }
            return false;
        }
    }

    private static class MyRootFilter {
        private final VirtualFile myRoot;
        private final String myVcsName;
        private final List<String> myExcludedByOthers;

        private MyRootFilter(VirtualFile root, String vcsName) {
            this.myRoot = root;
            this.myVcsName = vcsName;
            this.myExcludedByOthers = new LinkedList<String>();
        }

        private void init(VcsRoot[] allRoots) {
            String ourPath = this.myRoot.getUrl();
            for (VcsRoot root : allRoots) {
                String url;
                VirtualFile path;
                AbstractVcs vcs = root.getVcs();
                if (vcs == null || Comparing.equal((String)vcs.getName(), (String)this.myVcsName) || (path = root.getPath()) == null || !(url = path.getUrl()).startsWith(ourPath)) continue;
                this.myExcludedByOthers.add(url);
            }
            Collections.sort(this.myExcludedByOthers, StringLenComparator.getDescendingInstance());
        }

        public boolean accept(VirtualFile vf) {
            String url = vf.getUrl();
            for (String excludedByOtherVcs : this.myExcludedByOthers) {
                if (url.length() > excludedByOtherVcs.length()) {
                    return true;
                }
                if (!url.startsWith(excludedByOtherVcs)) continue;
                return false;
            }
            return true;
        }
    }
}

