/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class JrtHandler
extends ArchiveHandler {
    private static final URI ROOT_URI = URI.create("jrt:/");
    private static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();
    private static final String PREFIX = "/modules";
    private SoftReference<Object> myFileSystem;
    private static final Method newFileSystem = JrtHandler.method("java.nio.file.FileSystems#newFileSystem", URI.class, Map.class, ClassLoader.class);
    private static final Method getPath = JrtHandler.method("java.nio.file.FileSystem#getPath", String.class, String[].class);
    private static final Method walk = JrtHandler.method("java.nio.file.Files#walk", JrtHandler.cls("java.nio.file.Path"), JrtHandler.cls("java.nio.file.FileVisitOption", true));
    private static final Method forEachOrdered = JrtHandler.method("java.util.stream.Stream#forEachOrdered", JrtHandler.cls("java.util.function.Consumer"));
    private static final Method readAttributes = JrtHandler.method("java.nio.file.Files#readAttributes", JrtHandler.cls("java.nio.file.Path"), Class.class, JrtHandler.cls("java.nio.file.LinkOption", true));
    private static final Method isDirectory = JrtHandler.method("java.nio.file.attribute.BasicFileAttributes#isDirectory", new Class[0]);
    private static final Method size = JrtHandler.method("java.nio.file.attribute.BasicFileAttributes#size", new Class[0]);
    private static final Method lastModifiedTime = JrtHandler.method("java.nio.file.attribute.BasicFileAttributes#lastModifiedTime", new Class[0]);
    private static final Method toMillis = JrtHandler.method("java.nio.file.attribute.FileTime#toMillis", new Class[0]);
    private static final Method readAllBytes = JrtHandler.method("java.nio.file.Files#readAllBytes", JrtHandler.cls("java.nio.file.Path"));
    private static final Object linkOptions = Array.newInstance(JrtHandler.cls("java.nio.file.LinkOption"), 0);

    public JrtHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "<init>"));
        }
        super(path);
    }

    private synchronized Object getFileSystem() throws IOException {
        Object fs = SoftReference.dereference(this.myFileSystem);
        if (fs == null) {
            URL url = new File(this.getFile(), "jrt-fs.jar").toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, null);
            fs = JrtHandler.call(newFileSystem, ROOT_URI, EMPTY_ENV, loader);
            this.myFileSystem = new SoftReference(fs);
        }
        return fs;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        final HashMap map = ContainerUtil.newHashMap();
        map.put("", this.createRootEntry());
        Object fs = this.getFileSystem();
        Object root = JrtHandler.call(getPath, fs, PREFIX, ArrayUtil.EMPTY_STRING_ARRAY);
        Object stream = JrtHandler.call(walk, root, Array.newInstance(JrtHandler.cls("java.nio.file.FileVisitOption"), 0));
        JrtHandler.call(forEachOrdered, stream, Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{JrtHandler.cls("java.util.function.Consumer")}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ArchiveHandler.EntryInfo parent;
                String shortName;
                String path = args[0].toString();
                int p = path.indexOf(47, JrtHandler.PREFIX.length() + 1);
                if (p < 0) {
                    return null;
                }
                String module = path.substring(1, p);
                if (map.containsKey(path = path.substring(p + 1))) {
                    return null;
                }
                p = path.lastIndexOf(47);
                if (p < 0) {
                    shortName = path;
                    parent = (ArchiveHandler.EntryInfo)map.get("");
                } else {
                    shortName = path.substring(p + 1);
                    parent = (ArchiveHandler.EntryInfo)map.get(path.substring(0, p));
                }
                assert (parent != null) : path;
                Object attributes = JrtHandler.call(readAttributes, new Object[]{args[0], JrtHandler.cls("java.nio.file.attribute.BasicFileAttributes"), linkOptions});
                boolean dir = (Boolean)JrtHandler.call(isDirectory, new Object[]{attributes});
                long length = (Long)JrtHandler.call(size, new Object[]{attributes});
                long modified = (Long)JrtHandler.call(toMillis, new Object[]{JrtHandler.call(lastModifiedTime, new Object[]{attributes})});
                ArchiveHandler.EntryInfo entry = dir ? new ArchiveHandler.EntryInfo((CharSequence)shortName, true, length, modified, parent) : new JrtEntryInfo(shortName, module, length, modified, parent);
                map.put(path, entry);
                return null;
            }
        }));
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "createEntriesMap"));
        }
        return hashMap;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
        }
        ArchiveHandler.EntryInfo entry = this.getEntryInfo(relativePath);
        if (!(entry instanceof JrtEntryInfo)) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        Object fs = this.getFileSystem();
        Object path = JrtHandler.call(getPath, fs, ((JrtEntryInfo)entry).myModule, new String[]{relativePath});
        byte[] byArray = (byte[])JrtHandler.call(readAllBytes, path);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtHandler", "contentsToByteArray"));
        }
        return byArray;
    }

    private static Class<?> cls(String name) {
        return JrtHandler.cls(name, false);
    }

    private static Class<?> cls(String name, boolean array) {
        if (array) {
            name = "[L" + name + ";";
        }
        return ReflectionUtil.forName((String)name);
    }

    private static Method method(String name, Class<?> ... parameterTypes) {
        List parts = StringUtil.split((String)name, (String)"#");
        Class<?> aClass = JrtHandler.cls((String)parts.get(0));
        String methodName = (String)parts.get(1);
        return ReflectionUtil.getMethod(aClass, (String)methodName, (Class[])parameterTypes);
    }

    private static Object call(Method method, Object ... args) {
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, args);
            }
            return method.invoke(args[0], Arrays.copyOfRange(args, 1, args.length));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class JrtEntryInfo
    extends ArchiveHandler.EntryInfo {
        private final String myModule;

        /*
         * WARNING - void declaration
         */
        public JrtEntryInfo(@NotNull String shortName, @NotNull String module, long length, long timestamp, ArchiveHandler.EntryInfo entryInfo) {
            void parent;
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/jrt/JrtHandler$JrtEntryInfo", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/vfs/impl/jrt/JrtHandler$JrtEntryInfo", "<init>"));
            }
            super((CharSequence)shortName, false, length, timestamp, (ArchiveHandler.EntryInfo)parent);
            this.myModule = module;
        }
    }
}

