/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcher {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher$1", "compute"));
            }
            return notificationGroup;
        }
    };
    private final Object myLock;
    private final PluggableFileWatcher[] myWatchers;
    private DirtyPaths myDirtyPaths;
    private final AtomicBoolean myFailureShownToTheUser;
    private volatile Runnable myTestNotifier;

    FileWatcher(@NotNull ManagingFS managingFS) {
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managingFS", "com/intellij/openapi/vfs/impl/local/FileWatcher", "<init>"));
        }
        this.myLock = new Object();
        this.myDirtyPaths = new DirtyPaths();
        this.myFailureShownToTheUser = new AtomicBoolean(false);
        this.myTestNotifier = null;
        MyFileWatcherNotificationSink notificationSink = new MyFileWatcherNotificationSink();
        for (PluggableFileWatcher watcher : this.myWatchers = (PluggableFileWatcher[])PluggableFileWatcher.EP_NAME.getExtensions()) {
            watcher.initialize(managingFS, (FileWatcherNotificationSink)notificationSink);
        }
    }

    public void dispose() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.dispose();
        }
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (watcher.isOperational()) continue;
            return false;
        }
        return true;
    }

    public boolean isSettingRoots() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DirtyPaths getDirtyPaths() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myDirtyPaths.isEmpty()) {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            // MONITOREXIT : object
            if (dirtyPaths != null) return dirtyPaths;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getDirtyPaths"));
        }
        DirtyPaths dirtyPaths = this.myDirtyPaths;
        this.myDirtyPaths = new DirtyPaths();
        PluggableFileWatcher[] pluggableFileWatcherArray = this.myWatchers;
        int n = pluggableFileWatcherArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                DirtyPaths dirtyPaths2 = dirtyPaths;
                // MONITOREXIT : object
                if (dirtyPaths2 != null) return dirtyPaths2;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getDirtyPaths"));
            }
            PluggableFileWatcher watcher = pluggableFileWatcherArray[n2];
            watcher.resetChangedPaths();
            ++n2;
        }
    }

    @NotNull
    public List<String> getManualWatchRoots() {
        if (this.myWatchers.length == 1) {
            List list = this.myWatchers[0].getManualWatchRoots();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getManualWatchRoots"));
            }
            return list;
        }
        HashSet result = null;
        for (PluggableFileWatcher watcher : this.myWatchers) {
            List roots = watcher.getManualWatchRoots();
            if (result == null) {
                result = new HashSet((Collection)roots);
                continue;
            }
            result.retainAll((Collection)roots);
        }
        if (result == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getManualWatchRoots"));
            }
            return list;
        }
        ArrayList<String> arrayList = Collections.list(Collections.enumeration(result));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getManualWatchRoots"));
        }
        return arrayList;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/openapi/vfs/impl/local/FileWatcher", "setWatchRoots"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/openapi/vfs/impl/local/FileWatcher", "setWatchRoots"));
        }
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.setWatchRoots(recursive, flat);
        }
    }

    public boolean isWatched(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/FileWatcher", "isWatched"));
        }
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isWatched(file)) continue;
            return true;
        }
        return false;
    }

    public void notifyOnFailure(final String cause, final @Nullable NotificationListener listener) {
        LOG.warn(cause);
        if (this.myFailureShownToTheUser.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
                    Notifications.Bus.notify((Notification)((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(title, cause, NotificationType.WARNING, listener));
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public void shutdown() throws InterruptedException {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.shutdown();
        }
        this.myTestNotifier = null;
    }

    public void startup(@Nullable Runnable notifier) throws IOException {
        this.myTestNotifier = notifier;
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.startup();
        }
    }

    private class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPaths(Collection<String> paths) {
            Object object = FileWatcher.this.myLock;
            synchronized (object) {
                ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPaths.addAll(paths);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectories(Collection<String> paths) {
            Object object = FileWatcher.this.myLock;
            synchronized (object) {
                ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyDirectories.addAll(paths);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathsRecursive(Collection<String> paths) {
            Object object = FileWatcher.this.myLock;
            synchronized (object) {
                ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPathsRecursive.addAll(paths);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathsCreatedOrDeleted(Collection<String> paths) {
            Object object = FileWatcher.this.myLock;
            synchronized (object) {
                for (String p : paths) {
                    ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPathsRecursive.add(p);
                    String parentPath = new File(p).getParent();
                    if (parentPath == null) continue;
                    ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPaths.add(parentPath);
                }
            }
        }

        public void notifyOnAnyEvent() {
            Runnable notifier = FileWatcher.this.myTestNotifier;
            if (notifier != null) {
                notifier.run();
            }
        }

        public void notifyUserOnFailure(String cause, NotificationListener listener) {
            FileWatcher.this.notifyOnFailure(cause, listener);
        }
    }

    public static class DirtyPaths {
        public final List<String> dirtyPaths = ContainerUtil.newArrayList();
        public final List<String> dirtyPathsRecursive = ContainerUtil.newArrayList();
        public final List<String> dirtyDirectories = ContainerUtil.newArrayList();
        public static final DirtyPaths EMPTY = new DirtyPaths();

        public boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }
    }
}

