/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private static final FileAttributes FAKE_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "findFileByIoFile"));
        }
        String path = file.getAbsolutePath();
        return this.findFileByPath(path.replace(File.separatorChar, '/'));
    }

    @NotNull
    protected static File convertToIOFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFile"));
        }
        String path = file.getPath();
        if (StringUtil.endsWithChar((CharSequence)path, (char)':') && path.length() == 2 && (SystemInfo.isWindows || SystemInfo.isOS2)) {
            path = path + "/";
        }
        File file2 = new File(path);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFile"));
        }
        return file2;
    }

    @NotNull
    private static File convertToIOFileAndCheck(@NotNull VirtualFile file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFileAndCheck"));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file);
        FileAttributes attributes = FileSystemUtil.getAttributes((File)ioFile);
        if (attributes != null && !attributes.isFile()) {
            LOG.warn("not a file: " + ioFile + ", " + attributes);
            throw new FileNotFoundException("Not a file: " + ioFile);
        }
        File file2 = ioFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFileAndCheck"));
        }
        return file2;
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "exists"));
        }
        return this.getAttributes(file) != null;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getLength"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null ? attributes.length : 0L;
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getTimeStamp"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null ? attributes.lastModified : 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isDirectory"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isWritable"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isSymLink"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "resolveSymLink"));
        }
        return FileSystemUtil.resolveSymLink((String)file.getPath());
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        String[] names;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
        }
        if (file.getParent() == null) {
            File[] roots = File.listRoots();
            if (roots.length == 1 && roots[0].getName().isEmpty()) {
                String[] list = roots[0].list();
                if (list != null) {
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
                    }
                    return list;
                }
                LOG.warn("Root '" + roots[0] + "' has no children - is it readable?");
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (file.getName().isEmpty()) {
                String[] names2 = new String[roots.length];
                for (int i = 0; i < names2.length; ++i) {
                    String name = roots[i].getPath();
                    if (name.endsWith(File.separator)) {
                        name = name.substring(0, name.length() - File.separator.length());
                    }
                    names2[i] = name;
                }
                if (names2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
                }
                return names2;
            }
        }
        String[] stringArray = (names = LocalFileSystemBase.convertToIOFile(file).list()) == null ? ArrayUtil.EMPTY_STRING_ARRAY : names;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
        }
        return stringArray;
    }

    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getProtocol"));
        }
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "normalize"));
        }
        if (path.isEmpty()) {
            try {
                path = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                return path;
            }
        }
        if (SystemInfo.isWindows) {
            if (path.charAt(0) == '/' && !path.startsWith("//")) {
                path = path.substring(1);
            }
            if (path.contains("~")) {
                try {
                    path = new File(FileUtil.toSystemDependentName((String)path)).getCanonicalPath();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        File file = new File(path);
        if (!LocalFileSystemBase.isAbsoluteFileOrDriveLetter(file)) {
            path = file.getAbsolutePath();
        }
        return FileUtil.normalize((String)path);
    }

    private static boolean isAbsoluteFileOrDriveLetter(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isAbsoluteFileOrDriveLetter"));
        }
        String path = file.getPath();
        if (SystemInfo.isWindows && path.length() == 2 && path.charAt(1) == ':') {
            return true;
        }
        return file.isAbsolute();
    }

    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshAndFindFileByIoFile"));
        }
        String path = file.getAbsolutePath();
        return this.refreshAndFindFileByPath(path.replace(File.separatorChar, '/'));
    }

    public void refreshIoFiles(@NotNull Iterable<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshIoFiles"));
        }
        this.refreshIoFiles(files, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIoFiles(@NotNull Iterable<File> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        boolean fireCommonRefreshSession;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshIoFiles"));
        }
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file : files) {
                VirtualFile virtualFile = this.refreshAndFindFileByIoFile(file);
                if (virtualFile == null) continue;
                filesToRefresh.add(virtualFile);
            }
            RefreshQueue.getInstance().refresh(async, recursive, onFinish, filesToRefresh);
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshFiles"));
        }
        this.refreshFiles(files, false, false, null);
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshFiles"));
        }
        RefreshQueue.getInstance().refresh(async, recursive, onFinish, ContainerUtil.toCollection(files));
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "registerAuxiliaryFileOperationsHandler"));
        }
        if (this.myHandlers.contains(handler)) {
            LOG.error("Handler " + handler + " already registered.");
        }
        this.myHandlers.add(handler);
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "unregisterAuxiliaryFileOperationsHandler"));
        }
        if (!this.myHandlers.remove(handler)) {
            LOG.error("Handler" + handler + " haven't been registered or already unregistered.");
        }
    }

    public boolean processCachedFilesInSubtree(@NotNull VirtualFile file, @NotNull Processor<VirtualFile> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processCachedFilesInSubtree"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processCachedFilesInSubtree"));
        }
        return file.getFileSystem() != this || LocalFileSystemBase.processFile((NewVirtualFile)file, processor);
    }

    private static boolean processFile(@NotNull NewVirtualFile file, @NotNull Processor<VirtualFile> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processFile"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processFile"));
        }
        if (!processor.process((Object)file)) {
            return false;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getCachedChildren()) {
                if (LocalFileSystemBase.processFile((NewVirtualFile)child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean auxDelete(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxDelete"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.delete(file)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(@NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxMove"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxMove"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.move(file, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(@NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String copyName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCopy"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCopy"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCopy"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            File copy = handler.copy(file, toDir, copyName);
            if (copy == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(@NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxRename"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.rename(file, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateFile"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.createFile(dir, name)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateDirectory"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateDirectory"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.createDirectory(dir, name)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxNotifyCompleted"));
        }
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            handler.afterDone(consumer);
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, final @NotNull VirtualFile parent, final @NotNull String dir) throws IOException {
        File ioDir;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildDirectory"));
        }
        if (!VirtualFile.isValidName((String)dir)) {
            throw new IOException(VfsBundle.message((String)"directory.invalid.name.error", (Object[])new Object[]{dir}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(dir) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + dir}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!(this.auxCreateDirectory(parent, dir) || (ioDir = new File(ioParent, dir)).mkdirs() || ioDir.isDirectory())) {
            throw new IOException(VfsBundle.message((String)"new.directory.failed.error", (Object[])new Object[]{ioDir.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.createDirectory(parent, dir);
            }
        });
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, dir);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildDirectory"));
        }
        return fakeVirtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, final @NotNull VirtualFile parent, final @NotNull String file) throws IOException {
        File ioFile;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildFile"));
        }
        if (!VirtualFile.isValidName((String)file)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{file}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(file) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + file}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!this.auxCreateFile(parent, file) && !FileUtil.createIfDoesntExist((File)(ioFile = new File(ioParent, file)))) {
            throw new IOException(VfsBundle.message((String)"new.file.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.createFile(parent, file);
            }
        });
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, file);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildFile"));
        }
        return fakeVirtualFile;
    }

    public void deleteFile(Object requestor, final @NotNull VirtualFile file) throws IOException {
        File ioFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "deleteFile"));
        }
        if (file.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.delete.root.directory", (Object[])new Object[]{file.getPath()}));
        }
        if (!this.auxDelete(file) && !FileUtil.delete((File)(ioFile = LocalFileSystemBase.convertToIOFile(file)))) {
            throw new IOException(VfsBundle.message((String)"delete.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.delete(file);
            }
        });
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getInputStream"));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file)));
        if (bufferedInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getInputStream"));
        }
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] byArray;
        FileInputStream stream;
        block6: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "contentsToByteArray"));
            }
            stream = new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file));
            long l = file.getLength();
            if (l > Integer.MAX_VALUE) {
                throw new IOException("File is too large: " + l + ", " + file);
            }
            int length = (int)l;
            if (length < 0) {
                throw new IOException("Invalid file length: " + length + ", " + file);
            }
            byArray = FileUtil.loadBytes((InputStream)(length <= 8192 ? stream : new BufferedInputStream(stream)), (int)length);
            if (byArray != null) break block6;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "contentsToByteArray"));
        }
        return byArray;
        finally {
            ((InputStream)stream).close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        void timeStamp;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getOutputStream"));
        }
        File ioFile = LocalFileSystemBase.convertToIOFileAndCheck(file);
        Object stream = LocalFileSystemBase.shallUseSafeStream(requestor, file) ? new SafeFileOutputStream(ioFile, SystemInfo.isUnix) : new FileOutputStream(ioFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)stream, (long)timeStamp, ioFile){
            final /* synthetic */ long val$timeStamp;
            final /* synthetic */ File val$ioFile;
            {
                this.val$timeStamp = l;
                this.val$ioFile = file;
                super(x0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.val$timeStamp > 0L && this.val$ioFile.exists() && !this.val$ioFile.setLastModified(this.val$timeStamp)) {
                    LOG.warn("Failed: " + this.val$ioFile.getPath() + ", new:" + this.val$timeStamp + ", old:" + this.val$ioFile.lastModified());
                }
            }
        };
        if (bufferedOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getOutputStream"));
        }
        return bufferedOutputStream;
    }

    private static boolean shallUseSafeStream(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "shallUseSafeStream"));
        }
        return requestor instanceof SafeWriteRequestor && GeneralSettings.getInstance().isUseSafeWrite() && !file.is(VFileProperty.SYMLINK);
    }

    public void moveFile(Object requestor, final @NotNull VirtualFile file, final @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "moveFile"));
        }
        String name = file.getName();
        if (!file.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file.getPath()}));
        }
        if (file.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(name) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + name}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file);
        if (FileSystemUtil.getAttributes((File)ioFile) == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, name);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxMove(file, newParent) && !ioFile.renameTo(ioTarget)) {
            throw new IOException(VfsBundle.message((String)"move.failed.error", (Object[])new Object[]{ioFile.getPath(), ioParent.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.move(file, newParent);
            }
        });
    }

    public void renameFile(Object requestor, final @NotNull VirtualFile file, final @NotNull String newName) throws IOException {
        boolean sameName;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "renameFile"));
        }
        if (!VirtualFile.isValidName((String)newName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        boolean bl = sameName = !this.isCaseSensitive() && newName.equalsIgnoreCase(file.getName());
        if (!file.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file.getPath()}));
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file.getPath()}));
        }
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + newName}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file);
        if (!ioFile.exists()) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioTarget = new File(LocalFileSystemBase.convertToIOFile(parent), newName);
        if (!sameName && ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxRename(file, newName) && !FileUtil.rename((File)ioFile, (String)newName)) {
            throw new IOException(VfsBundle.message((String)"rename.failed.error", (Object[])new Object[]{ioFile.getPath(), newName}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.rename(file, newName);
            }
        });
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, final @NotNull VirtualFile file, final @NotNull VirtualFile newParent, final @NotNull String copyName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        if (!VirtualFile.isValidName((String)copyName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{copyName}));
        }
        if (!file.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(copyName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + copyName}));
        }
        FileAttributes attributes = this.getAttributes(file);
        if (attributes == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{file.getPath()}));
        }
        if (attributes.isSpecial()) {
            throw new FileNotFoundException("Not a file: " + file);
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, copyName);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxCopy(file, newParent, copyName)) {
            try {
                File ioFile = LocalFileSystemBase.convertToIOFile(file);
                FileUtil.copyFileOrDir((File)ioFile, (File)ioTarget, (boolean)attributes.isDirectory());
            }
            catch (IOException e) {
                FileUtil.delete((File)ioTarget);
                throw e;
            }
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.copy(file, newParent, copyName);
            }
        });
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(newParent, copyName);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        return fakeVirtualFile;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "setTimeStamp"));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file);
        if (ioFile.exists() && !ioFile.setLastModified(timeStamp)) {
            LOG.warn("Failed: " + file.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
        }
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "setWritable"));
        }
        FileUtil.setReadOnlyAttribute((String)file.getPath(), (!writableFlag ? 1 : 0) != 0);
        File ioFile = LocalFileSystemBase.convertToIOFile(file);
        if (ioFile.canWrite() != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + ioFile.getPath());
        }
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
        }
        if (path.isEmpty()) {
            String string;
            try {
                string = this.extractRootPath(new File("").getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            if (path.length() >= 2 && path.charAt(1) == ':') {
                String string = path.substring(0, 2).toUpperCase(Locale.US);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
                }
                return string;
            }
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                int idx;
                int slashCount = 0;
                for (idx = 2; idx < path.length() && slashCount < 2; ++idx) {
                    char c = path.charAt(idx);
                    if (c != '\\' && c != '/') continue;
                    ++slashCount;
                    --idx;
                }
                String string = path.substring(0, idx);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
            }
            return "";
        }
        String string = StringUtil.startsWithChar((CharSequence)path, (char)'/') ? "/" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getAttributes"));
        }
        String path = this.normalize(file.getPath());
        if (path == null) {
            return null;
        }
        if (file.getParent() == null && path.startsWith("//")) {
            return FAKE_ROOT_ATTRIBUTES;
        }
        return FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)path));
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }
}

