/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.LRUConcurrentIntObjectMap;
import com.intellij.util.text.ByteArrayCharSequence;
import org.jetbrains.annotations.NotNull;

public class FileNameCache {
    private static final LRUConcurrentIntObjectMap<CharSequence> ourNameCache = new LRUConcurrentIntObjectMap(65000);
    private static final LRUConcurrentIntObjectMap.IntFunction<CharSequence> getNameById = new LRUConcurrentIntObjectMap.IntFunction<CharSequence>(){

        @NotNull
        public CharSequence apply(int id) {
            String name = FSRecords.getNameByNameId(id);
            CharSequence charSequence = ByteArrayCharSequence.convertToBytesIfAsciiString((String)name);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache$1", "apply"));
            }
            return charSequence;
        }
    };

    public static int storeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "storeName"));
        }
        int idx = FSRecords.getNameId(name);
        CharSequence rawName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)name);
        ourNameCache.put(idx, (Object)rawName);
        return idx;
    }

    @NotNull
    public static CharSequence getVFileName(int nameId) {
        assert (nameId > 0) : nameId;
        CharSequence charSequence = (CharSequence)ourNameCache.computeIfAbsent(nameId, getNameById);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
        }
        return charSequence;
    }
}

