/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.VolatileImage;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PaintersHelper
implements Painter.Listener {
    private final Set<Painter> myPainters;
    private final Map<Painter, Component> myPainter2Component;
    private final JComponent myRootComponent;

    public PaintersHelper(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/PaintersHelper", "<init>"));
        }
        this.myPainters = ContainerUtil.newLinkedHashSet();
        this.myPainter2Component = ContainerUtil.newLinkedHashMap();
        this.myRootComponent = component;
    }

    public boolean hasPainters() {
        return !this.myPainters.isEmpty();
    }

    public void addPainter(@NotNull Painter painter, @Nullable Component component) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/wm/impl/PaintersHelper", "addPainter"));
        }
        this.myPainters.add(painter);
        this.myPainter2Component.put(painter, component == null ? this.myRootComponent : component);
        painter.addListener((Painter.Listener)this);
    }

    public void removePainter(@NotNull Painter painter) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/wm/impl/PaintersHelper", "removePainter"));
        }
        painter.removeListener((Painter.Listener)this);
        this.myPainters.remove(painter);
        this.myPainter2Component.remove(painter);
    }

    public void clear() {
        for (Painter painter : this.myPainters) {
            painter.removeListener((Painter.Listener)this);
        }
        this.myPainters.clear();
        this.myPainter2Component.clear();
    }

    public void paint(Graphics g) {
        this.paint(g, this.myRootComponent);
    }

    public void paint(Graphics g, JComponent current) {
        if (this.myPainters.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clip = (Rectangle)ObjectUtils.notNull((Object)g.getClipBounds(), (Object)current.getBounds());
        Component component = null;
        Rectangle componentBounds = null;
        boolean clipMatched = false;
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.myPainter2Component.get(painter);
            if (cur != component || componentBounds == null) {
                component = cur;
                Container parent = component.getParent();
                if (parent == null) continue;
                componentBounds = SwingUtilities.convertRectangle(parent, component.getBounds(), current);
                boolean bl = clipMatched = clip.contains(componentBounds) || clip.intersects(componentBounds);
            }
            if (!clipMatched) continue;
            Point targetPoint = SwingUtilities.convertPoint(current, 0, 0, component);
            Rectangle targetRect = new Rectangle(targetPoint, component.getSize());
            g2d.setClip(clip.intersection(componentBounds));
            g2d.translate(-targetRect.x, -targetRect.y);
            painter.paint(component, g2d);
            g2d.translate(targetRect.x, targetRect.y);
        }
    }

    public void onNeedsRepaint(Painter painter, JComponent dirtyComponent) {
        if (dirtyComponent != null && dirtyComponent.isShowing()) {
            Rectangle rec = SwingUtilities.convertRectangle(dirtyComponent, dirtyComponent.getBounds(), this.myRootComponent);
            this.myRootComponent.repaint(rec);
        } else {
            this.myRootComponent.repaint();
        }
    }

    public static void initWallpaperPainter(@NotNull String propertyName, @NotNull PaintersHelper painters) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/openapi/wm/impl/PaintersHelper", "initWallpaperPainter"));
        }
        if (painters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painters", "com/intellij/openapi/wm/impl/PaintersHelper", "initWallpaperPainter"));
        }
        String value = System.getProperty(propertyName);
        if (value == null && !new File(PathManager.getConfigPath(), propertyName + ".png").exists()) {
            return;
        }
        ImagePainter painter = (ImagePainter)PaintersHelper.newWallpaperPainter(propertyName);
        painters.addPainter((Painter)painter, null);
    }

    private static AbstractPainter newWallpaperPainter(final @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/openapi/wm/impl/PaintersHelper", "newWallpaperPainter"));
        }
        return new ImagePainter(){
            Image image;
            float alpha;
            Insets insets;
            FillType fillType;
            String current;

            public void executePaint(Component component, Graphics2D g) {
                String value = StringUtil.notNullize((String)System.getProperty(propertyName), (String)(propertyName + ".png"));
                if (!Comparing.equal((String)value, (String)this.current)) {
                    this.current = value;
                    this.scaled = null;
                    this.image = null;
                    this.insets = JBUI.emptyInsets();
                    String[] parts = value.split(",");
                    try {
                        this.alpha = (float)StringUtil.parseInt((String)(parts.length > 1 ? parts[1] : ""), (int)10) / 100.0f;
                        try {
                            this.fillType = FillType.valueOf(parts.length > 2 ? parts[2].toUpperCase(Locale.ENGLISH) : "");
                        }
                        catch (IllegalArgumentException e) {
                            this.fillType = FillType.SCALE;
                        }
                        String filePath = parts[0];
                        URL url = filePath.contains("://") ? new URL(filePath) : (FileUtil.isAbsolutePlatformIndependent((String)filePath) ? new File(filePath) : new File(PathManager.getConfigPath(), filePath)).toURI().toURL();
                        this.image = ImageLoader.loadFromUrl((URL)url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.image == null) {
                    return;
                }
                this.executePaint(g, component, this.image, this.fillType, this.alpha, this.insets);
            }
        };
    }

    public static AbstractPainter newImagePainter(final Image image, final FillType fillType, final float alpha, final Insets insets) {
        return new ImagePainter(){

            public void executePaint(Component component, Graphics2D g) {
                this.executePaint(g, component, image, fillType, alpha, insets);
            }
        };
    }

    private static abstract class ImagePainter
    extends AbstractPainter {
        VolatileImage scaled;

        private ImagePainter() {
        }

        public boolean needsRepaint() {
            return true;
        }

        public void executePaint(Graphics2D g, Component component, Image image, FillType fillType, float alpha, Insets insets) {
            int y;
            int x;
            int cw0 = component.getWidth();
            int ch0 = component.getHeight();
            JBInsets i = JBUI.insets((int)(insets.top * ch0 / 100), (int)(insets.left * cw0 / 100), (int)(insets.bottom * ch0 / 100), (int)(insets.right * cw0 / 100));
            int cw = cw0 - i.left - i.right;
            int ch = ch0 - i.top - i.bottom;
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w <= 0 || h <= 0) {
                return;
            }
            if (fillType == FillType.SCALE || fillType == FillType.TILE) {
                int sh;
                int sw;
                int sh0;
                int sw0 = this.scaled == null ? -1 : this.scaled.getWidth(null);
                int n = sh0 = this.scaled == null ? -1 : this.scaled.getHeight(null);
                if (fillType == FillType.SCALE) {
                    boolean useWidth = cw * h > ch * w;
                    sw = useWidth ? cw : w * ch / h;
                    sh = useWidth ? h * cw / w : ch;
                } else {
                    sw = cw < w ? w : (cw + w) / w * w;
                    int n2 = sh = ch < h ? h : (ch + h) / h * h;
                }
                if (sw0 != sw || sh0 != sh || this.scaled != null && this.scaled.contentsLost()) {
                    if (sw0 != sw || sh0 != sh || this.scaled == null) {
                        this.scaled = ImagePainter.createImage(g, sw, sh);
                    }
                    Graphics2D gg = this.scaled.createGraphics();
                    gg.setComposite(AlphaComposite.Src);
                    if (fillType == FillType.SCALE) {
                        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        gg.drawImage(image, 0, 0, sw, sh, null);
                    } else {
                        for (int x2 = 0; x2 < sw; x2 += w) {
                            for (int y2 = 0; y2 < sh; y2 += h) {
                                UIUtil.drawImage((Graphics)gg, (Image)image, (int)x2, (int)y2, null);
                            }
                        }
                    }
                    gg.dispose();
                }
                w = sw;
                h = sh;
            } else if (this.scaled == null || this.scaled.contentsLost()) {
                if (this.scaled == null) {
                    this.scaled = ImagePainter.createImage(g, w, h);
                }
                Graphics2D gg = this.scaled.createGraphics();
                gg.setComposite(AlphaComposite.Src);
                gg.drawImage(image, 0, 0, null);
                gg.dispose();
            }
            if (fillType == FillType.CENTER || fillType == FillType.BG_CENTER || fillType == FillType.SCALE || fillType == FillType.TILE || fillType == FillType.TOP_CENTER || fillType == FillType.BOTTOM_CENTER) {
                x = i.left + (cw - w) / 2;
                y = fillType == FillType.TOP_CENTER ? i.top : (fillType == FillType.BOTTOM_CENTER ? ch0 - i.bottom - h : i.top + (ch - h) / 2);
            } else if (fillType == FillType.TOP_LEFT || fillType == FillType.TOP_RIGHT || fillType == FillType.BOTTOM_LEFT || fillType == FillType.BOTTOM_RIGHT) {
                x = fillType == FillType.TOP_LEFT || fillType == FillType.BOTTOM_LEFT ? i.left : cw0 - i.right - w;
                y = fillType == FillType.TOP_LEFT || fillType == FillType.TOP_RIGHT ? i.top : ch0 - i.bottom - h;
            } else {
                return;
            }
            GraphicsConfig cfg = new GraphicsConfig((Graphics)g).setAlpha(alpha);
            UIUtil.drawImage((Graphics)g, (Image)this.scaled, (int)x, (int)y, null);
            if (fillType == FillType.BG_CENTER) {
                g.setColor(component.getBackground());
                g.fillRect(0, 0, x, ch0);
                g.fillRect(x, 0, w, h);
                g.fillRect(x + w, 0, x, ch0);
                g.fillRect(x, y + h, w, y);
            }
            cfg.restore();
        }

        @NotNull
        private static VolatileImage createImage(Graphics2D g, int w, int h) {
            VolatileImage volatileImage;
            GraphicsConfiguration configuration = g.getDeviceConfiguration();
            try {
                volatileImage = configuration.createCompatibleVolatileImage(w, h, new ImageCapabilities(true), 3);
            }
            catch (Exception e) {
                VolatileImage volatileImage2 = configuration.createCompatibleVolatileImage(w, h, 3);
                if (volatileImage2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/PaintersHelper$ImagePainter", "createImage"));
                }
                return volatileImage2;
            }
            if (volatileImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/PaintersHelper$ImagePainter", "createImage"));
            }
            return volatileImage;
        }
    }

    public static enum FillType {
        BG_CENTER,
        TILE,
        SCALE,
        CENTER,
        TOP_CENTER,
        BOTTOM_CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

