/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BuildArtifactsBeforeRunTask
extends BeforeRunTask<BuildArtifactsBeforeRunTask> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String ARTIFACT_ELEMENT = "artifact";
    private List<ArtifactPointer> myArtifactPointers = new ArrayList<ArtifactPointer>();
    private final Project myProject;

    public BuildArtifactsBeforeRunTask(Project project) {
        super(BuildArtifactsBeforeRunTaskProvider.ID);
        this.myProject = project;
    }

    public void readExternal(Element element) {
        super.readExternal(element);
        List children = element.getChildren(ARTIFACT_ELEMENT);
        ArtifactPointerManager pointerManager = ArtifactPointerManager.getInstance((Project)this.myProject);
        for (Element child : children) {
            this.myArtifactPointers.add(pointerManager.createPointer(child.getAttributeValue(NAME_ATTRIBUTE)));
        }
    }

    public void writeExternal(Element element) {
        super.writeExternal(element);
        for (ArtifactPointer pointer : this.myArtifactPointers) {
            element.addContent(new Element(ARTIFACT_ELEMENT).setAttribute(NAME_ATTRIBUTE, pointer.getArtifactName()));
        }
    }

    public BeforeRunTask clone() {
        BuildArtifactsBeforeRunTask task = (BuildArtifactsBeforeRunTask)super.clone();
        task.myArtifactPointers = new ArrayList<ArtifactPointer>(this.myArtifactPointers);
        return task;
    }

    public int getItemsCount() {
        return this.myArtifactPointers.size();
    }

    public List<ArtifactPointer> getArtifactPointers() {
        return Collections.unmodifiableList(this.myArtifactPointers);
    }

    public void setArtifactPointers(List<ArtifactPointer> artifactPointers) {
        this.myArtifactPointers = new ArrayList<ArtifactPointer>(artifactPointers);
    }

    public void addArtifact(Artifact artifact) {
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact);
        if (!this.myArtifactPointers.contains(pointer)) {
            this.myArtifactPointers.add(pointer);
        }
    }

    public void removeArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ARTIFACT_ELEMENT, "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTask", "removeArtifact"));
        }
        this.removeArtifact(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact));
    }

    public void removeArtifact(@NotNull ArtifactPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTask", "removeArtifact"));
        }
        this.myArtifactPointers.remove(pointer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildArtifactsBeforeRunTask that = (BuildArtifactsBeforeRunTask)((Object)o);
        if (!this.myArtifactPointers.equals(that.myArtifactPointers)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myArtifactPointers.hashCode();
        result = 31 * result + this.myProject.hashCode();
        return result;
    }
}

