/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

class ContinuationIndentDetector {
    private Stack<Bracket> myOpenedBrackets;
    private final CharSequence myText;
    private final int myLength;
    private boolean myIncorrectBracketsOrder;
    private Character myOpeningStringLiteralDelimiter;

    public ContinuationIndentDetector(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/autodetect/ContinuationIndentDetector", "<init>"));
        }
        this.myOpenedBrackets = ContainerUtil.newStack();
        this.myIncorrectBracketsOrder = false;
        this.myOpeningStringLiteralDelimiter = null;
        this.myText = text;
        this.myLength = text.length();
    }

    public void feedLineStartingAt(int startOffset) {
        if (this.myIncorrectBracketsOrder) {
            return;
        }
        int lineEndOffset = CharArrayUtil.indexOf((CharSequence)this.myText, (CharSequence)"\n", (int)startOffset, (int)this.myLength);
        if (lineEndOffset < 0) {
            lineEndOffset = this.myLength;
        }
        for (int i = startOffset; i < lineEndOffset; ++i) {
            char currentChar = this.myText.charAt(i);
            if (this.isStringLiteralDelimiter(currentChar)) {
                this.processStringLiteralDelimiter(currentChar);
                continue;
            }
            Bracket bracket = Bracket.forChar(currentChar);
            if (bracket == null || this.myOpeningStringLiteralDelimiter != null) continue;
            this.processBracket(bracket);
        }
    }

    private void processStringLiteralDelimiter(char delimiter) {
        if (this.myOpeningStringLiteralDelimiter == null) {
            this.myOpeningStringLiteralDelimiter = Character.valueOf(delimiter);
        } else if (this.myOpeningStringLiteralDelimiter.charValue() == delimiter) {
            this.myOpeningStringLiteralDelimiter = null;
        }
    }

    private boolean isStringLiteralDelimiter(char currentChar) {
        return currentChar == '\'' || currentChar == '\"';
    }

    private void processBracket(@NotNull Bracket bracket) {
        if (bracket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bracket", "com/intellij/psi/codeStyle/autodetect/ContinuationIndentDetector", "processBracket"));
        }
        if (bracket.isOpening()) {
            this.myOpenedBrackets.add((Object)bracket);
        } else if (!this.myOpenedBrackets.isEmpty() && bracket.isClosing((Bracket)((Object)this.myOpenedBrackets.peek()))) {
            this.myOpenedBrackets.pop();
        } else {
            this.myIncorrectBracketsOrder = true;
        }
    }

    public boolean isContinuationIndent() {
        if (this.myIncorrectBracketsOrder || this.myOpenedBrackets.isEmpty()) {
            return false;
        }
        return this.myOpenedBrackets.peek() == Bracket.LPARENTH;
    }

    private static enum Bracket {
        LBRACE('{'){

            @Override
            boolean isOpening() {
                return true;
            }
        }
        ,
        LPARENTH('('){

            @Override
            boolean isOpening() {
                return true;
            }
        }
        ,
        RBRACE('}'){

            @Override
            public boolean isClosing(Bracket bracket) {
                return bracket == LBRACE;
            }
        }
        ,
        RPARENTH(')'){

            @Override
            public boolean isClosing(Bracket bracket) {
                return bracket == LPARENTH;
            }
        };

        private final char myChar;

        private Bracket(char c) {
            this.myChar = c;
        }

        public boolean isClosing(Bracket bracket) {
            return false;
        }

        boolean isOpening() {
            return false;
        }

        static Bracket forChar(char c) {
            for (Bracket bracket : Bracket.values()) {
                if (bracket.myChar != c) continue;
                return bracket;
            }
            return null;
        }
    }
}

