/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.AppTopics;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocumentManagerImpl
extends PsiDocumentManagerBase
implements SettingsSavingComponent {
    private final DocumentCommitThread myDocumentCommitThread;
    private final boolean myUnitTestMode;

    public PsiDocumentManagerImpl(final @NotNull Project project, @NotNull PsiManager psiManager, @NotNull EditorFactory editorFactory, @NotNull MessageBus bus, final @NonNls @NotNull DocumentCommitThread documentCommitThread) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (editorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorFactory", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (documentCommitThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCommitThread", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        super(project, psiManager, bus, documentCommitThread);
        this.myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myDocumentCommitThread = documentCommitThread;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)project);
        MessageBusConnection busConnection = bus.connect();
        busConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(final @NotNull VirtualFile virtualFile, @NotNull Document document) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerImpl$1", "fileContentLoaded"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl$1", "fileContentLoaded"));
                }
                PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        return PsiDocumentManagerImpl.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerImpl.this.getCachedPsiFile(virtualFile);
                    }
                });
                PsiDocumentManagerImpl.this.fireDocumentCreated(document, psiFile);
            }
        });
        busConnection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateFinished(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl$2", "updateFinished"));
                }
                documentCommitThread.queueCommit(project, doc, "Bulk update finished", ApplicationManager.getApplication().getCurrentModalityState());
            }
        });
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        Collection projects;
        VirtualFile virtualFile;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl", "getPsiFile"));
        }
        PsiFile psiFile = super.getPsiFile(document);
        if (this.myUnitTestMode && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isValid() && !(projects = ProjectLocator.getInstance().getProjectsForFile(virtualFile)).isEmpty() && !projects.contains(this.myProject)) {
            LOG.error("Trying to get PSI for an alien project. VirtualFile=" + virtualFile + ";\n myProject=" + this.myProject + ";\n projects returned: " + projects);
        }
        return psiFile;
    }

    @Override
    public void documentChanged(DocumentEvent event) {
        super.documentChanged(event);
        if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
            if (this.myUnitTestMode) {
                this.myStopTrackingDocuments = true;
                try {
                    LOG.error("Too many uncommitted documents for " + this.myProject + ":\n" + StringUtil.join((Iterable)this.myUncommittedDocuments, (String)"\n") + "\n\n Project creation trace: " + (String)this.myProject.getUserData(ProjectImpl.CREATION_TRACE));
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
            if (PomModelImpl.isAllowPsiModification()) {
                this.commitAllDocuments();
            }
        }
    }

    @Override
    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/PsiDocumentManagerImpl", "beforeDocumentChangeOnUnlockedDocument"));
        }
        PostprocessReformattingAspect.getInstance(this.myProject).beforeDocumentChanged(viewProvider);
        super.beforeDocumentChangeOnUnlockedDocument(viewProvider);
    }

    @Override
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl", "finishCommitInWriteAction"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerImpl", "finishCommitInWriteAction"));
        }
        EditorWindowImpl.disposeInvalidEditors();
        return super.finishCommitInWriteAction(document, finishProcessors, synchronously);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl", "isDocumentBlockedByPsi"));
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        return viewProvider != null && PostprocessReformattingAspect.getInstance(this.myProject).isViewProviderLocked(viewProvider);
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl", "doPostponedOperationsAndUnblockDocument"));
        }
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null) {
            component.doPostponedFormatting(viewProvider);
        }
    }

    public void save() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PsiDocumentManagerImpl.this.commitAllDocuments();
                }
                catch (Exception e) {
                    PsiDocumentManagerBase.LOG.error((Throwable)e);
                }
            }
        });
    }

    @Override
    public void clearUncommittedDocuments() {
        super.clearUncommittedDocuments();
        this.myDocumentCommitThread.clearQueue();
    }

    @NonNls
    public String toString() {
        return super.toString() + " for the project " + this.myProject + ".";
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/impl/PsiDocumentManagerImpl", "reparseFiles"));
        }
        FileContentUtil.reparseFiles((Project)this.myProject, files, (boolean)includeOpenFiles);
    }
}

