/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.lang.LanguageDependentMembersRefactoringSupport;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MemberDependenciesStorage<T extends NavigatablePsiElement, C extends PsiElement> {
    protected final C myClass;
    private C mySuperClass;
    private final Map<T, Set<T>> myDependencyGraph;

    public MemberDependenciesStorage(C aClass, C superClass) {
        this.myClass = aClass;
        this.mySuperClass = superClass;
        this.myDependencyGraph = new HashMap();
    }

    public void setSuperClass(C superClass) {
        this.mySuperClass = superClass;
    }

    @Nullable
    protected Set<T> getMemberDependencies(T member) {
        Set result = this.myDependencyGraph.get(member);
        if (result == null) {
            DependentMembersCollectorBase<T, C> collector = this.getCollector(member);
            if (collector != null) {
                collector.collect(member);
                result = collector.getCollection();
            }
            this.myDependencyGraph.put(member, result);
        }
        return result;
    }

    private DependentMembersCollectorBase<T, C> getCollector(T member) {
        ClassMembersRefactoringSupport factory = (ClassMembersRefactoringSupport)LanguageDependentMembersRefactoringSupport.INSTANCE.forLanguage(member.getLanguage());
        return factory != null ? factory.createDependentMembersCollector(this.myClass, this.mySuperClass) : null;
    }
}

