/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.daemon.impl.RecursiveCallLineMarkerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.invertBoolean.InvertBooleanUsageViewDescriptor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InvertBooleanProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.invertBoolean.InvertBooleanMethodProcessor");
    private PsiNamedElement myElement;
    private final String myNewName;
    private final RenameProcessor myRenameProcessor;
    private final Map<UsageInfo, SmartPsiElementPointer> myToInvert = new HashMap();
    private final SmartPointerManager mySmartPointerManager;

    public InvertBooleanProcessor(PsiNamedElement namedElement, String newName) {
        super(namedElement.getProject());
        this.myElement = namedElement;
        this.myNewName = newName;
        Project project = namedElement.getProject();
        this.myRenameProcessor = Comparing.equal((String)namedElement.getName(), (String)this.myNewName) ? null : new RenameProcessor(project, (PsiElement)namedElement, newName, false, false);
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)project);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "createUsageViewDescriptor"));
        }
        InvertBooleanUsageViewDescriptor invertBooleanUsageViewDescriptor = new InvertBooleanUsageViewDescriptor(this.myElement);
        if (invertBooleanUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "createUsageViewDescriptor"));
        }
        return invertBooleanUsageViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        for (UsageInfo info : this.myToInvert.keySet()) {
            PsiElement element = info.getElement();
            if (!(element instanceof PsiMethodReferenceExpression)) continue;
            conflicts.putValue((Object)element, (Object)"Method is used in method reference expression");
        }
        if (!conflicts.isEmpty()) {
            return this.showConflicts((MultiMap<PsiElement, String>)conflicts, null);
        }
        if (this.myRenameProcessor == null || this.myRenameProcessor.preprocessUsages(refUsages)) {
            this.prepareSuccessful();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        final ArrayList<SmartPsiElementPointer> toInvert = new ArrayList<SmartPsiElementPointer>();
        this.addRefsToInvert(toInvert, this.myElement);
        if (this.myElement instanceof PsiMethod) {
            Collection overriders = OverridingMethodsSearch.search((PsiMethod)((PsiMethod)this.myElement)).findAll();
            if (this.myRenameProcessor != null) {
                for (Object overrider : overriders) {
                    this.myRenameProcessor.addElement((PsiElement)overrider, this.myNewName);
                }
            }
            HashSet allMethods = new HashSet(overriders);
            allMethods.add((PsiMethod)this.myElement);
            for (PsiMethod method : allMethods) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReturnStatement(PsiReturnStatement statement) {
                        PsiExpression returnValue = statement.getReturnValue();
                        if (returnValue != null && PsiType.BOOLEAN.equals((Object)returnValue.getType())) {
                            toInvert.add(InvertBooleanProcessor.this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)returnValue));
                        }
                    }

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitLambdaExpression(PsiLambdaExpression expression) {
                    }
                });
            }
        } else if (this.myElement instanceof PsiParameter && ((PsiParameter)this.myElement).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)((PsiParameter)this.myElement).getDeclarationScope();
            int index = method.getParameterList().getParameterIndex((PsiParameter)this.myElement);
            LOG.assertTrue(index >= 0);
            Query methodQuery = MethodReferencesSearch.search((PsiMethod)method);
            Collection methodRefs = methodQuery.findAll();
            for (PsiReference ref : methodRefs) {
                PsiExpression[] args;
                PsiReferenceExpression methodExpression;
                PsiElement parent = ref.getElement().getParent();
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiCall)) continue;
                PsiCall call = (PsiCall)parent;
                PsiReferenceExpression psiReferenceExpression = methodExpression = call instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)call).getMethodExpression() : null;
                PsiExpressionList argumentList = call.getArgumentList();
                if (argumentList == null || index >= (args = argumentList.getExpressions()).length || methodExpression != null && !InvertBooleanProcessor.canInvert(methodExpression, args[index] instanceof PsiReferenceExpression && ((PsiReferenceExpression)args[index]).resolve() == this.myElement)) continue;
                toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)args[index]));
            }
            Collection overriders = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overrider : overriders) {
                PsiParameter overriderParameter = overrider.getParameterList().getParameters()[index];
                if (this.myRenameProcessor != null) {
                    this.myRenameProcessor.addElement((PsiElement)overriderParameter, this.myNewName);
                }
                this.addRefsToInvert(toInvert, (PsiNamedElement)overriderParameter);
            }
        }
        UsageInfo[] renameUsages = this.myRenameProcessor != null ? this.myRenameProcessor.findUsages() : UsageInfo.EMPTY_ARRAY;
        SmartPsiElementPointer[] usagesToInvert = toInvert.toArray(new SmartPsiElementPointer[toInvert.size()]);
        HashMap expressionsToUsages = new HashMap();
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo renameUsage : renameUsages) {
            expressionsToUsages.put(renameUsage.getElement(), renameUsage);
            result.add(renameUsage);
        }
        for (SmartPsiElementPointer pointer : usagesToInvert) {
            PsiExpression expression = (PsiExpression)pointer.getElement();
            if (!expressionsToUsages.containsKey(expression)) {
                UsageInfo usageInfo = new UsageInfo((PsiElement)expression);
                expressionsToUsages.put(expression, usageInfo);
                result.add(usageInfo);
                this.myToInvert.put(usageInfo, pointer);
                continue;
            }
            this.myToInvert.put((UsageInfo)expressionsToUsages.get(expression), pointer);
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private static boolean canInvert(PsiReferenceExpression methodExpression, boolean checkRecursive) {
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression == null || !"super".equals(qualifierExpression.getText())) {
            PsiElement parent = methodExpression.getParent();
            if (parent instanceof PsiMethodCallExpression) {
                return !checkRecursive || !RecursiveCallLineMarkerProvider.isRecursiveMethodCall((PsiMethodCallExpression)parent);
            }
            return true;
        }
        return false;
    }

    private void addRefsToInvert(List<SmartPsiElementPointer> toInvert, PsiNamedElement namedElement) {
        PsiExpression initializer;
        Query query = namedElement instanceof PsiMethod ? MethodReferencesSearch.search((PsiMethod)((PsiMethod)namedElement)) : ReferencesSearch.search((PsiElement)namedElement);
        Collection refs = query.findAll();
        for (PsiReference ref : refs) {
            PsiElement gParent;
            PsiElement element = ref.getElement();
            if (!(element instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)element;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof PsiAssignmentExpression && refExpr.equals(((PsiAssignmentExpression)parent).getLExpression())) {
                toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)((PsiAssignmentExpression)parent).getRExpression()));
                continue;
            }
            if (namedElement instanceof PsiParameter && (gParent = refExpr.getParent().getParent()) instanceof PsiMethodCallExpression && !InvertBooleanProcessor.canInvert(((PsiMethodCallExpression)gParent).getMethodExpression(), true)) continue;
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)refExpr));
        }
        if (namedElement instanceof PsiVariable && (initializer = ((PsiVariable)namedElement).getInitializer()) != null) {
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)initializer));
        }
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof PsiMethod);
        this.myElement = (PsiMethod)elements[0];
    }

    private static UsageInfo[] extractUsagesForElement(PsiElement element, UsageInfo[] usages) {
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            MoveRenameUsageInfo usageInfo;
            if (!(usage instanceof MoveRenameUsageInfo) || !element.equals((usageInfo = (MoveRenameUsageInfo)usage).getReferencedElement())) continue;
            extractedUsages.add(usageInfo);
        }
        return extractedUsages.toArray(new UsageInfo[extractedUsages.size()]);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "performRefactoring"));
        }
        if (this.myRenameProcessor != null) {
            for (PsiElement element : this.myRenameProcessor.getElements()) {
                try {
                    RenameUtil.doRename(element, this.myRenameProcessor.getNewName(element), InvertBooleanProcessor.extractUsagesForElement(element, usages), this.myProject, null);
                }
                catch (IncorrectOperationException e) {
                    RenameUtil.showErrorMessage(e, element, this.myProject);
                    return;
                }
            }
        }
        for (UsageInfo usage : usages) {
            SmartPsiElementPointer pointerToInvert = this.myToInvert.get(usage);
            if (pointerToInvert == null) continue;
            PsiExpression expression = (PsiExpression)pointerToInvert.getElement();
            LOG.assertTrue(expression != null);
            if (expression.getParent() instanceof PsiMethodCallExpression) {
                expression = (PsiExpression)expression.getParent();
            }
            try {
                while (expression.getParent() instanceof PsiPrefixExpression && ((PsiPrefixExpression)expression.getParent()).getOperationTokenType() == JavaTokenType.EXCL) {
                    expression = (PsiExpression)expression.getParent();
                }
                if (expression.getParent() instanceof PsiExpressionStatement) continue;
                expression.replace((PsiElement)CodeInsightServicesUtil.invertCondition((PsiExpression)expression));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myElement instanceof PsiField && ((PsiField)this.myElement).getInitializer() == null) {
            ((PsiField)this.myElement).setInitializer(JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText("true", (PsiElement)this.myElement));
        }
    }

    @Override
    protected String getCommandName() {
        return InvertBooleanHandler.REFACTORING_NAME;
    }
}

