/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerClassUsagesHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerOptions;
import com.intellij.refactoring.move.moveInner.MoveInnerViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInnerProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInner.MoveInnerProcessor");
    private MoveCallback myMoveCallback;
    private PsiClass myInnerClass;
    private PsiClass myOuterClass;
    private PsiElement myTargetContainer;
    private String myParameterNameOuterClass;
    private String myFieldNameOuterClass;
    private String myDescriptiveName = "";
    private String myNewClassName;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private boolean myOpenInEditor;

    public MoveInnerProcessor(Project project, MoveCallback moveCallback) {
        super(project);
        this.myMoveCallback = moveCallback;
    }

    public MoveInnerProcessor(Project project, PsiClass innerClass, String name, boolean passOuterClass, String parameterName, PsiElement targetContainer) {
        super(project);
        this.setup(innerClass, name, passOuterClass, parameterName, true, true, targetContainer);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.inner.class.command", (Object[])new Object[]{this.myDescriptiveName});
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "createUsageViewDescriptor"));
        }
        MoveInnerViewDescriptor moveInnerViewDescriptor = new MoveInnerViewDescriptor(this.myInnerClass);
        if (moveInnerViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "createUsageViewDescriptor"));
        }
        return moveInnerViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        String newQName;
        LOG.assertTrue(this.myTargetContainer != null);
        Collection innerClassRefs = ReferencesSearch.search((PsiElement)this.myInnerClass).findAll();
        ArrayList<UsageInfo> usageInfos = new ArrayList<UsageInfo>(innerClassRefs.size());
        for (PsiReference innerClassRef : innerClassRefs) {
            PsiElement ref = innerClassRef.getElement();
            if (PsiTreeUtil.isAncestor((PsiElement)this.myInnerClass, (PsiElement)ref, (boolean)true)) continue;
            usageInfos.add(new UsageInfo(ref));
        }
        if (this.myTargetContainer instanceof PsiDirectory) {
            PsiDirectory targetDirectory = (PsiDirectory)this.myTargetContainer;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
            LOG.assertTrue(aPackage != null);
            newQName = aPackage.getQualifiedName() + "." + this.myNewClassName;
        } else {
            String qName;
            newQName = this.myTargetContainer instanceof PsiClass ? ((qName = ((PsiClass)this.myTargetContainer).getQualifiedName()) != null ? qName + "." + this.myNewClassName : this.myNewClassName) : this.myNewClassName;
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(this.mySearchInComments, this.mySearchInNonJavaFiles, (PsiElement)this.myInnerClass, newQName, usageInfos);
        UsageInfo[] usageInfoArray = usageInfos.toArray(new UsageInfo[usageInfos.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "refreshElements"));
        }
        boolean condition = elements.length == 1 && elements[0] instanceof PsiClass;
        LOG.assertTrue(condition);
        this.myInnerClass = (PsiClass)elements[0];
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "performRefactoring"));
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)this.myInnerClass);
        try {
            PsiClass newClass;
            PsiField field = null;
            if (this.myParameterNameOuterClass != null) {
                field = factory.createField(this.myFieldNameOuterClass, (PsiType)factory.createType(this.myOuterClass));
                field = this.addOuterField(field);
                this.myInnerClass = field.getContainingClass();
                this.addFieldInitializationToConstructors(this.myInnerClass, field, this.myParameterNameOuterClass);
            }
            ChangeContextUtil.encodeContextInfo((PsiElement)this.myInnerClass, false);
            this.myInnerClass = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(this.myInnerClass);
            MoveInnerOptions moveInnerOptions = new MoveInnerOptions(this.myInnerClass, this.myOuterClass, this.myTargetContainer, this.myNewClassName);
            MoveInnerHandler handler = (MoveInnerHandler)MoveInnerHandler.EP_NAME.forLanguage(this.myInnerClass.getLanguage());
            try {
                newClass = handler.copyClass(moveInnerOptions);
            }
            catch (IncorrectOperationException e) {
                RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
                return;
            }
            for (Object ref : ReferencesSearch.search((PsiElement)this.myInnerClass, (SearchScope)new LocalSearchScope((PsiElement)newClass), (boolean)true)) {
                PsiReferenceList referenceList;
                PsiJavaCodeReferenceElement parentRef;
                PsiElement parentRefElement;
                PsiElement element = ref.getElement();
                if (element.getParent() instanceof PsiJavaCodeReferenceElement && (parentRefElement = (parentRef = (PsiJavaCodeReferenceElement)element.getParent()).resolve()) instanceof PsiClass && ((referenceList = (PsiReferenceList)PsiTreeUtil.getTopmostParentOfType((PsiElement)parentRef, PsiReferenceList.class)) == null || referenceList.getParent() != newClass)) {
                    parentRef.getQualifier().delete();
                    continue;
                }
                ref.bindToElement((PsiElement)newClass);
            }
            ArrayList<PsiReference> referencesToRebind = new ArrayList<PsiReference>();
            for (Object usage : usages) {
                PsiReference[] references;
                if (usage.isNonCodeUsage) continue;
                PsiElement refElement = usage.getElement();
                for (PsiReference reference : references = refElement.getReferences()) {
                    if (!reference.isReferenceTo((PsiElement)this.myInnerClass)) continue;
                    referencesToRebind.add(reference);
                }
            }
            this.myInnerClass.delete();
            for (Object usage : usages) {
                MoveInnerClassUsagesHandler usagesHandler;
                if (usage.isNonCodeUsage || this.myParameterNameOuterClass == null || (usagesHandler = (MoveInnerClassUsagesHandler)MoveInnerClassUsagesHandler.EP_NAME.forLanguage(usage.getElement().getLanguage())) == null) continue;
                usagesHandler.correctInnerClassUsage((UsageInfo)usage, this.myOuterClass);
            }
            for (PsiReference reference : referencesToRebind) {
                reference.bindToElement((PsiElement)newClass);
            }
            block9: for (Object usage : usages) {
                PsiElement parent;
                PsiElement element = usage.getElement();
                PsiElement psiElement = parent = element != null ? element.getParent() : null;
                if (!(parent instanceof PsiNewExpression)) continue;
                PsiMethod resolveConstructor = ((PsiNewExpression)parent).resolveConstructor();
                for (PsiMethod method : newClass.getConstructors()) {
                    if (resolveConstructor != method) continue;
                    PsiElement place = usage.getElement();
                    if (place == null) continue block9;
                    VisibilityUtil.escalateVisibility((PsiMember)method, (PsiElement)place);
                    continue block9;
                }
            }
            if (field != null) {
                PsiExpression paramAccessExpression = factory.createExpressionFromText(this.myParameterNameOuterClass, null);
                for (PsiMethod constructor : newClass.getConstructors()) {
                    String text;
                    PsiExpression expression;
                    PsiStatement[] statements = constructor.getBody().getStatements();
                    if (statements.length <= 0 || !(statements[0] instanceof PsiExpressionStatement) || !((expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression) || !"this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText()) && !"super".equals(text)) continue;
                    ChangeContextUtil.decodeContextInfo((PsiElement)expression, this.myOuterClass, paramAccessExpression);
                }
                PsiExpression accessExpression = factory.createExpressionFromText(this.myFieldNameOuterClass, null);
                ChangeContextUtil.decodeContextInfo((PsiElement)newClass, this.myOuterClass, accessExpression);
            } else {
                ChangeContextUtil.decodeContextInfo((PsiElement)newClass, null, null);
            }
            if (this.myOpenInEditor) {
                EditorHelper.openInEditor((PsiElement)newClass);
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
            elementListener.elementMoved((PsiElement)newClass);
            ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
            for (UsageInfo usage : usages) {
                if (!(usage instanceof NonCodeUsageInfo)) continue;
                nonCodeUsages.add((NonCodeUsageInfo)usage);
            }
            this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiField addOuterField(PsiField field) {
        PsiMember[] members = (PsiMember[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myInnerClass, PsiMember.class);
        if (members != null) {
            for (PsiMember member : members) {
                if (member.hasModifierProperty("static")) continue;
                return (PsiField)this.myInnerClass.addBefore((PsiElement)field, (PsiElement)member);
            }
        }
        return (PsiField)this.myInnerClass.add((PsiElement)field);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "preprocessUsages"));
        }
        final MultiMap conflicts = new MultiMap();
        final HashMap reported = new HashMap();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiMember && PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myInnerClass, (PsiElement)resolved, (boolean)true) && MoveInnerProcessor.this.becomesInaccessible((PsiMember)resolved)) {
                    MoveInnerProcessor.registerConflict(reference, resolved, (HashMap<PsiElement, HashSet<PsiElement>>)reported, (MultiMap<PsiElement, String>)conflicts);
                }
            }

            public void visitClass(PsiClass aClass) {
                if (aClass == MoveInnerProcessor.this.myInnerClass) {
                    return;
                }
                super.visitClass(aClass);
            }
        }
        this.myOuterClass.accept((PsiElementVisitor)new Visitor());
        this.myInnerClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiMember && PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myOuterClass, (PsiElement)resolve, (boolean)true) && !PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myInnerClass, (PsiElement)resolve, (boolean)false) && MoveInnerProcessor.this.becomesInaccessible((PsiMember)resolve)) {
                    MoveInnerProcessor.registerConflict(reference, resolve, (HashMap<PsiElement, HashSet<PsiElement>>)reported, (MultiMap<PsiElement, String>)conflicts);
                }
            }
        });
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    private static void registerConflict(PsiJavaCodeReferenceElement reference, PsiElement resolved, HashMap<PsiElement, HashSet<PsiElement>> reported, MultiMap<PsiElement, String> conflicts) {
        PsiElement container = ConflictsUtil.getContainer((PsiElement)reference);
        HashSet<PsiElement> containerSet = (HashSet<PsiElement>)reported.get((Object)container);
        if (containerSet == null) {
            containerSet = new HashSet<PsiElement>();
            reported.put((Object)container, containerSet);
        }
        if (!containerSet.contains(resolved)) {
            containerSet.add(resolved);
            String placesDescription = containerSet.size() == 1 ? RefactoringUIUtil.getDescription(resolved, true) : "<ol><li>" + StringUtil.join(containerSet, (Function)new Function<PsiElement, String>(){

                public String fun(PsiElement element) {
                    return RefactoringUIUtil.getDescription(element, true);
                }
            }, (String)"</li><li>") + "</li></ol>";
            String message = RefactoringBundle.message((String)"0.will.become.inaccessible.from.1", (Object[])new Object[]{placesDescription, RefactoringUIUtil.getDescription(container, true)});
            conflicts.put((Object)container, Collections.singletonList(message));
        }
    }

    private boolean becomesInaccessible(PsiMember element) {
        PsiDirectory containingDirectory;
        String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)element.getModifierList());
        if ("private".equals(visibilityModifier)) {
            return true;
        }
        if ("public".equals(visibilityModifier)) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        if (this.myTargetContainer instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myTargetContainer);
            assert (aPackage != null) : this.myTargetContainer;
            return !psiFacade.isInPackage((PsiElement)this.myOuterClass, aPackage);
        }
        PsiFile targetFile = this.myTargetContainer.getContainingFile();
        if (targetFile != null && (containingDirectory = targetFile.getContainingDirectory()) != null) {
            PsiPackage targetPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
            assert (targetPackage != null) : this.myTargetContainer;
            return psiFacade.isInPackage((PsiElement)this.myOuterClass, targetPackage);
        }
        return false;
    }

    public void setup(PsiClass innerClass, String className, boolean passOuterClass, String parameterName, boolean searchInComments, boolean searchInNonJava, @NotNull PsiElement targetContainer) {
        if (targetContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetContainer", "com/intellij/refactoring/move/moveInner/MoveInnerProcessor", "setup"));
        }
        this.myNewClassName = className;
        this.myInnerClass = innerClass;
        this.myDescriptiveName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myInnerClass);
        this.myOuterClass = this.myInnerClass.getContainingClass();
        this.myTargetContainer = targetContainer;
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        String string = this.myParameterNameOuterClass = passOuterClass ? parameterName : null;
        if (this.myParameterNameOuterClass != null) {
            this.myFieldNameOuterClass = codeStyleManager.variableNameToPropertyName(this.myParameterNameOuterClass, VariableKind.PARAMETER);
            this.myFieldNameOuterClass = codeStyleManager.propertyNameToVariableName(this.myFieldNameOuterClass, VariableKind.FIELD);
        }
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJava;
    }

    private void addFieldInitializationToConstructors(PsiClass aClass, PsiField field, String parameterName) throws IncorrectOperationException {
        PsiMethod[] constructors = aClass.getConstructors();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                String text;
                PsiExpression expression;
                PsiStatement first;
                PsiStatement[] statements;
                PsiCodeBlock body;
                if (parameterName != null) {
                    PsiParameterList parameterList = constructor.getParameterList();
                    PsiParameter parameter = factory.createParameter(parameterName, field.getType());
                    parameterList.addAfter((PsiElement)parameter, null);
                }
                if ((body = constructor.getBody()) == null || (statements = body.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText())) continue;
                this.createAssignmentStatement(constructor, field.getName(), parameterName);
            }
        } else {
            PsiMethod constructor = factory.createConstructor();
            if (parameterName != null) {
                PsiParameterList parameterList = constructor.getParameterList();
                PsiParameter parameter = factory.createParameter(parameterName, field.getType());
                parameterList.add((PsiElement)parameter);
            }
            this.createAssignmentStatement(constructor, field.getName(), parameterName);
            aClass.add((PsiElement)constructor);
        }
    }

    private PsiStatement createAssignmentStatement(PsiMethod constructor, String fieldName, String parameterName) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        String pattern = fieldName + "=a;";
        if (fieldName.equals(parameterName)) {
            pattern = "this." + pattern;
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
        statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
        PsiCodeBlock body = constructor.getBody();
        assert (body != null) : constructor;
        statement = (PsiExpressionStatement)body.addAfter((PsiElement)statement, MoveInnerProcessor.getAnchorElement(body));
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
        PsiReferenceExpression rExpr = (PsiReferenceExpression)assignment.getRExpression();
        assert (rExpr != null) : assignment;
        PsiIdentifier identifier = (PsiIdentifier)rExpr.getReferenceNameElement();
        assert (identifier != null) : assignment;
        identifier.replace((PsiElement)factory.createIdentifier(parameterName));
        return statement;
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock body) {
        PsiReferenceExpression methodCall;
        String text;
        PsiExpression expression;
        PsiStatement first;
        PsiStatement[] statements = body.getStatements();
        if (statements.length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "super".equals(text = (methodCall = ((PsiMethodCallExpression)expression).getMethodExpression()).getText())) {
            return first;
        }
        return null;
    }

    public PsiClass getInnerClass() {
        return this.myInnerClass;
    }

    public String getNewClassName() {
        return this.myNewClassName;
    }

    public boolean shouldPassParameter() {
        return this.myParameterNameOuterClass != null;
    }

    public String getParameterName() {
        return this.myParameterNameOuterClass;
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }
}

