/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.turnRefsToSuper.RefsToSuperViewDescriptor;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperHandler;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessorBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TurnRefsToSuperProcessor
extends TurnRefsToSuperProcessorBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessor");
    private PsiClass mySuper;

    public TurnRefsToSuperProcessor(Project project, @NotNull PsiClass aClass, @NotNull PsiClass aSuper, boolean replaceInstanceOf) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "<init>"));
        }
        if (aSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aSuper", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "<init>"));
        }
        super(project, replaceInstanceOf, aSuper.getName());
        this.myClass = aClass;
        this.mySuper = aSuper;
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"turn.refs.to.super.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass), DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySuper)});
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "createUsageViewDescriptor"));
        }
        RefsToSuperViewDescriptor refsToSuperViewDescriptor = new RefsToSuperViewDescriptor(this.myClass, this.mySuper);
        if (refsToSuperViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "createUsageViewDescriptor"));
        }
        return refsToSuperViewDescriptor;
    }

    private void setClasses(@NotNull PsiClass aClass, @NotNull PsiClass aSuper) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "setClasses"));
        }
        if (aSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aSuper", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "setClasses"));
        }
        this.myClass = aClass;
        this.mySuper = aSuper;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])new PsiReference[0]);
        ArrayList<UsageInfo> result = this.detectTurnToSuperRefs(refs, new ArrayList<UsageInfo>());
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == 2 && elements[0] instanceof PsiClass && elements[1] instanceof PsiClass);
        this.setClasses((PsiClass)elements[0], (PsiClass)elements[1]);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "preprocessUsages"));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ((UsageInfo[])refUsages.get()).length == 0) {
            String message = RefactoringBundle.message((String)"no.usages.can.be.replaced", (Object[])new Object[]{this.myClass.getQualifiedName(), this.mySuper.getQualifiedName()});
            Messages.showInfoMessage((Project)this.myProject, (String)message, (String)TurnRefsToSuperHandler.REFACTORING_NAME);
            return false;
        }
        return super.preprocessUsages(refUsages);
    }

    @Override
    protected boolean canTurnToSuper(PsiElement refElement) {
        return super.canTurnToSuper(refElement) && JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)this.mySuper, refElement, null);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "performRefactoring"));
        }
        try {
            PsiClass aSuper = this.mySuper;
            TurnRefsToSuperProcessor.processTurnToSuperRefs(usages, aSuper);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.performVariablesRenaming();
    }

    @Override
    protected boolean isInSuper(PsiElement member) {
        if (!(member instanceof PsiMember)) {
            return false;
        }
        PsiManager manager = member.getManager();
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)this.mySuper, (PsiClass)((PsiMember)member).getContainingClass(), (boolean)true)) {
            return true;
        }
        if (member instanceof PsiField) {
            PsiClass containingClass = ((PsiField)member).getContainingClass();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)member);
            if (manager.areElementsEquivalent((PsiElement)containingClass, (PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().getArrayClass(languageLevel))) {
                return true;
            }
        } else if (member instanceof PsiMethod) {
            return this.mySuper.findMethodBySignature((PsiMethod)member, true) != null;
        }
        return false;
    }

    @Override
    protected boolean isSuperInheritor(PsiClass aClass) {
        return InheritanceUtil.isInheritorOrSelf((PsiClass)this.mySuper, (PsiClass)aClass, (boolean)true);
    }

    public PsiClass getSuper() {
        return this.mySuper;
    }

    public PsiClass getTarget() {
        return this.myClass;
    }

    public boolean isReplaceInstanceOf() {
        return this.myReplaceInstanceOf;
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "getElementsToWrite"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor", "getElementsToWrite"));
        }
        return list;
    }
}

