/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.module.CloudApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudApplicationConfiguration;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudSourceApplicationConfigurable<SC extends CloudConfigurationBase, DC extends CloudDeploymentNameConfiguration, SR extends CloudMultiSourceServerRuntimeInstance<DC, ?, ?, ?>, AC extends CloudApplicationConfiguration>
extends CloudApplicationConfigurable {
    private final Project myProject;
    private final Disposable myParentDisposable;
    private DelayedRunner myRunner;
    private RemoteServer<?> myAccount;

    public CloudSourceApplicationConfigurable(@Nullable Project project, Disposable parentDisposable) {
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
    }

    @Override
    public void setAccount(RemoteServer<?> account) {
        this.myAccount = account;
        this.clearCloudData();
    }

    protected RemoteServer<SC> getAccount() {
        return this.myAccount;
    }

    @Override
    public JComponent getComponent() {
        JComponent result = this.getMainPanel();
        if (this.myRunner == null) {
            this.myRunner = new DelayedRunner(result){
                private RemoteServer<?> myPreviousAccount;

                @Override
                protected boolean wasChanged() {
                    boolean result;
                    boolean bl = result = this.myPreviousAccount != CloudSourceApplicationConfigurable.this.myAccount;
                    if (result) {
                        this.myPreviousAccount = CloudSourceApplicationConfigurable.this.myAccount;
                    }
                    return result;
                }

                @Override
                protected void run() {
                    CloudSourceApplicationConfigurable.this.loadCloudData();
                }
            };
            Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myRunner);
        }
        return result;
    }

    protected void clearCloudData() {
        this.getExistingComboBox().removeAllItems();
    }

    protected void loadCloudData() {
        new ConnectionTask<Collection<Deployment>>("Loading existing applications list"){

            @Override
            protected void run(final ServerConnection<DC> connection, final Semaphore semaphore, final AtomicReference<Collection<Deployment>> result) {
                connection.connectIfNeeded(new ServerConnector.ConnectionCallback<DC>(){

                    public void connected(@NotNull ServerRuntimeInstance<DC> serverRuntimeInstance) {
                        if (serverRuntimeInstance == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/remoteServer/impl/module/CloudSourceApplicationConfigurable$2$1", "connected"));
                        }
                        connection.computeDeployments(new Runnable(){

                            @Override
                            public void run() {
                                result.set(connection.getDeployments());
                                semaphore.up();
                                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!Disposer.isDisposed((Disposable)CloudSourceApplicationConfigurable.this.myParentDisposable)) {
                                            CloudSourceApplicationConfigurable.this.setupExistingApplications((Collection)result.get());
                                        }
                                    }
                                });
                            }
                        });
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/module/CloudSourceApplicationConfigurable$2$1", "errorOccurred"));
                        }
                        this.runtimeErrorOccurred(errorMessage);
                        semaphore.up();
                    }
                });
            }

            @Override
            protected Collection<Deployment> run(SR serverRuntimeInstance) throws ServerRuntimeException {
                return null;
            }
        }.performAsync();
    }

    private void setupExistingApplications(Collection<Deployment> deployments) {
        JComboBox existingComboBox = this.getExistingComboBox();
        existingComboBox.removeAllItems();
        for (Deployment deployment : deployments) {
            existingComboBox.addItem(deployment.getName());
        }
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected abstract JComboBox getExistingComboBox();

    protected abstract JComponent getMainPanel();

    public abstract AC createConfiguration();

    protected abstract class ConnectionTask<T>
    extends CloudConnectionTask<T, SC, DC, SR> {
        public ConnectionTask(String title) {
            super(CloudSourceApplicationConfigurable.this.myProject, title, CloudSourceApplicationConfigurable.this.getAccount());
        }
    }
}

