/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudRuntimeTask;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConnectionTask<T, SC extends ServerConfigurationBase, DC extends DeploymentConfiguration, SR extends CloudServerRuntimeInstance<DC, ?, ?>>
extends CloudRuntimeTask<T, DC, SR> {
    private final RemoteServer<SC> myServer;

    public CloudConnectionTask(Project project, String title, @Nullable RemoteServer<SC> server) {
        super(project, title);
        this.myServer = server;
    }

    @Override
    protected void run(Semaphore semaphore, AtomicReference<T> result) {
        if (this.myServer == null) {
            semaphore.up();
            return;
        }
        ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(this.myServer);
        this.run(connection, semaphore, result);
    }

    @Override
    protected void run(final ServerConnection<DC> connection, final Semaphore semaphore, final AtomicReference<T> result) {
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback<DC>(){

            public void connected(@NotNull ServerRuntimeInstance<DC> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/remoteServer/util/CloudConnectionTask$1", "connected"));
                }
                try {
                    CloudConnectionTask.this.run((CloudServerRuntimeInstance)serverRuntimeInstance, semaphore, result);
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            connection.disconnect();
                        }
                    });
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/util/CloudConnectionTask$1", "errorOccurred"));
                }
                CloudConnectionTask.this.runtimeErrorOccurred(errorMessage);
                semaphore.up();
            }
        });
    }

    @Override
    protected SR getServerRuntime() {
        throw new UnsupportedOperationException();
    }

    public final RemoteServer<SC> getServer() {
        return this.myServer;
    }
}

