/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.FileStructureTestFixture;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightFixtureTestCase;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.junit.Before;

public abstract class FileStructureTestBase
extends CodeInsightFixtureTestCase {
    protected FileStructureTestFixture myPopupFixture;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.myFixture.configureByFile(this.getFileName(this.getFileExtension()));
        this.myPopupFixture = new FileStructureTestFixture(this.myFixture.getProject(), this.myFixture.getEditor(), this.getFile());
        this.myPopupFixture.update();
    }

    protected abstract String getFileExtension();

    @Override
    public void tearDown() throws Exception {
        if (this.myPopupFixture != null) {
            this.myPopupFixture.dispose();
        }
        super.tearDown();
    }

    private String getFileName(String ext) {
        return this.getTestName(false) + (StringUtil.isEmpty((String)ext) ? "" : "." + ext);
    }

    protected String getTreeFileName() {
        return this.getFileName("tree");
    }

    protected void checkTree(String filter) {
        this.myPopupFixture.getPopup().setSearchFilterForTests(filter);
        this.myPopupFixture.getBuilder().refilter(null, false, true);
        this.myPopupFixture.getBuilder().queueUpdate();
        TreeUtil.selectPath((JTree)this.myPopupFixture.getTree(), (TreePath)((TreePath)this.myPopupFixture.getSpeedSearch().findElement(filter)));
        this.checkTree();
    }

    protected void checkTree() {
        FileStructureTestBase.assertSameLinesWithFile(this.getTestDataPath() + "/" + this.getTreeFileName(), PlatformTestUtil.print((JTree)this.myPopupFixture.getTree(), true).trim());
    }
}

