/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import org.jetbrains.annotations.Nullable;

public class TestRunLineMarkerProvider
extends RunLineMarkerContributor {
    private static final Function<PsiElement, String> TOOLTIP_PROVIDER = new Function<PsiElement, String>(){

        public String fun(PsiElement element) {
            return "Run Test";
        }
    };

    @Override
    @Nullable
    public RunLineMarkerContributor.Info getInfo(PsiElement e) {
        if (e instanceof PsiIdentifier) {
            TestFramework framework;
            PsiElement element = e.getParent();
            if (element instanceof PsiClass && (framework = TestFrameworks.detectFramework((PsiClass)((PsiClass)element))) != null && framework.isTestClass(element)) {
                return new RunLineMarkerContributor.Info(framework.getIcon(), TOOLTIP_PROVIDER, ExecutorAction.ACTIONS);
            }
            if (element instanceof PsiMethod) {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                TestFramework framework2 = TestFrameworks.detectFramework((PsiClass)psiClass);
                if (psiClass != null && framework2 != null && framework2.isTestMethod(element)) {
                    return new RunLineMarkerContributor.Info(framework2.getIcon(), TOOLTIP_PROVIDER, ExecutorAction.ACTIONS);
                }
            }
        }
        return null;
    }
}

