/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.LanguageTextField;
import org.jetbrains.annotations.NotNull;

public class EditorTextFieldProviderImpl
implements EditorTextFieldProvider {
    @Override
    @NotNull
    public EditorTextField getEditorField(@NotNull Language language, @NotNull Project project, @NotNull Iterable<EditorCustomization> features) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ui/EditorTextFieldProviderImpl", "getEditorField"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorTextFieldProviderImpl", "getEditorField"));
        }
        if (features == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "features", "com/intellij/ui/EditorTextFieldProviderImpl", "getEditorField"));
        }
        MyEditorTextField myEditorTextField = new MyEditorTextField(language, project, features);
        if (myEditorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldProviderImpl", "getEditorField"));
        }
        return myEditorTextField;
    }

    private static class MyEditorTextField
    extends LanguageTextField {
        @NotNull
        private final Iterable<EditorCustomization> myCustomizations;

        MyEditorTextField(@NotNull Language language, @NotNull Project project, @NotNull Iterable<EditorCustomization> customizations) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ui/EditorTextFieldProviderImpl$MyEditorTextField", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorTextFieldProviderImpl$MyEditorTextField", "<init>"));
            }
            if (customizations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customizations", "com/intellij/ui/EditorTextFieldProviderImpl$MyEditorTextField", "<init>"));
            }
            super(language, project, "", false);
            this.myCustomizations = customizations;
        }

        @Override
        protected EditorEx createEditor() {
            EditorEx ex = super.createEditor();
            ex.getScrollPane().setVerticalScrollBarPolicy(20);
            ex.setHorizontalScrollbarVisible(true);
            MyEditorTextField.applyDefaultSettings(ex);
            this.applyCustomizations(ex);
            return ex;
        }

        private static void applyDefaultSettings(EditorEx ex) {
            EditorSettings settings = ex.getSettings();
            settings.setAdditionalColumnsCount(3);
            settings.setVirtualSpace(false);
        }

        private void applyCustomizations(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorTextFieldProviderImpl$MyEditorTextField", "applyCustomizations"));
            }
            for (EditorCustomization customization : this.myCustomizations) {
                customization.customize(editor);
            }
        }

        @Override
        protected boolean isOneLineMode() {
            return false;
        }
    }
}

