/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.StartupProgress;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nullable;

public class Splash
extends JDialog
implements StartupProgress {
    @Nullable
    public static Rectangle BOUNDS;
    private final Icon myImage;
    private int myProgressHeight = JBUI.scale((int)2);
    private Color myProgressColor = null;
    private int myProgressY;
    private float myProgress;
    private boolean mySplashIsVisible;
    private int myProgressLastPosition = 0;
    private final JLabel myLabel;
    private Icon myProgressTail;

    public Splash(String imageName, Color textColor) {
        super((Frame)null, false);
        this.setUndecorated(true);
        if (!SystemInfo.isLinux || !SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            this.setResizable(false);
        }
        this.setFocusableWindowState(false);
        Icon originalImage = IconLoader.getIcon((String)imageName);
        this.myImage = new SplashImage(originalImage, textColor);
        this.myLabel = new JLabel(this.myImage){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Splash.this.mySplashIsVisible = true;
                Splash.this.myProgressLastPosition = 0;
                Splash.this.paintProgress(g);
            }
        };
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.myLabel, "Center");
        Dimension size = this.getPreferredSize();
        this.setSize(size);
        this.pack();
        this.setLocationInTheCenterOfScreen();
    }

    private void setLocationInTheCenterOfScreen() {
        Rectangle bounds = this.getGraphicsConfiguration().getBounds();
        if (SystemInfo.isWindows) {
            JBInsets.removeFrom((Rectangle)bounds, (Insets)ScreenUtil.getScreenInsets((GraphicsConfiguration)this.getGraphicsConfiguration()));
        }
        this.setLocation(UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)this.getSize()));
    }

    public Splash(ApplicationInfoEx info) {
        this(info.getSplashImageUrl(), info.getSplashTextColor());
        if (info instanceof ApplicationInfoImpl) {
            ApplicationInfoImpl appInfo = (ApplicationInfoImpl)info;
            this.myProgressHeight = 2 * Math.round(JBUI.scale((float)0.99f));
            this.myProgressColor = appInfo.getProgressColor();
            this.myProgressY = appInfo.getProgressY();
            this.myProgressTail = appInfo.getProgressTailIcon();
        }
    }

    @Override
    public void show() {
        super.show();
        this.toFront();
        BOUNDS = this.getBounds();
    }

    public void showProgress(String message, float progress) {
        if (this.getProgressColor() == null) {
            return;
        }
        this.myProgress = progress;
        this.myLabel.paintImmediately(0, 0, this.myImage.getIconWidth(), this.myImage.getIconHeight());
    }

    private void paintProgress(Graphics g) {
        Color color = this.getProgressColor();
        if (color == null) {
            return;
        }
        if (!this.mySplashIsVisible) {
            this.myImage.paintIcon(this, g, 0, 0);
            this.mySplashIsVisible = true;
        }
        int progressWidth = (int)((float)(this.myImage.getIconWidth() - 2) * this.myProgress);
        int width = progressWidth - this.myProgressLastPosition;
        g.setColor(color);
        g.fillRect(1, this.getProgressY(), width, this.getProgressHeight());
        if (this.myProgressTail != null) {
            this.myProgressTail.paintIcon(this, g, (int)((float)width - (float)this.myProgressTail.getIconWidth() / JBUI.scale((float)1.0f) / 2.0f * JBUI.scale((float)1.0f)), (int)((float)this.getProgressY() - (float)(this.myProgressTail.getIconHeight() - this.getProgressHeight()) / JBUI.scale((float)1.0f) / 2.0f * JBUI.scale((float)1.0f)));
        }
        this.myProgressLastPosition = progressWidth;
    }

    private int getProgressHeight() {
        return this.myProgressHeight;
    }

    private Color getProgressColor() {
        return this.myProgressColor;
    }

    private int getProgressY() {
        return (int)JBUI.scale((float)this.myProgressY);
    }

    public static boolean showLicenseeInfo(Graphics g, int x, int y, int height, Color textColor) {
        if (ApplicationInfoImpl.getShadowInstance().showLicenseeInfo()) {
            LicensingFacade provider = LicensingFacade.getInstance();
            if (provider != null) {
                UIUtil.applyRenderingHints((Graphics)g);
                g.setFont(new Font("Arial", 1, JBUI.scale((int)(SystemInfo.isUnix ? 10 : 11))));
                g.setColor(textColor);
                String licensedToMessage = provider.getLicensedToMessage();
                List<String> licenseRestrictionsMessages = provider.getLicenseRestrictionsMessages();
                g.drawString(licensedToMessage, x + JBUI.scale((int)15), y + height - JBUI.scale((int)30));
                if (licenseRestrictionsMessages.size() > 0) {
                    g.drawString(licenseRestrictionsMessages.get(0), x + JBUI.scale((int)15), y + height - JBUI.scale((int)14));
                }
            }
            return true;
        }
        return false;
    }

    private static final class SplashImage
    implements Icon {
        private final Icon myIcon;
        private final Color myTextColor;
        private boolean myRedrawing;

        public SplashImage(Icon originalIcon, Color textColor) {
            this.myIcon = originalIcon;
            this.myTextColor = textColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!this.myRedrawing) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.myRedrawing = true;
            }
            this.myIcon.paintIcon(c, g, x, y);
            Splash.showLicenseeInfo(g, x, y, this.getIconHeight(), this.myTextColor);
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

