/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.SimplePrintElement;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PrintElementManagerImpl;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleGraphImpl<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    private final LinearGraphController myGraphController;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraph;
    private PrintElementManagerImpl myPrintElementManager;
    private PrintElementGenerator myPrintElementGenerator;
    private boolean myShowLongEdges;

    public VisibleGraphImpl(@NotNull LinearGraphController graphController, @NotNull PermanentGraphInfo<CommitId> permanentGraph) {
        if (graphController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphController", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "<init>"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "<init>"));
        }
        this.myShowLongEdges = false;
        this.myGraphController = graphController;
        this.myPermanentGraph = permanentGraph;
        this.updatePrintElementGenerator();
    }

    public int getVisibleCommitCount() {
        return this.myGraphController.getCompiledGraph().nodesCount();
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(final int visibleRow) {
        final int nodeId = this.myGraphController.getCompiledGraph().getNodeId(visibleRow);
        assert (nodeId >= 0);
        RowInfo rowInfo = new RowInfo<CommitId>(){

            @NotNull
            public CommitId getCommit() {
                Object CommitId = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(nodeId);
                if (CommitId == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$1", "getCommit"));
                }
                return CommitId;
            }

            @NotNull
            public CommitId getOneOfHeads() {
                int headNodeId = VisibleGraphImpl.this.myPermanentGraph.getPermanentGraphLayout().getOneOfHeadNodeIndex(nodeId);
                Object CommitId = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(headNodeId);
                if (CommitId == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$1", "getOneOfHeads"));
                }
                return CommitId;
            }

            @NotNull
            public Collection<? extends PrintElement> getPrintElements() {
                Collection<PrintElementWithGraphElement> collection = VisibleGraphImpl.this.myPrintElementGenerator.getPrintElements(visibleRow);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$1", "getPrintElements"));
                }
                return collection;
            }

            @NotNull
            public RowType getRowType() {
                GraphNodeType nodeType = VisibleGraphImpl.this.myGraphController.getCompiledGraph().getGraphNode(visibleRow).getType();
                switch (nodeType) {
                    case USUAL: {
                        RowType rowType = RowType.NORMAL;
                        if (rowType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$1", "getRowType"));
                        }
                        return rowType;
                    }
                    case UNMATCHED: {
                        RowType rowType = RowType.UNMATCHED;
                        if (rowType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$1", "getRowType"));
                        }
                        return rowType;
                    }
                }
                throw new UnsupportedOperationException("Unsupported node type: " + (Object)((Object)nodeType));
            }
        };
        if (rowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getRowInfo"));
        }
        return rowInfo;
    }

    @Nullable
    public Integer getVisibleRowIndex(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getVisibleRowIndex"));
        }
        int nodeId = this.myPermanentGraph.getPermanentCommitsInfo().getNodeId(commitId);
        return this.myGraphController.getCompiledGraph().getNodeIndex(nodeId);
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        ActionControllerImpl actionControllerImpl = new ActionControllerImpl();
        if (actionControllerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getActionController"));
        }
        return actionControllerImpl;
    }

    private void updatePrintElementGenerator() {
        this.myPrintElementManager = new PrintElementManagerImpl(this.myGraphController.getCompiledGraph(), this.myPermanentGraph);
        this.myPrintElementGenerator = new PrintElementGeneratorImpl(this.myGraphController.getCompiledGraph(), this.myPrintElementManager, this.myShowLongEdges);
    }

    public static class LinearGraphActionImpl
    implements LinearGraphController.LinearGraphAction {
        @Nullable
        private final PrintElementWithGraphElement myAffectedElement;
        @NotNull
        private final GraphAction.Type myType;

        public LinearGraphActionImpl(@Nullable PrintElementWithGraphElement affectedElement, @NotNull GraphAction.Type type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl", "<init>"));
            }
            this.myAffectedElement = affectedElement;
            this.myType = type;
        }

        @Override
        @Nullable
        public PrintElementWithGraphElement getAffectedElement() {
            return this.myAffectedElement;
        }

        @NotNull
        public GraphAction.Type getType() {
            GraphAction.Type type = this.myType;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl", "getType"));
            }
            return type;
        }
    }

    private static class GraphAnswerImpl<CommitId>
    implements GraphAnswer<CommitId> {
        @Nullable
        private final Cursor myCursor;
        @Nullable
        private final CommitId myCommitToJump;
        @Nullable
        private final Runnable myUpdater;

        private GraphAnswerImpl(@Nullable Cursor cursor, @Nullable CommitId commitToJump, @Nullable Runnable updater) {
            this.myCursor = cursor;
            this.myCommitToJump = commitToJump;
            this.myUpdater = updater;
        }

        @Nullable
        public Cursor getCursorToSet() {
            return this.myCursor;
        }

        @Nullable
        public CommitId getCommitToJump() {
            return this.myCommitToJump;
        }

        @Nullable
        public Runnable getGraphUpdater() {
            return this.myUpdater;
        }
    }

    private class ActionControllerImpl
    implements ActionController<CommitId> {
        private ActionControllerImpl() {
        }

        @Nullable
        private Integer convertToNodeId(@Nullable Integer nodeIndex) {
            if (nodeIndex == null) {
                return null;
            }
            return VisibleGraphImpl.this.myGraphController.getCompiledGraph().getNodeId(nodeIndex);
        }

        @Nullable
        private GraphAnswer<CommitId> performArrowAction(@NotNull LinearGraphController.LinearGraphAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performArrowAction"));
            }
            PrintElementWithGraphElement affectedElement = action.getAffectedElement();
            if (!(affectedElement instanceof SimplePrintElement)) {
                return null;
            }
            SimplePrintElement.Type printElementType = ((SimplePrintElement)affectedElement).getType();
            if (printElementType != SimplePrintElement.Type.DOWN_ARROW && printElementType != SimplePrintElement.Type.UP_ARROW) {
                return null;
            }
            GraphElement graphElement = affectedElement.getGraphElement();
            if (!(graphElement instanceof GraphEdge)) {
                return null;
            }
            GraphEdge edge = (GraphEdge)graphElement;
            Integer targetId = null;
            if (edge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                assert (printElementType == SimplePrintElement.Type.DOWN_ARROW);
                targetId = edge.getTargetId();
            }
            if (edge.getType().isNormalEdge()) {
                targetId = printElementType == SimplePrintElement.Type.DOWN_ARROW ? this.convertToNodeId(edge.getDownNodeIndex()) : this.convertToNodeId(edge.getUpNodeIndex());
            }
            if (targetId == null) {
                return null;
            }
            if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                VisibleGraphImpl.this.myPrintElementManager.setSelectedElement(affectedElement);
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(true), null, null);
            }
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(false), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null);
            }
            return null;
        }

        @NotNull
        public GraphAnswer<CommitId> performAction(@NotNull GraphAction graphAction) {
            if (graphAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphAction", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performAction"));
            }
            VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(Collections.<Integer>emptySet());
            LinearGraphController.LinearGraphAction action = this.convert(graphAction);
            GraphAnswer graphAnswer = this.performArrowAction(action);
            if (graphAnswer != null) {
                GraphAnswer graphAnswer2 = graphAnswer;
                if (graphAnswer2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performAction"));
                }
                return graphAnswer2;
            }
            LinearGraphController.LinearGraphAnswer answer = VisibleGraphImpl.this.myGraphController.performLinearGraphAction(action);
            if (answer.getSelectedNodeIds() != null) {
                VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(answer.getSelectedNodeIds());
            }
            if (answer.getGraphChanges() != null) {
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }
            GraphAnswer graphAnswer3 = this.convert(answer);
            if (graphAnswer3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performAction"));
            }
            return graphAnswer3;
        }

        public boolean areLongEdgesHidden() {
            return !VisibleGraphImpl.this.myShowLongEdges;
        }

        public void setLongEdgesHidden(boolean longEdgesHidden) {
            VisibleGraphImpl.this.myShowLongEdges = !longEdgesHidden;
            VisibleGraphImpl.this.updatePrintElementGenerator();
        }

        private LinearGraphController.LinearGraphAction convert(@NotNull GraphAction graphAction) {
            if (graphAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphAction", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "convert"));
            }
            PrintElementWithGraphElement printElement = null;
            if (graphAction.getAffectedElement() != null) {
                printElement = VisibleGraphImpl.this.myPrintElementGenerator.toPrintElementWithGraphElement(graphAction.getAffectedElement());
            }
            return new LinearGraphActionImpl(printElement, graphAction.getType());
        }

        private GraphAnswer<CommitId> convert(@NotNull LinearGraphController.LinearGraphAnswer answer) {
            if (answer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "convert"));
            }
            Object commitToJump = null;
            Integer nodeId = answer.getCommitToJump();
            if (nodeId != null) {
                commitToJump = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(nodeId);
            }
            final Runnable graphUpdater = answer.getGraphUpdater();
            return new GraphAnswerImpl(answer.getCursorToSet(), commitToJump, graphUpdater == null ? null : new Runnable(){

                @Override
                public void run() {
                    graphUpdater.run();
                    VisibleGraphImpl.this.updatePrintElementGenerator();
                }
            });
        }
    }
}

