/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogBranchFilter> {
    private VcsLogClassicFilterUi.BranchFilterModel myBranchFilterModel;

    public BranchFilterPopupComponent(@NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.BranchFilterModel filterModel) {
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        super("Branch", uiProperties, filterModel);
        this.myBranchFilterModel = filterModel;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogBranchFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getText"));
        }
        boolean positiveMatch = !filter.getBranchNames().isEmpty();
        List<String> names = positiveMatch ? filter.getBranchNames() : BranchFilterPopupComponent.addMinusPrefix(filter.getExcludedBranchNames());
        String string = BranchFilterPopupComponent.displayableText(names);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogBranchFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getToolTip"));
        }
        boolean positiveMatch = !filter.getBranchNames().isEmpty();
        Collection names = positiveMatch ? filter.getBranchNames() : filter.getExcludedBranchNames();
        String tooltip = BranchFilterPopupComponent.tooltip(names);
        return positiveMatch ? tooltip : "not in " + tooltip;
    }

    @Override
    @NotNull
    protected VcsLogBranchFilter createFilter(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "createFilter"));
        }
        ArrayList acceptedBranches = ContainerUtil.newArrayList();
        ArrayList excludedBranches = ContainerUtil.newArrayList();
        for (String value : values) {
            if (value.startsWith("-")) {
                excludedBranches.add(value.substring(1));
                continue;
            }
            acceptedBranches.add(value);
        }
        VcsLogBranchFilterImpl vcsLogBranchFilterImpl = new VcsLogBranchFilterImpl(acceptedBranches, excludedBranches);
        if (vcsLogBranchFilterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "createFilter"));
        }
        return vcsLogBranchFilterImpl;
    }

    @Override
    @NotNull
    protected Collection<String> getTextValues(@Nullable VcsLogBranchFilter filter) {
        if (filter == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getTextValues"));
            }
            return set;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{filter.getBranchNames(), BranchFilterPopupComponent.addMinusPrefix(filter.getExcludedBranchNames())}));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getTextValues"));
        }
        return arrayList;
    }

    @NotNull
    private static List<String> addMinusPrefix(@NotNull Collection<String> branchNames) {
        if (branchNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNames", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "addMinusPrefix"));
        }
        List list = ContainerUtil.map(branchNames, (Function)new Function<String, String>(){

            public String fun(String branchName) {
                return "-" + branchName;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "addMinusPrefix"));
        }
        return list;
    }

    @Override
    protected boolean supportsNegativeValues() {
        return true;
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        actionGroup.add((AnAction)BranchFilterPopupComponent.constructActionGroup(this.myFilterModel.getDataPack(), this.createRecentItemsActionGroup(), new Function<String, AnAction>(){

            public AnAction fun(String name) {
                return BranchFilterPopupComponent.this.createPredefinedValueAction(Collections.singleton(name));
            }
        }, this.myBranchFilterModel.getVisibleRoots()));
        return actionGroup;
    }

    public static ActionGroup constructActionGroup(@NotNull VcsLogDataPack dataPack, @Nullable ActionGroup recentItemsGroup, @NotNull Function<String, AnAction> actionGetter, @Nullable Collection<VirtualFile> visibleRoots) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "constructActionGroup"));
        }
        if (actionGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGetter", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "constructActionGroup"));
        }
        Groups groups = BranchFilterPopupComponent.prepareGroups(dataPack, visibleRoots);
        return BranchFilterPopupComponent.getFilteredActionGroup(groups, recentItemsGroup, actionGetter);
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "prepareGroups"));
        }
        Groups filteredGroups = new Groups();
        Collection allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            Collection refs = (Collection)entry.getValue();
            VcsLogProvider provider = (VcsLogProvider)dataPack.getLogProviders().get(root);
            VcsLogRefManager refManager = provider.getReferenceManager();
            List refGroups = refManager.group(refs);
            BranchFilterPopupComponent.orderRefGroups(refGroups, filteredGroups);
        }
        return filteredGroups;
    }

    private static DefaultActionGroup getFilteredActionGroup(@NotNull Groups groups, @Nullable ActionGroup recentItems, @NotNull Function<String, AnAction> actionGetter) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getFilteredActionGroup"));
        }
        if (actionGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGetter", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getFilteredActionGroup"));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (String string : groups.singletonGroups) {
            actionGroup.add((AnAction)actionGetter.fun((Object)string));
        }
        if (recentItems != null) {
            actionGroup.add((AnAction)recentItems);
        }
        for (Map.Entry entry : groups.expandedGroups.entrySet()) {
            actionGroup.addSeparator((String)entry.getKey());
            for (String action : (TreeSet)entry.getValue()) {
                actionGroup.add((AnAction)actionGetter.fun((Object)action));
            }
        }
        actionGroup.addSeparator();
        for (Map.Entry entry : groups.collapsedGroups.entrySet()) {
            DefaultActionGroup popupGroup = new DefaultActionGroup((String)entry.getKey(), true);
            for (String action : (TreeSet)entry.getValue()) {
                popupGroup.add((AnAction)actionGetter.fun((Object)action));
            }
            actionGroup.add((AnAction)popupGroup);
        }
        return actionGroup;
    }

    private static void orderRefGroups(List<RefGroup> groups, Groups filteredGroups) {
        for (RefGroup group : groups) {
            if (group.getRefs().size() == 1) {
                String name = ((VcsRef)group.getRefs().iterator().next()).getName();
                if (filteredGroups.singletonGroups.contains(name)) continue;
                filteredGroups.singletonGroups.add(name);
                continue;
            }
            if (group.isExpanded()) {
                BranchFilterPopupComponent.addToGroup(group, filteredGroups.expandedGroups);
                continue;
            }
            BranchFilterPopupComponent.addToGroup(group, filteredGroups.collapsedGroups);
        }
    }

    private static void addToGroup(RefGroup group, TreeMap<String, TreeSet<String>> groupToAdd) {
        TreeSet<String> existingGroup = groupToAdd.get(group.getName());
        TreeSet<String> actions2 = new TreeSet<String>();
        for (VcsRef ref : group.getRefs()) {
            actions2.add(ref.getName());
        }
        if (existingGroup == null) {
            groupToAdd.put(group.getName(), actions2);
        } else {
            for (String action : actions2) {
                existingGroup.add(action);
            }
        }
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredBranchGroups();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "rememberValuesInSettings"));
        }
        this.myUiProperties.addRecentlyFilteredBranchGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.map((Collection)this.myFilterModel.getDataPack().getRefs().getBranches(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getAllValues"));
        }
        return list;
    }

    private static class Groups {
        private final TreeSet<String> singletonGroups = ContainerUtil.newTreeSet();
        private final TreeMap<String, TreeSet<String>> expandedGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, TreeSet<String>> collapsedGroups = ContainerUtil.newTreeMap();

        private Groups() {
        }
    }
}

