/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ClassAccessVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final Map<PsiClass, Integer> m_accessCounts = new HashMap<PsiClass, Integer>(2);
    private final Set<PsiClass> m_overAccessedClasses = new HashSet<PsiClass>(2);
    private final PsiClass currentClass;

    ClassAccessVisitor(PsiClass currentClass) {
        this.currentClass = currentClass;
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/ClassAccessVisitor", "visitMethodCallExpression"));
        }
        super.visitMethodCallExpression(expression);
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null) {
            return;
        }
        if (this.currentClass.equals(calledClass)) {
            return;
        }
        Set<PsiClass> overAccessedClasses = this.m_overAccessedClasses;
        if (overAccessedClasses.contains(calledClass)) {
            return;
        }
        if (LibraryUtil.classIsInLibrary(calledClass)) {
            return;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this.currentClass, (PsiElement)calledClass, (boolean)true)) {
            return;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)calledClass, (PsiElement)this.currentClass, (boolean)true)) {
            return;
        }
        PsiClass lexicallyEnclosingClass = this.currentClass;
        while (lexicallyEnclosingClass != null) {
            if (lexicallyEnclosingClass.isInheritor(calledClass, true)) {
                return;
            }
            lexicallyEnclosingClass = ClassUtils.getContainingClass((PsiElement)lexicallyEnclosingClass);
        }
        Map<PsiClass, Integer> accessCounts = this.m_accessCounts;
        Integer count = accessCounts.get(calledClass);
        if (count == null) {
            accessCounts.put(calledClass, 1);
        } else if (count.equals(1)) {
            accessCounts.put(calledClass, 2);
        } else {
            overAccessedClasses.add(calledClass);
        }
    }

    Set<PsiClass> getOveraccessedClasses() {
        return Collections.unmodifiableSet(this.m_overAccessedClasses);
    }
}

