/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreMethodCalls = false;
    private static final int LIMIT_DEPTH = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("duplicate.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DuplicateConditionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DuplicateConditionInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (InspectionProfileEntry)this, "ignoreMethodCalls");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private DuplicateConditionVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/DuplicateConditionInspection$DuplicateConditionVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement);
            if (ControlFlowUtils.isElseIf(statement)) {
                return;
            }
            HashSet<PsiExpression> conditions = new HashSet<PsiExpression>();
            this.collectConditionsForIfStatement(statement, conditions, 0);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            PsiExpression[] conditionArray = conditions.toArray(new PsiExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                PsiExpression condition = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    PsiExpression testCondition;
                    boolean areEquivalent;
                    if (matched[j] || !(areEquivalent = EquivalenceChecker.expressionsAreEquivalent(condition, testCondition = conditionArray[j]))) continue;
                    if (!DuplicateConditionInspection.this.ignoreMethodCalls || !this.containsMethodCallExpression((PsiElement)testCondition)) {
                        this.registerError((PsiElement)testCondition, new Object[0]);
                        if (!matched[i]) {
                            this.registerError((PsiElement)condition, new Object[0]);
                        }
                    }
                    matched[i] = true;
                    matched[j] = true;
                }
            }
        }

        private void collectConditionsForIfStatement(PsiIfStatement statement, Set<PsiExpression> conditions, int depth) {
            if (depth > 20) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            this.collectConditionsForExpression(condition, conditions);
            PsiStatement branch = statement.getElseBranch();
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatement((PsiIfStatement)branch, conditions, depth + 1);
            }
        }

        private void collectConditionsForExpression(PsiExpression condition, Set<PsiExpression> conditions) {
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if (condition == null) {
                return;
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                PsiExpression contents = parenthesizedExpression.getExpression();
                this.collectConditionsForExpression(contents, conditions);
                return;
            }
            if (condition instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)condition).getOperationTokenType())) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    this.collectConditionsForExpression(operand, conditions);
                }
                return;
            }
            conditions.add(condition);
        }

        private boolean containsMethodCallExpression(PsiElement element) {
            PsiElement[] children;
            if (element instanceof PsiMethodCallExpression) {
                return true;
            }
            for (PsiElement child : children = element.getChildren()) {
                if (!this.containsMethodCallExpression(child)) continue;
                return true;
            }
            return false;
        }
    }
}

