/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TryWithIdenticalCatchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.problem.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryWithIdenticalCatchesVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseCatchSectionsFix((Integer)infos[1], (Integer)infos[2]);
    }

    private static class CollapseCatchSectionsFix
    extends InspectionGadgetsFix {
        private final int myCollapseIntoIndex;
        private final int mySectionIndex;

        public CollapseCatchSectionsFix(int collapseIntoIndex, int sectionIndex) {
            this.myCollapseIntoIndex = collapseIntoIndex;
            this.mySectionIndex = sectionIndex;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("try.with.identical.catches.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CollapseCatchSectionsFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CollapseCatchSectionsFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiType type2;
            PsiTryStatement tryStatement = (PsiTryStatement)descriptor.getPsiElement().getParent();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            if (this.myCollapseIntoIndex >= catchSections.length || this.mySectionIndex >= catchSections.length) {
                return;
            }
            PsiCatchSection collapseInto = catchSections[this.myCollapseIntoIndex];
            PsiCatchSection section = catchSections[this.mySectionIndex];
            PsiParameter parameter1 = collapseInto.getParameter();
            PsiParameter parameter2 = section.getParameter();
            if (parameter1 == null || parameter2 == null) {
                return;
            }
            PsiType type1 = parameter1.getType();
            if (TypeConversionUtil.isAssignable((PsiType)type1, (PsiType)(type2 = parameter2.getType()))) {
                section.delete();
                return;
            }
            if (TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)type1)) {
                collapseInto.delete();
                return;
            }
            ArrayList<PsiType> types = new ArrayList<PsiType>();
            CollapseCatchSectionsFix.collectDisjunctTypes(type1, types);
            CollapseCatchSectionsFix.collectDisjunctTypes(type2, types);
            StringBuilder typeText = new StringBuilder();
            for (PsiType type : types) {
                if (typeText.length() > 0) {
                    typeText.append(" | ");
                }
                typeText.append(type.getCanonicalText());
            }
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElementFromText(typeText.toString(), (PsiElement)tryStatement);
            PsiTypeElement typeElement = parameter1.getTypeElement();
            if (typeElement == null) {
                return;
            }
            typeElement.replace((PsiElement)newTypeElement);
            section.delete();
        }

        private static void collectDisjunctTypes(PsiType type, List<PsiType> out) {
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                List disjunctions = disjunctionType.getDisjunctions();
                for (PsiType disjunction : disjunctions) {
                    CollapseCatchSectionsFix.collectDisjunctTypes(disjunction, out);
                }
                return;
            }
            int size = out.size();
            for (int i = 0; i < size; ++i) {
                PsiType collectedType = out.get(i);
                if (TypeConversionUtil.isAssignable((PsiType)type, (PsiType)collectedType)) {
                    out.remove(i);
                    out.add(type);
                    return;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)collectedType, (PsiType)type)) continue;
                return;
            }
            out.add(type);
        }
    }

    private static class TryWithIdenticalCatchesVisitor
    extends BaseInspectionVisitor {
        private TryWithIdenticalCatchesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement statement) {
            super.visitTryStatement(statement);
            PsiCatchSection[] catchSections = statement.getCatchSections();
            if (catchSections.length < 2) {
                return;
            }
            PsiParameter[] parameters = statement.getCatchBlockParameters();
            if (catchSections.length != parameters.length) {
                return;
            }
            boolean[] duplicates = new boolean[catchSections.length];
            for (int i = 0; i < catchSections.length - 1; ++i) {
                PsiParameter parameter;
                PsiCatchSection catchSection = catchSections[i];
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (catchBlock == null || (parameter = catchSection.getParameter()) == null) continue;
                InputVariables inputVariables = new InputVariables(Collections.singletonList(parameter), statement.getProject(), new LocalSearchScope((PsiElement)catchBlock), false);
                DuplicatesFinder finder = new DuplicatesFinder(new PsiElement[]{catchBlock}, inputVariables, null, Collections.emptyList());
                for (int j = i + 1; j < catchSections.length; ++j) {
                    List<PsiElement> parameterValues;
                    Match match;
                    PsiCatchSection otherSection;
                    PsiCodeBlock otherCatchBlock;
                    if (duplicates[j] || (otherCatchBlock = (otherSection = catchSections[j]).getCatchBlock()) == null || (match = finder.isDuplicate((PsiElement)otherCatchBlock, true)) == null || match.getReturnValue() != null || (parameterValues = match.getParameterValues((PsiVariable)parameter)) != null && (parameterValues.size() != 1 || !(parameterValues.get(0) instanceof PsiReferenceExpression)) || (j <= i ? !TryWithIdenticalCatchesVisitor.canCollapse(parameters, j, i) : !TryWithIdenticalCatchesVisitor.canCollapse(parameters, i, j))) continue;
                    PsiJavaToken rParenth = otherSection.getRParenth();
                    if (rParenth != null) {
                        this.registerErrorAtOffset((PsiElement)otherSection, 0, rParenth.getStartOffsetInParent() + 1, parameter.getType(), i, j);
                    }
                    duplicates[i] = true;
                    duplicates[j] = true;
                }
            }
        }

        private static boolean canCollapse(PsiParameter[] parameters, int index1, int index2) {
            if (index2 <= index1) {
                throw new IllegalArgumentException();
            }
            PsiType type = parameters[index2].getType();
            for (int i = index1 + 1; i < index2; ++i) {
                PsiType otherType = parameters[i].getType();
                if (!TypeConversionUtil.isAssignable((PsiType)type, (PsiType)otherType)) continue;
                return false;
            }
            return true;
        }
    }
}

