/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineSearcher;
import org.intellij.plugins.relaxNG.model.annotation.OverridingDefineRenderer;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverriddenDefineRenderer
extends GutterIconRenderer
implements DumbAware {
    private final Define myDefine;

    public OverriddenDefineRenderer(@NotNull Define define) {
        if (define == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "define", "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer", "<init>"));
        }
        this.myDefine = define;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.OverridenMethod;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Object element = OverriddenDefineRenderer.this.myDefine.getPsiElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
                XmlFile localFile = (XmlFile)element.getContainingFile();
                RelaxIncludeIndex.processBackwardDependencies(localFile, (PsiElementProcessor<XmlFile>)collector);
                Collection files = collector.getCollection();
                SmartList result = new SmartList();
                OverriddenDefineSearcher searcher = new OverriddenDefineSearcher(OverriddenDefineRenderer.this.myDefine, localFile, (List<Define>)result);
                for (XmlFile file : files) {
                    Grammar grammar = GrammarFactory.getGrammar(file);
                    if (grammar == null) continue;
                    grammar.acceptChildren(searcher);
                }
                if (result.size() > 0) {
                    OverridingDefineRenderer.doClickAction(e, (Collection<Define>)result, "Go to overriding define(s)");
                }
            }
        };
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public String getTooltipText() {
        return "Is overridden";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OverriddenDefineRenderer that = (OverriddenDefineRenderer)((Object)o);
        return this.myDefine.equals(that.myDefine);
    }

    public int hashCode() {
        return this.myDefine.hashCode();
    }
}

