/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"n\u001e)\u0001B)\u001a2vOB\u0013xnY3tg&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015!!WMY;hO\u0016\u0014(\"A\"\u000b\u0019Yk7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0015\r|gN\\3di&|gNC\u0007Y\t\u0016\u0014Wo\u001a)s_\u000e,7o\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0013a$WMY;hO\u0016\u0014(B\u0002\u001fj]&$hHC\u0004tKN\u001c\u0018n\u001c8\u000b\u001ba#UMY;h'\u0016\u001c8/[8o\u0015=)G-\u001b;peN\u0004&o\u001c<jI\u0016\u0014(\u0002\u0007-EK\n,xmZ3s\u000b\u0012LGo\u001c:t!J|g/\u001b3fe*QQM^1mk\u0006$\u0018n\u001c8\u000b)Ml\u0017M\u001d;Ti\u0016\u0004\u0018J\u001c;p\u0011\u0006tG\r\\3s\u0015UA6+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT\u0001b\u001d;faBLgn\u001a\u0006\u0010Kb,7-\u001e;j_:\u0014Vm];mi*yQ\t_3dkRLwN\u001c*fgVdGOC\u0005fq\u0016\u001cW\u000f^5p]*\u0019rL\u0019:fC.\u0004x.\u001b8u\u0011\u0006tG\r\\3sg*)\u0011I\u001d:bs*11n\u001c;mS:T!\u0003\u0017\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7fe*Y!M]3bWB|\u0017N\u001c;t\u0015qy&M]3bWB|\u0017N\u001c;IC:$G.\u001a:tI\u0011,G.Z4bi\u0016T!\u0002\u001d:pa\u0016\u0014H/[3t\u0015A\u0011V-\u00193P]2L\bK]8qKJ$\u0018P\u0003\fhKR|&M]3bWB|\u0017N\u001c;IC:$G.\u001a:t\u001559W\r^\"p]:,7\r^5p]*iB-[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7OC\u0004C_>dW-\u00198\u000bA\u001d,G\u000fR5tC\ndW\rR8O_R\u001cF/\u001a9J]R|G*\u001b2sCJLWm\u001d\u0006!g\u0016$H)[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7O\u0003\nhKR,\u00050Z2vi&|gNU3tk2$(bC5t\r>\u00148-Z*uKBTabZ3u\u0013N4uN]2f'R,\u0007O\u0003\btKRL5OR8sG\u0016\u001cF/\u001a9\u000b\u001b1\f7\u000f^\"bY24%/Y7f\u0015%\u0019\u0015\r\u001c7Ge\u0006lWM\u0003\thKRd\u0015m\u001d;DC2dgI]1nK*\u00012/\u001a;MCN$8)\u00197m\rJ\fW.\u001a\u0006\tY\u0006\u001cHo\u0015;fa*Q1\u000b^3q\u0003\u000e$\u0018n\u001c8\u000b\u0017\u001d,G\u000fT1tiN#X\r\u001d\u0006\fg\u0016$H*Y:u'R,\u0007O\u0003\u0013qe>\u001cWm]:Ce\u0016\f7\u000e]8j]R\u001cuN\u001c3ji&|gn]!u\u0013\u0012,7+\u001b3f\u00159\u0011X\r]3biN#X\r]%oi>TQ\"\u0011;p[&\u001c'i\\8mK\u0006t'\u0002\u00026bm\u0006TA!\u001e;jY*Q1m\u001c8dkJ\u0014XM\u001c;\u000b\r\u0005$x.\\5d\u0015E9W\r\u001e*fa\u0016\fGo\u0015;fa&sGo\u001c\u0006\u000fkJdGk\u001c$jY\u0016\u001c\u0015m\u00195f\u00155\u0019uN\\2veJ,g\u000e^'ba*\u0019QK\u001d7\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\b_B,g.\u00199j\u0015\r1hm\u001d\u0006\u0012O\u0016$XK\u001d7U_\u001aKG.Z\"bG\",'\"\u00052sK\u0006\\\u0007o\\5oiJ+\u0017m\u00195fI*Q!M]3bWB|\u0017N\u001c;\u000b\u0017a\u0013%/Z1la>Lg\u000e\u001e\u0006\u0017KZ\fG.^1uK\u0012dunZ#yaJ,7o]5p]*11\u000b\u001e:j]\u001eTab];ta\u0016tGmQ8oi\u0016DHOC\bY'V\u001c\b/\u001a8e\u0007>tG/\u001a=u\u0015\u00151'/Y7f\u0015\u0011)f.\u001b;\u000b\t1\fgn\u001a\u0006\u0018G\",7m[\"b]B+'OZ8s[\u000e{W.\\1oINT!bY8oi&tW/\u001a,n\u0015)\u0019H/\u001a9BGRLwN\u001c\u0006\u0019GJ,\u0017\r^3Ce\u0016\f7\u000e]8j]RD\u0015M\u001c3mKJ\u001c(b\u00053p\u000f\u0016$\bK]8dKN\u001c\b*\u00198eY\u0016\u0014(B\u0004)s_\u000e,7o\u001d%b]\u0012dWM\u001d\u0006\baJ|7-Z:t\u0015U9W\r\u001e\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7feNT\u0001eZ3u\u0007V\u0014(/\u001a8u'R\fG/\u001a%za\u0016\u0014H.\u001b8l\u0019&\u001cH/\u001a8fe*\t\u0002*\u001f9fe2Lgn\u001b'jgR,g.\u001a:\u000b\u000b)\fg/\u0019=\u000b\u000bM<\u0018N\\4\u000b\u000b\u00154XM\u001c;\u000b\u00119+H\u000e\\1cY\u0016T1\"\u00198o_R\fG/[8og*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0017O\u0016$8)\u001e:sK:$8\u000b^1uK6+7o]1hK*9aj\u001c;Ok2d'BE4fi\u0016#\u0017\u000e^8sgB\u0013xN^5eKJT\u0011dZ3u\u0019>\u001c\u0017\r^5p]N4uN\u001d\"sK\u0006\\\u0007o\\5oi*y\u0001\fT5oK\n\u0013X-Y6q_&tGOC\u000ep]2L8k\\;sG\u0016l\u0015\r\u001d9fI\n\u0013X-Y6q_&tGo\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0005M_\u000e\fG/[8o\u0015U9W\r\u001e*fC2\u0004&o\\2fgND\u0015M\u001c3mKJTqcZ3u'6\f'\u000f^*uKBLe\u000e^8IC:$G.\u001a:\u000b\u000b\u001d,GOV7\u000b\u0005Yk'\u0002F5t-\u0006dW/Z:DkN$x.\\*peR,GM\u0003\njgZk7\u000b^3q\u001fV$8i\u001c:sK\u000e$(\"\u00059s_\u000e,7o\u001d\"sK\u0006\\\u0007o\\5oi*q1+^:qK:$7i\u001c8uKb$(b\u0004=TkN\u0004XM\u001c3D_:$X\r\u001f;\u000b%M+8\u000f]3oI\u000e{g\u000e^3yi&k\u0007\u000f\u001c\u0006)aJ|7-Z:t\u0005J,\u0017m\u001b9pS:$Hj\\4FqB\u0014Xm]:j_:\fe\u000eZ*vgB,g\u000e\u001a\u0006\u0007e\u0016\u001cX/\\3\u000b!M\fg/\u001a*fg>dg/\u001a3GS2,'bA;sY*!a-\u001b7f\u0015)\u0019X\r^(wKJd\u0017-\u001f\u0006(g\u0016$\bK]8dKN\u001c(I]3bWB|\u0017N\u001c;D_:$\u0017\u000e^5p]N\fE/\u00133f'&$WMC\u0003wC2,XM\u0003\nti\u0006\u0014HOR8sG\u0016\u001cF/\u001a9J]R|'\u0002D:uCJ$\b+Y;tS:<'\"D:uCJ$8\u000b^3q\u0013:$xN\u0003\u0007ti\u0006\u0014Ho\u0015;fa>+HOC\u0007ti\u0006\u0014Ho\u0015;fa>3XM\u001d\u0006\u0014kB$\u0017\r^3MCN$8)\u00197m\rJ\fW.\u001aM\u0005\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQa\u0001\u0003\u0002\u0011\u0001a\u0001!\u0002\u0002\u0005\u0003!\u0019Qa\u0001\u0003\u0003\u0011\u000ba\u0001!B\u0001\t\t\u0015\u0011Aa\u0001E\u0005\u000b\t!9\u0001C\u0003\u0006\u0007\u0011!\u0001r\u0001\u0007\u0001\u000b\r!A\u0001#\u0004\r\u0001\u0015\u0011A\u0001\u0002\u0005\t\u000b\r!Y\u0001c\u0004\r\u0001\u0015\u0011A\u0001\u0002E\n\u000b\r!i\u0001C\u0005\r\u0001\u0015\u0011Aq\u0001\u0005\f\u000b\r!y\u0001#\u0006\r\u0001\u0015\u0011A\u0001\u0002E\u0007\u000b\t!!\u0001#\u0002\u0006\u0005\u0011-\u0001rB\u0003\u0003\t\u001bA\u0011\"\u0002\u0002\u0005\u0010!UQ!\u0001E\r\u000b\r!1\u0002\u0003\u0007\r\u0001\u0015\u0011A\u0001\u0002E\u000e\u000b\r!A\u0002C\u0007\r\u0001\u0015\u0011Aa\u0003E\u000f\u000b\t!Q\u0002C\b\u0006\u0005\u0011a\u0001\"D\u0003\u0004\t-A\u0011\u0003\u0004\u0001\u0006\u0007\u0011\t\u0001\"\u0006\u0007\u0001\u000b\t!\u0011\u0001C\u000b\u0006\u0007\u0011\t\u0001b\u0006\u0007\u0001\u000b\t!\u0011\u0001C\f\u0006\u0003!QRA\u0001\u0003\u0012\u0011k)!\u0001b\t\t7\u0015\u0011AA\u0005E\u001c\u000b\r!)\u0003c\r\r\u0001\u0015\u0011AQ\u0005E\u001a\u000b\r!!\u0003C\u000f\r\u0001\u0015\u0011Aq\u0001E\u001b\u000b\r!I\u0003c\u000f\r\u0001\u0015\u0011Aq\u0001E\u001f\u000b\t!Y\u0003C\u0010\u0006\u0007\u00111\u0002B\b\u0007\u0001\u000b\t!!\u0003C\u000f\u0006\u0007\u0011a\u0001\"\t\u0007\u0001\u000b\r!1\u0002\u0003\u0012\r\u0001\u0015\u0011A\u0001\u0002E$\u000b\r!\t\u0004C\u0012\r\u0001\u0015\u0019Aa\u0003\u0005%\u0019\u0001)!\u0001\u0002\u0007\tC\u0015\u0011A!\u0005E%\u000b\t!)\u0004\u0003\u0012\u0006\u0005\u0011E\u0002bI\u0003\u0003\t\u001fA\u0001&B\u0002\u00059!=C\u0002A\u0003\u0003\tqAy%B\u0001\tU\u0015\u0011A1\bE+\u000b\t!a\u0004C\u0016\u0006\u0007\u0011u\u00022\u000b\u0007\u0001\u000b\t!\t\u0001\u0003\u0017\u0006\u0007\u0011}\u0002r\u000b\u0007\u0001\u000b\t!i\u0004c\u0015\u0006\u0007\u0011}\u00022\f\u0007\u0001\u000b\r!A\u0002C\u0018\r\u0001\u0015\u0019Aa\u0003\u00051\u0019\u0001)1\u0001B\u0001\tb1\u0001QA\u0001C\u0012\u0011A*!\u0001\u0002\u0007\t_\u0015\u0019A!\u0001E3\u0019\u0001)!\u0001B\u0001\tf\u0015\u0019A!\u0001E5\u0019\u0001)!\u0001B\u0001\tH\u0015\u0019A1\nE6\u0019\u0001)!\u0001B\u0001\tj\u0015\u0011A1\nE6\u000b\t!I\u0003c\u000f\u0006\u0005\u00111\u0002B\b\u0003\u0014\u0019\u0007)r\u0001\u0002\u0001\t\u0005U!Q!\u0001E\u0003\u0013\u0005!\u0019!\u0007\u0002\u0006\u0003!%Qf\u0006\u0003b\ta]\u0011\u0005C\u0003\u0002\u0011/IQ!\u0003\u0003\u0006\u0003!e\u0011\"\u0001C\u0002I\u0005*6!C\u0003\u0004\t9I\u0011\u0001c\u0007\u000e\t\u0011}\u0011B\u0001\u0005\u000f\u0019\u0003i\u0003\u0003B2\u00051\r\t3!\u0002\u0002\u0005\u0002!\u0001Qk\u0001\u0005\u0006\u0007\u0011\u0019\u0011\"\u0001\u0005\n\u001b\r!\u0001#C\u0001\t\u00135:BQ1\u0007\u0019\"\u0005\u0012Q!\u0001E\u000fI\tA#!V\u0002\u000f\u000b\r!\t#C\u0001\u0005\u00025\u0019A1E\u0005\u0002\t\u0003\tR\u0001\u0002\n\n\u0003\u0011\u0001Q\"\u0001C\u0001[-!\u0011\r\u0002\r\bC\t)\u0011\u0001\u0003\u0004V\u0007\u0011)1\u0001B\u0004\n\u0003!MQ\u0006\u0005\u0003c\taQ\u0011eA\u0003\u0002\u0011!a\t!V\u0002\t\u000b\r!!\"C\u0001\t\u00165\u0019AQE\u0005\u0002\u0011+is\u0003\"b\r1M\t#!B\u0001\t\u001e\u0011\u0012\u0001FA+\u0004\u001d\u0015\u0019AaE\u0005\u0002\t\u0003i1\u0001b\n\n\u0003\u0011\u0005\u0011#\u0002\u0003\u0015\u0013\u0005!\u0001!D\u0001\u0005\u00025BBQ1\u0007\u0019*\u0005\u001aQ!\u0001\u0005\u0010\u0019\u0003!#\u0001\u000b\u0002V\u00079)1\u0001\"\u000b\n\u0003!}Qb\u0001C\u0016\u0013\u0005Ay\"E\u0003\u0005-%\tA\u0001A\u0007\u0002\u0011?i\u0003\u0004\"b\r1[\t3!B\u0001\t!1\u0005AE\u0001\u0015\u0003+\u000eqQa\u0001C\u0017\u0013\u0005A\t#D\u0002\u00050%\t\u0001\u0012E\t\u0006\taI\u0011\u0001\u0002\u0001\u000e\u0003!\u0005Rf\u0003\u0003B\u001aaE\u0012EA\u0003\u0002\u0011;)6\u0001B\u0003\u0004\tcI\u0011\u0001\"\u0001.\u001f\u0011\u0011G\u0001G\r\"\u0005\u0015\t\u0001bE+\u0004\u0011\u0015\u0019A!G\u0005\u0002\u0011Oi1\u0001\u0002\u000f\n\u0003!\u001dRF\u0004\u0003b\taE\u0011%B\u0003\u0002\u0011\u001dI\u0011\u0001b\u0001\r\u0002U\u001bA!B\u0002\u0005\u0012%\t\u0001BC\u0017\u0018\t\t$\u0001\u0014H\u0011\u000b\u000b\u0005AA#C\u0002\n\u0005\u0015\t\u0001\"F\u0005\u0004\u0013\t)\u0011\u0001#\fV\u0007!)1\u0001\"\u000f\n\u0003!9Rb\u0001C \u0013\u0005Aq#L\u0015\u0005\u0003a\u0001S\u0014\u0003\u0003\u0001\u0011\u0003jA!B\u0001\t0%\tA1\u0001)\u0004\u0001u=A\u0001\u0001E\"\u001b\r)\u0011\u0001\u0003\r\r\u0002A\u001b\t!(\u0004\u0005\u0001!\u0015SBA\u0003\u0002\u0011e\u00016!A\u0011\u0003\u000b\u0005A\u0019$U\u0002\n\t\u0001J\u0011\u0001\u0002\u0001\u000e\u0003!QR\"\u0001\u0005\u001c\u001b\u0005A9$l\u0005\u0005\u0007a)\u0013EA\u0003\u0002\u0011;\t6a\u0001\u0003&\u0013\u0005!\t!L\n\u0005\u0005a-ST\u0002\u0003\u0001\u0011\u0019j!!B\u0001\t!A\u001b\u0001!\t\u0002\u0006\u0003!M\u0012kA\u0003\u0005L%\tA\u0001A\u0007\u0002\u0011Ci\u000b\u0003\u0002\n\u0019N\u0005BQ!\u0001E\f\u0013\u0015IA!B\u0001\t\u001a%\tA1A)\u0004\t\u00115\u0013B\u0001\u0005\u000f\u0019\u0003i\u001b\u0002\u0002\u0006\u0019O\u0005\u0012Q!\u0001E\u001d#\u000e\u0019AaJ\u0005\u0002\u0011ui\u000b\u0003B\u0002\u0019R\u0005BQ!\u0001E\f\u0013\u0015IA!B\u0001\t\u001a%\tA1A)\u0004\t\u0011E\u0013B\u0001\u0005\u000f\u0019\u0003i;\u0003B\u0002\u0019S\u0005bQ!\u0001\u0005 !3*Z!B\u0001\t?1\u0005\u0011kA\u0001\u0005AE\u001b\u0011\u0001\u0002\u0011R\u0007\r!\u0011&C\u0001\tB5\u001eBa\u0001\r.C1)\u0011\u0001\u0003\r\u0011ZU-Q!\u0001\u0005\u0019\u0019\u0003\t6!\u0001\u0003\"#\u000e\tA!I)\u0004\u0007\u0011i\u0013\"\u0001\u0005\u001c['!1\u0001\u0007\u0018\"\u0005\u0015\t\u0001BB)\u0004\u0007\u0011q\u0013\"\u0001E\n[\u000b\"1\u0003'\u0018\u001e\u0012\u0011\u0001\u0001\u0012I\u0007\u0005\u000b\u0005A\u0019%C\u0001\u0005\u0004A\u001b\u0001!(\u0004\u0005\u0001!}SBA\u0003\u0002\u0011;\u00016\u0011A\u0011\u0007\u000b\u0005A!%C\u0002\n\u0005\u0015\t\u0001RI)\u0004\u000f\u0011u\u0013\"\u0001\u0005$\u001b\u0005A9%D\u0001\u0005\u00025VAA\u0001\r2C\r)\u0011\u0001#\u000f\r\u0002E\u001b1\u0001B\u0019\n\u0003!iR\u0016\u0004\u0003\u00041G\nS!B\u0001\t\u000f%\tA1\u0001G\u0001#\u000e\u0019A1M\u0005\u0002\u0011)i+\u0002B\u0002\u0019e\u0005\u001aQ!\u0001\u0005%\u0019\u0003\t6a\u0001\u00033\u0013\u0005AI%l\u0005\u0005\u0007a\u0019\u0014EA\u0003\u0002\u0011;\t6a\u0001\u00034\u0013\u0005!\t!l\u0005\u0005\u0015a\u001d\u0014EA\u0003\u0002\u0011;\t6a\u0001C4\u0013\u0005!\t!\f\u0015\u0005\u0005a!TT\u0002\u0003\u0001\u0011\u000bj!!B\u0001\tKA\u001b\u0001!(\u0005\u0005\u0001!\u0005S\u0002B\u0003\u0002\u0011_I\u0011\u0001b\u0001Q\u0007\u0003ij\u0001\u0002\u0001\tk5\u0011Q!\u0001\u0005'!\u000e\t\u0011EA\u0003\u0002\u0011g\t6!\u0003\u00035\u0013\u0005!\u0001!D\u0001\tN5\t\u0001BG\u0007\u0002\u0011\u001dj\u0003\u0006B\u0001\u0019muEA\u0001\u0001E!\u001b\u0011)\u0011\u0001c\f\n\u0003\u0011\r\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\"N\u0007\u0003\u000b\u0005Aa\u0005UB\u0001;\u001b!\u0001\u0001#\u0012\u000e\u0005\u0015\t\u0001\"\n)\u0004\u0003\u0005\u0012Q!\u0001E\u001a#\u000eIAAN\u0005\u0002\t\u0001i\u0011\u0001\u0003\u000e\u000e\u0003!9S\"\u0001E'['!1\u0001'\u001c\"\u0005\u0015\t\u00012G)\u0004\u0007\u00115\u0014\"\u0001\u0003\u0001[s!1\u0001G\u001c\u001e\u000e\u0011\u0001\u0001rN\u0007\u0003\u000b\u0005AQ\u0003U\u0002\u0001;\u001b!\u0001\u0001\u0003\u001d\u000e\u0005\u0015\t\u0001R\u0006)\u0004\u0002\u0005\u0012Q!\u0001E\u001a#\u000e9AaN\u0005\u0002\t\u0001i\u0011\u0001c\u0014\u000e\u0003!AS6\u0003\u0003\u00031c\n#!B\u0001\t4E\u001b1\u0001\"\u001d\n\u0003\u0011\u0001Qf\u0005\u0003\u00041ejj\u0001\u0002\u0001\tt5\u0011Q!\u0001E\u000f!\u000e\u0001\u0011EA\u0003\u0002\u0011g\t6!\u0002\u0003:\u0013\u0005!\u0001!D\u0001\u0005\u00025NAa\u0001\r;C\t)\u0011\u0001c\rR\u0007\r!!(C\u0001\u0005\u00015NAa\u0001M;C\t)\u0011\u0001c\rR\u0007\r!)(C\u0001\u0005\u00015NAa\u0001\r<C\t)\u0011\u0001c\rR\u0007\r!1(C\u0001\u0005\u00015NAa\u0001M<C\t)\u0011\u0001c\rR\u0007\r!9(C\u0001\u0005\u00015NAa\u0001\r=C\t)\u0011\u0001c\rR\u0007\r!A(C\u0001\u0005\u00015NA!\u0001M=C\t)\u0011\u0001c\rR\u0007\r!I(C\u0001\u0005\u0001Uj\r!bf\u0001\t\r\b\u0011c\u0002\u0003\u0001\u0011\t)B!B\u0001\t\u0006%\tA1\u0001M\u0006;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0004\u001b\r)!\u0001\"\u0001\t\u0001A\u001b\t!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u0019\u00016!AO\n\t\u0001A\t\"D\u0003\u0006\u0003!9\u0011\"\u0001C\u0002\u0019\u0003\u000161AO\b\t\u0001A!\"D\u0002\u0006\u0003!AA\u0012\u0001)\u0004\u0005\u0005:Q!\u0001E\u0002\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011kA\u0007\u0005\f%\tA\u0001A\u0007\u0002\u0011#i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000b\u001b\u0005A)\u0002"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final ReadOnlyProperty<? super Object, ? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DebugProcessImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_breakpointHandlers")};
    }

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@JetValueParameter(name="<set-?>", type="?") @Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@JetValueParameter(name="<set-?>", type="?") @Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean getIsForceStep() {
        return this.isForceStep;
    }

    protected final void setIsForceStep(@JetValueParameter(name="<set-?>") boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(@JetValueParameter(name="<set-?>") boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])this._breakpointHandlers$delegate.get((Object)this, $propertyMetadata[0]);
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    @NotNull
    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.get_breakpointHandlers();
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(@JetValueParameter(name="value") boolean value) {
        this.processBreakpointConditionsAtIdeSide = value;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected final void continueVm(@JetValueParameter(name="stepAction") @NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@JetValueParameter(name="suspendContext") @NotNull SuspendContext suspendContext, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.1.class);
                }

                protected void consume(@JetValueParameter(name="evaluationResult") @NotNull String evaluationResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)evaluationResult, (String)"evaluationResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    if (Intrinsics.areEqual((Object)"false", (Object)evaluationResult)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.2.class);
                }

                protected void consume(@JetValueParameter(name="failure") @NotNull Throwable failure, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(@JetValueParameter(name="breakpoint") XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") SuspendContextImpl xSuspendContext, @JetValueParameter(name="suspendContext") SuspendContext suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.1.class);
                }

                protected void consume(@JetValueParameter(name="logResult") @NotNull String logResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, logResult, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, logExpression, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ String $logExpression;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.2.class);
                }

                protected void consume(@JetValueParameter(name="logResult") @NotNull Throwable logResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, "Failed to evaluate expression: " + this.$logExpression, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$logExpression = $captured_local_variable$2;
                    this.$xSuspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void breakpointReached(@JetValueParameter(name="breakpoint") XBreakpoint<?> breakpoint, @JetValueParameter(name="evaluatedLogExpression", type="?") String evaluatedLogExpression, @JetValueParameter(name="suspendContext") XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doGetProcessHandler.1.class);
                }

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@JetValueParameter(name="url") @NotNull Url url, @JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public abstract List<Location> getLocationsForBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> var1, @JetValueParameter(name="onlySourceMappedBreakpoints") boolean var2);

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@JetValueParameter(name="session") @NotNull XDebugSession session, @JetValueParameter(name="connection") @NotNull C connection, @JetValueParameter(name="editorsProvider") @NotNull XDebuggerEditorsProvider editorsProvider, @JetValueParameter(name="smartStepIntoHandler", type="?") @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @JetValueParameter(name="executionResult", type="?") @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        });
        ((VmConnection)this.connection).addListener(new SocketConnectionListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            @Override
            public void statusChanged(@JetValueParameter(name="status") @NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status == ConnectionStatus.DISCONNECTED || status == ConnectionStatus.DETACHED) {
                    if (status == ConnectionStatus.DETACHED && this.getRealProcessHandler() != null) {
                        this.getProcessHandler().detachProcess();
                    }
                    this.getSession().stop();
                } else {
                    this.getSession().rebuildViews();
                }
            }
        });
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend$0(@JetValueParameter(name="$this", type="?") DebugProcessImpl<C> $this, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") @NotNull SuspendContextImpl xSuspendContext, @JetValueParameter(name="suspendContext") @NotNull SuspendContext suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached$1(@JetValueParameter(name="$this", type="?") DebugProcessImpl<C> $this, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="evaluatedLogExpression", type="?") @Nullable String evaluatedLogExpression, @JetValueParameter(name="suspendContext") @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }
}

