/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.LineBreakpointManager;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Vm;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"}\u000e))B*\u001b8f\u0005J,\u0017m\u001b9pS:$X*\u00198bO\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\tI\u0016\u0014WoZ4fe*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019a\u0014N\\5u})\u0011a/\u001c\u0006\u0003-6TA\u0002Z3ck\u001e\u0004&o\\2fgNT\u0001\u0003R3ck\u001e\u0004&o\\2fgNLU\u000e\u001d7\u000b#%$W\rV8W[\n\u0013X-Y6q_&tGO\u0003\u0005Nk2$\u0018.T1q\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!Q\u000f^5m\u0015)\u0019wN\u001c;bS:,'o\u001d\u0006\u001012Kg.\u001a\"sK\u0006\\\u0007o\\5oi*I\u0001\u0010Z3ck\u001e<WM\u001d\u0006\fEJ,\u0017m\u001b9pS:$8OC\fl_Rd\u0017N\u001c\u0018km6t\u0003\u000b\\1uM>\u0014X\u000eV=qK*Q!I]3bWB|\u0017N\u001c;\u000b\u000f9{GOT;mY*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011awnY6\u000b\r=\u0013'.Z2u\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0019eVtGk\u001c'pG\u0006$\u0018n\u001c8Ce\u0016\f7\u000e]8j]R\u001c(\u0002\u0003+ICND7+\u001a;\u000b\u0007\u001dtWOC\u0003ue>4XMC\tw[R{\u0017\nZ3Ce\u0016\f7\u000e]8j]RTAcZ3u-6$v.\u00133f\u0005J,\u0017m\u001b9pS:$(b\u00062fM>\u0014XM\u0011:fC.\u0004x.\u001b8u%\u0016lwN^3e\u0015)\u0011'/Z1la>Lg\u000e\u001e\u0006\bI&\u001c\u0018M\u00197f\u0015\u001d\u0011un\u001c7fC:TA!\u00168ji*i2\r\\3beJ+h\u000eV8M_\u000e\fG/[8o\u0005J,\u0017m\u001b9pS:$8O\u0003\u0007de\u0016\fG/\u001a+be\u001e,GOC\tce\u0016\f7\u000e]8j]Rl\u0015M\\1hKJT\u0011C\u0011:fC.\u0004x.\u001b8u\u001b\u0006t\u0017mZ3s\u0015!awnY1uS>t'\u0002\u0003'pG\u0006$\u0018n\u001c8\u000b\u0017%\u001cH+Z7q_J\f'/\u001f\u0006\u0011\u0005J,\u0017m\u001b9pS:$H+\u0019:hKRT!\u0003Z8SK6|g/\u001a\"sK\u0006\\\u0007o\\5oi*9\u0001K]8nSN,'bC2p]\u000e,(O]3oGfTAAV8jI*yAm\u001c*v]R{Gj\\2bi&|gN\u0003\u0005q_NLG/[8o\u0015=A6k\\;sG\u0016\u0004vn]5uS>t'\u0002\u0002'jgRTq\u0002Z8TKR\u0014%/Z1la>Lg\u000e\u001e\u0006\u0019SN\fe.\u001f$jeN$H*\u001b8f\u0005J,\u0017m\u001b9pS:$(\u0002G5t%VtGk\\\"veN|'O\u0011:fC.\u0004x.\u001b8ug*!\"/Z7pm\u0016\fE\u000e\u001c\"sK\u0006\\\u0007o\\5oiNT\u0001C]3n_Z,'I]3bWB|\u0017N\u001c;\u000b\u0013Q,W\u000e]8sCJL(\"\u0004:v]R{Gj\\2bi&|gNC\u0007tKR\u0014%/Z1la>Lg\u000e\u001e\u0006\u001c_:d\u0017pU8ve\u000e,W*\u00199qK\u0012\u0014%/Z1la>Lg\u000e^:\u000b\u00131|7-\u0019;j_:\u001c(\u0002F;qI\u0006$X-\u00117m\u0005J,\u0017m\u001b9pS:$8O1\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)1\u0001B\u0001\t\u00011\u0001Q!\u0001E\u0003\u000b\r!!\u0001\u0003\u0002\r\u0001\u0015\u0019A!\u0001\u0005\u0005\u0019\u0001)1\u0001B\u0001\t\u000b1\u0001QA\u0001\u0003\u0002\u0011\u0011)!\u0001B\u0001\t\u000b\u0015\t\u0001RB\u0003\u0003\t\u0015Aq!\u0002\u0002\u0005\f!=QA\u0001\u0003\u0007\u0011!)1\u0001\"\u0004\t\r1\u0001QA\u0001C\u0006\u0011%)!\u0001b\u0004\t\u0014\u0015\u0019A\u0001\u0003E\t\u0019\u0001)1\u0001B\u0001\t\u00161\u0001QA\u0001C\u0001\u0011/)1\u0001b\u0005\t\u00171\u0001QA\u0001C\u0007\u0011\u0019)\u0011\u0001C\u0007\u0006\u0005\u0011Y\u00012D\u0003\u0004\t/AI\u0002\u0004\u0001\u0006\u0005\u0011]\u0001\u0012D\u0003\u0002\u0011=)!\u0001B\u0007\t \u0015\u0019A1\u0004E\u000f\u0019\u0001)!\u0001b\u0007\t\u001e\u0015\u0019AA\u0001E\u0013\u0019\u0001)1\u0001\u0002\u0002\t'1\u0001QA\u0001\u0003\t\u0011#)1\u0001B\u0001\t+1\u0001Qa\u0001\u0003\u0002\u0011Ya\u0001!B\u0002\u0005\u0003!9B\u0002A\u0003\u0003\t\u0005Aq#\u0002\u0002\u0005\u0003!)RA\u0001\u0003\u0002\u0011Y)!\u0001\"\u0001\t2\u0015\u0019Aq\u0005\u0005\u0019\u0019\u0001)1\u0001b\u0006\t31\u0001QA\u0001C\u0014\u0011a)1\u0001b\u0004\t61\u0001Qa\u0001\u0003\u0003\u0011ma\u0001!\u0002\u0002\u0005\u0017!=QA\u0001C\u0017\u0011m)!\u0001b\u0004\t6\u0015\u0011A!\u0001E\u000b\tMa\u0019!\u0007\u0002\u0006\u0003!\u0015Q&\u0004\u0003b\ta%\u0011\u0005B\u0003\u0002\u0011\u000fI\u0011\u0001b\u0001V\u0007\u0011)1\u0001\"\u0003\n\u0003!%Q&1\u0001\u0005C\u0012AZ!\t\u001d\u0006\u0003!9\u0011\u0002D\u0005\f\u000b\u0005A\t\"C\u0001\u0005\u0004AQQ#B\u0003\u0002\u0011#I\u0011\u0001b\u0001\r\u0002%A\u0011bB\u0003\u0002\u0011%\u0001\"\"F\u0002\u0006\u0003!IA\u0012\u0001\t\u000b+o)\u0011\u0001C\u0004\n\u0019%YQ!\u0001E\t\u0013\u0005!\u0019\u0001\u0005\u0006\u0016\u000b\u0015\t\u0001\u0012C\u0005\u0002\t\u0007a\t!\u0003\u0005\n\u000f\u0015\t\u0001\"\u0003\t\u000b+\r)\u0011\u0001C\u0005\r\u00021\u0005\u0011kA\u0001\u0005\u0015E\u001b\u0011\u0001\u0002\u0006V\u0007\u0011)1\u0001b\u0003\n\u0003!UQf\u0003\u0003b\taa\u0011EA\u0003\u0002\u00111)6\u0001B\u0003\u0004\t1I\u0011\u0001#\u0007.\u001f\u0011\tG\u0001\u0007\b\"\r\u0015\t\u0001BD\u0005\u0004\u0013\t)\u0011\u0001C\u0005V\u0007\u0011)1\u0001\u0002\b\n\u0003!uQf\u0003\u0003b\ta\u001d\u0011EA\u0003\u0002\u0011\r)6\u0001B\u0003\u0004\t\u000fI\u0011\u0001\u0003\u0003.3\u0011\u0011G\u0001\u0007\t\"\u0019\u0015\t\u0001bB\u0005\u0004\u0013\t)\u0011\u0001C\u0005\n\u000b%!Q!\u0001E\t\u0013\u0005!\u0019!V\u0002\t\u000b\r!\u0001#C\u0001\t\u00165\u0019A\u0011E\u0005\u0002\u0011+ik\u0004\u0002\u0006\u0019#uEA\u0001\u0001E\u0012\u001b\u0011)\u0011\u0001#\u0005\n\u0003\u0011\r\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BE\u0007\u0003\u000b\u0005Aq\u0002UB\u0001C\t)\u0011\u0001c\bR\u0007\u001d!\u0011#C\u0001\u0005\u00015\t\u0001\u0002E\u0007\u0002\t\u0003i\u001b\u0002B\u0002\u0019(\u0005\u0012Q!\u0001E\u0010#\u000e\u0019AqE\u0005\u0002\t\u0001i+\u0007\u0002\n\u0019)uMA\u0001\u0001E\u0012\u001b\u0015)\u0011\u0001#\u0005\n\u0003\u0011\rA\u0012\u0001)\u0004\u0001u5A\u0001\u0001E\u0015\u001b\t)\u0011\u0001#\tQ\u0007\u0003ij\u0001\u0002\u0001\t,5\u0011Q!\u0001\u0005\u0012!\u000e\tQT\u0002\u0003\u0001\u0011[i!!B\u0001\t\u001fA\u001b\u0019!\t\u0002\u0006\u0003!\r\u0012kA\u0006\u0005)%\t\u0001BE\u0007\u0002\u0011Ai\u0011\u0001#\n\u000e\u0003!\u0019R\"\u0001C\u0001[\u000b\"1\u0001g\f\u001e\u0012\u0011\u0001\u00012E\u0007\u0005\u000b\u0005A\t\"C\u0001\u0005\u0004A\u001b\u0001!(\u0004\u0005\u0001!\u0011RBA\u0003\u0002\u0011=\u00016\u0011A\u0011\u0007\u000b\u0005AA#C\u0002\n\u0005\u0015\t\u0001\u0012F)\u0004\u000f\u0011=\u0012\"\u0001\u0005\u0016\u001b\u0005A\u0001#D\u0001\u0005\u00025:BA\u0005M\u001a;\u001b!\u0001\u0001\u0003\u000e\u000e\u0005\u0015\t\u00012\u0006)\u0004\u0001\u00052Q!\u0001\u0005\u0017\u0013\rI!!B\u0001\t\u0013E\u001bQ\u0001b\r\n\u0003!9R\"\u0001E\u0018[%\"!\u0001g\u000e\u001e\u0014\u0011\u0001\u00012E\u0007\u0006\u000b\u0005A\t\"C\u0001\u0005\u00041\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012F\u0007\u0003\u000b\u0005A\u0011\u0003UB\u0001;\u001b!\u0001\u0001#\f\u000e\u0005\u0015\t\u0001b\u0004)\u0004\u0003\u0005\u0012Q!\u0001\u0005\n#\u000eIAqG\u0005\u0002\u0011ai\u0011\u0001\u0003\t\u000e\u0003!\u0019R\"\u0001C\u0001[M!1\u0002\u0007\u000f\u001e\u000e\u0011\u0001\u00012E\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001C\t)\u0011\u0001C\bR\u0007\u0015!A$C\u0001\u0005\u00025\t\u0001\u0002G\u0017\u0018\t\rAJ$(\u0006\u0005\u0001!MQBB\u0003\u0002\u0011YI1!\u0003\u0002\u0006\u0003!I\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bD)\u0004\u000b\u0011e\u0012\"\u0001C\u0001\u001b\u0005Aq#l\u0007\u0005\u0007ai\u0012EB\u0003\u0002\u0011QI1!\u0003\u0002\u0006\u0003!%\u0012kA\u0002\u0005;%\t\u0001\"FW#\t\rAZ$(\u0005\u0005\u0001!\rR\u0002B\u0003\u0002\u0011#I\u0011\u0001b\u0001Q\u0007\u0001ij\u0001\u0002\u0001\t=5\u0011Q!\u0001\u0005\u0010!\u000e\u0005\u0011EB\u0003\u0002\u0011QI1!\u0003\u0002\u0006\u0003!%\u0012kA\u0004\u0005<%\t\u0001\"F\u0007\u0002\u0011Ai\u0011\u0001\"\u0001.'\u0011\u0019\u0001THO\u0007\t\u0001A!$\u0004\u0002\u0006\u0003!-\u0002k\u0001\u0001\"\u0005\u0015\t\u0001rD)\u0004\u000b\u0011u\u0012\"\u0001\u0003\u0001\u001b\u0005Ay#,\u0010\u0005\u0007ayR\u0014\u0003\u0003\u0001\u0011GiA!B\u0001\t\u0012%\tA1\u0001)\u0004\u0001u5A\u0001\u0001E \u001b\t)\u0011\u0001C\bQ\u0007\u0003\t#!B\u0001\t E\u001bq\u0001B\u0010\n\u0003\u0011\u0001Q\"\u0001\u0005\u0011\u001b\u0005!\t!,\u0012\u0005\u0007ayR\u0014\u0003\u0003\u0001\u0011GiA!B\u0001\t\u0012%\tA1\u0001)\u0004\u0001uUA\u0001\u0001\u0005!\u001b\u0019)\u0011\u0001\u0003\f\n\u0007%\u0011Q!\u0001\u0005\u0012!\u000e\u0005\u0011EA\u0003\u0002\u0011?\t6a\u0002\u0003 \u0013\u0005!\u0001!D\u0001\t!5\t\u0001bFW\n\t\rA\n%\t\u0002\u0006\u0003!}\u0011kA\u0002\u0005B%\tA\u0001A\u001b!\u000b}!1\u001d\u0001\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001b\u0001)\u0004\u0001uEA\u0001\u0001E\u0005\u001b\u0011)\u0011\u0001c\u0002\n\u0003\u0011\r\u0001k!\u0001\"\u0005\u0015\t\u00012A)\u0004\u000f\u0011\u0019\u0011\"\u0001\u0003\u0001\u001b\u0005AA!D\u0001\t\n\u0001"})
public abstract class LineBreakpointManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private final MultiMap<XLineBreakpoint<?>, Breakpoint> ideToVmBreakpoint;
    @NotNull
    private final MultiMap<Breakpoint, XLineBreakpoint<?>> vmToIdeBreakpoint;
    private final THashSet<Breakpoint> runToLocationBreakpoints;
    private final Object lock;
    private final Vm vm;
    private final DebugProcessImpl<?> debugProcess;

    static {
        $kotlinClass = Reflection.createKotlinClass(LineBreakpointManager.class);
    }

    @NotNull
    protected final MultiMap<Breakpoint, XLineBreakpoint<?>> getVmToIdeBreakpoint() {
        return this.vmToIdeBreakpoint;
    }

    public boolean isAnyFirstLineBreakpoint(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="onlySourceMappedBreakpoints") boolean onlySourceMappedBreakpoints) {
        Collection collection;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Object object = this.lock;
        synchronized (lock) {
            Collection collection2 = this.ideToVmBreakpoint.get(breakpoint);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : lock
            collection = collection2;
        }
        Collection target = collection;
        if (target.isEmpty()) {
            this.setBreakpoint(breakpoint, this.debugProcess.getLocationsForBreakpoint(breakpoint, onlySourceMappedBreakpoints));
        } else {
            BreakpointManager breakpointManager = this.vm.getBreakpointManager();
            for (Breakpoint vmBreakpoint : target) {
                if (vmBreakpoint.isEnabled()) continue;
                breakpointManager.flush(vmBreakpoint.enabled(true)).rejected((Consumer)new Consumer<Throwable>(this, breakpoint){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ LineBreakpointManager this$0;
                    final /* synthetic */ XLineBreakpoint $breakpoint;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(setBreakpoint.1.class);
                    }

                    public void consume(@JetValueParameter(name="error") @NotNull Throwable error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        LineBreakpointManager.access$getDebugProcess$3(this.this$0).getSession().updateBreakpointPresentation(this.$breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, error.getMessage());
                    }
                    {
                        this.this$0 = $outer;
                        this.$breakpoint = $captured_local_variable$1;
                    }
                });
            }
        }
    }

    @NotNull
    public final Promise<Void> removeBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="temporary") boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        boolean disable = temporary && this.vm.getBreakpointManager().getMuteMode() != BreakpointManager.MUTE_MODE.NONE;
        this.beforeBreakpointRemoved(breakpoint, disable);
        return this.doRemoveBreakpoint(breakpoint, disable);
    }

    protected void beforeBreakpointRemoved(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="disable") boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Void> doRemoveBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="disable") boolean disable) {
        void vmBreakpoints;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = KotlinPackage.emptySet();
        Object object = this.lock;
        synchronized (lock) {
            Object vmBreakpoint3;
            if (disable) {
                Collection collection = this.ideToVmBreakpoint.get(breakpoint);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ideToVmBreakpoint.get(breakpoint)");
                vmBreakpoints.element = collection;
                if (!((Collection)vmBreakpoints.element).isEmpty()) {
                    Iterator iterator = ((Collection)vmBreakpoints.element).iterator();
                    if (iterator == null) {
                        throw new TypeCastException("kotlin.Iterator<org.jetbrains.debugger.Breakpoint> cannot be cast to kotlin.MutableIterator<org.jetbrains.debugger.Breakpoint>");
                    }
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Object vmBreakpoint2 = (Breakpoint)iterator2.next();
                        if (this.getVmToIdeBreakpoint().get(vmBreakpoint2).size() <= 1) continue;
                        iterator2.remove();
                    }
                }
            } else {
                Collection collection = this.ideToVmBreakpoint.remove(breakpoint);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ideToVmBreakpoint.remove(breakpoint)");
                vmBreakpoints.element = collection;
                if (!ContainerUtil.isEmpty((Collection)((Collection)vmBreakpoints.element))) {
                    for (Object vmBreakpoint3 : (Collection)vmBreakpoints.element) {
                        this.getVmToIdeBreakpoint().remove(vmBreakpoint3, breakpoint);
                        if (!this.getVmToIdeBreakpoint().containsKey(vmBreakpoint3)) continue;
                        Promise promise = Promise.DONE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.DONE");
                        Promise promise2 = promise;
                        return promise2;
                    }
                }
            }
            vmBreakpoint3 = Unit.INSTANCE$;
        }
        if (ContainerUtil.isEmpty((Collection)((Collection)vmBreakpoints.element))) {
            Promise promise = Promise.DONE;
            Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.DONE");
            return promise;
        }
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        SmartList promises = new SmartList();
        if (disable) {
            for (Object vmBreakpoint2 : (Collection)vmBreakpoints.element) {
                promises.add(breakpointManager.flush(((Breakpoint)vmBreakpoint2).enabled(false)));
            }
        } else {
            for (Object vmBreakpoint2 : (Collection)vmBreakpoints.element) {
                promises.add(breakpointManager.remove((Breakpoint)vmBreakpoint2));
            }
        }
        Promise promise = Promise.all((Collection)((Collection)promises));
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.all(promises)");
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="locations") @NotNull List<? extends Location> locations) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        if (locations.isEmpty()) {
            return;
        }
        SmartList vmBreakpoints = new SmartList();
        for (Location location : locations) {
            vmBreakpoints.add((Object)this.doSetBreakpoint(breakpoint, location, false));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ideToVmBreakpoint.put(breakpoint, (Collection)vmBreakpoints);
            for (Breakpoint vmBreakpoint : vmBreakpoints) {
                this.getVmToIdeBreakpoint().putValue((Object)vmBreakpoint, breakpoint);
            }
            Iterator iterator = Unit.INSTANCE$;
        }
    }

    @NotNull
    protected final Breakpoint doSetBreakpoint(@JetValueParameter(name="breakpoint", type="?") @Nullable XLineBreakpoint<?> breakpoint, @JetValueParameter(name="location") @NotNull Location location, @JetValueParameter(name="isTemporary") boolean isTemporary) {
        BreakpointManager breakpointManager;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        BreakpointManager breakpointManager2 = breakpointManager = this.vm.getBreakpointManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)breakpointManager2, (String)"breakpointManager");
        BreakpointTarget target = this.createTarget(breakpoint, breakpointManager2, location, isTemporary);
        XLineBreakpoint<?> xLineBreakpoint = breakpoint;
        XExpression condition = xLineBreakpoint != null ? xLineBreakpoint.getConditionExpression() : null;
        XExpression xExpression = condition;
        Breakpoint breakpoint2 = breakpointManager.setBreakpoint(target, location.getLine(), location.getColumn(), xExpression != null ? xExpression.getExpression() : null, Breakpoint.EMPTY_VALUE, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpointManager.setBre\u2026kpoint.EMPTY_VALUE, true)");
        return breakpoint2;
    }

    @NotNull
    protected abstract BreakpointTarget createTarget(@JetValueParameter(name="breakpoint", type="?") @Nullable XLineBreakpoint<?> var1, @JetValueParameter(name="breakpointManager") @NotNull BreakpointManager var2, @JetValueParameter(name="location") @NotNull Location var3, @JetValueParameter(name="isTemporary") boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runToLocation(@JetValueParameter(name="position") @NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Breakpoint> addedBreakpoints = this.doRunToLocation(position);
        if (addedBreakpoints.isEmpty()) {
            return;
        }
        Object lock = this.lock;
        synchronized (lock) {
            Boolean bl = this.runToLocationBreakpoints.addAll((Collection)addedBreakpoints);
        }
        this.debugProcess.resume();
    }

    @NotNull
    protected abstract List<Breakpoint> doRunToLocation(@JetValueParameter(name="position") @NotNull XSourcePosition var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunToCursorBreakpoints(@JetValueParameter(name="breakpoints") @NotNull List<? extends Breakpoint> breakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoints, (String)"breakpoints");
        THashSet<Breakpoint> lock = this.runToLocationBreakpoints;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.containsAll((Collection)breakpoints);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAllBreakpoints() {
        XLineBreakpoint[] xLineBreakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            Collection $receiver = this.ideToVmBreakpoint.keySet();
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("kotlin.Collection<T> cannot be cast to java.util.Collection<T>");
            }
            Collection thisCollection = collection;
            XLineBreakpoint[] xLineBreakpointArray2 = thisCollection.toArray(new XLineBreakpoint[thisCollection.size()]);
            if (xLineBreakpointArray2 == null) {
                throw new TypeCastException("kotlin.Array<(out) T?>! cannot be cast to kotlin.Array<T>");
            }
            XLineBreakpoint[] xLineBreakpointArray3 = (XLineBreakpoint[])((Object[])xLineBreakpointArray2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : lock
            xLineBreakpointArray = xLineBreakpointArray3;
        }
        XLineBreakpoint[] array = xLineBreakpointArray;
        for (int i = 0; i < array.length; ++i) {
            XLineBreakpoint breakpoint;
            XLineBreakpoint xLineBreakpoint = breakpoint = array[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
            this.removeBreakpoint(xLineBreakpoint, false);
            XLineBreakpoint xLineBreakpoint2 = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint2, (String)"breakpoint");
            this.setBreakpoint(xLineBreakpoint2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<Void> removeAllBreakpoints() {
        Object lock = this.lock;
        synchronized (lock) {
            this.ideToVmBreakpoint.clear();
            this.getVmToIdeBreakpoint().clear();
            this.runToLocationBreakpoints.clear();
            Unit unit = Unit.INSTANCE$;
        }
        Promise<Void> promise = this.vm.getBreakpointManager().removeAll();
        Intrinsics.checkExpressionValueIsNotNull(promise, (String)"vm.getBreakpointManager().removeAll()");
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRunToLocationBreakpoints() {
        Breakpoint[] breakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            if (this.runToLocationBreakpoints.isEmpty()) {
                return;
            }
            Breakpoint[] breakpoints = (Breakpoint[])this.runToLocationBreakpoints.toArray((Object[])new Breakpoint[this.runToLocationBreakpoints.size()]);
            this.runToLocationBreakpoints.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : lock
            breakpointArray = breakpoints;
        }
        Breakpoint[] breakpoints = breakpointArray;
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        for (int i = 0; i < breakpoints.length; ++i) {
            Breakpoint breakpoint = breakpoints[i];
            breakpointManager.remove(breakpoint);
        }
    }

    public LineBreakpointManager(@JetValueParameter(name="vm") @NotNull Vm vm, @JetValueParameter(name="debugProcess") @NotNull DebugProcessImpl<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.vm = vm;
        this.debugProcess = debugProcess;
        this.ideToVmBreakpoint = MultiMap.createSmart();
        MultiMap multiMap = MultiMap.createSmart();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createSmart()");
        this.vmToIdeBreakpoint = multiMap;
        this.runToLocationBreakpoints = new THashSet();
        this.lock = new Object();
        this.vm.getBreakpointManager().addBreakpointListener(new BreakpointManager.BreakpointListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolved(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint) {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                Object lock = lock;
                synchronized (lock) {
                    Collection collection2 = this.getVmToIdeBreakpoint().get((Object)breakpoint);
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : lock
                    collection = collection2;
                }
                Collection breakpoints = collection;
                for (XLineBreakpoint ideBreakpoint : breakpoints) {
                    debugProcess.getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, (String)null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void errorOccurred(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint, @JetValueParameter(name="errorMessage", type="?") @Nullable String errorMessage) {
                Collection collection;
                void lock;
                Boolean bl;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                if (this.isAnyFirstLineBreakpoint(breakpoint)) {
                    return;
                }
                Object lock2 = lock;
                synchronized (lock2) {
                    object = runToLocationBreakpoints.remove((Object)breakpoint);
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : lock
                    bl = object;
                }
                if (bl.booleanValue()) {
                    XDebugSession xDebugSession = debugProcess.getSession();
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot run to cursor: ");
                    String string = errorMessage;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    xDebugSession.reportError(stringBuilder.append(string).toString());
                    return;
                }
                object = lock;
                synchronized (lock) {
                    Collection collection2 = this.getVmToIdeBreakpoint().get((Object)breakpoint);
                    // MONITOREXIT @DISABLED, blocks:[1, 3] lbl30 : MonitorExitStatement: MONITOREXIT : lock
                    collection = collection2;
                }
                Collection breakpoints = collection;
                for (XLineBreakpoint ideBreakpoint : breakpoints) {
                    debugProcess.getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
                }
            }
        });
    }
}

