/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.theoryinpractice.testng.DataProviderReference;
import com.theoryinpractice.testng.inspection.DependsOnGroupsInspection;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestNGReferenceContributor
extends PsiReferenceContributor {
    private static PsiJavaElementPattern.Capture<PsiLiteralExpression> getElementPattern(String annotationParamName) {
        return (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().annotationParam(annotationParamName, (ElementPattern)PsiJavaPatterns.psiAnnotation().with((PatternCondition)new PatternCondition<PsiAnnotation>("isTestNGAnnotation"){

            public boolean accepts(@NotNull PsiAnnotation annotation, ProcessingContext context) {
                if (annotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/theoryinpractice/testng/TestNGReferenceContributor$1", "accepts"));
                }
                return TestNGUtil.isTestNGAnnotation(annotation);
            }
        }));
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/theoryinpractice/testng/TestNGReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("dependsOnMethods"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/theoryinpractice/testng/TestNGReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/theoryinpractice/testng/TestNGReferenceContributor$2", "getReferencesByElement"));
                }
                MethodReference[] methodReferenceArray = new MethodReference[]{new MethodReference((PsiLiteral)element)};
                if (methodReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$2", "getReferencesByElement"));
                }
                return methodReferenceArray;
            }
        });
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("dataProvider"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/theoryinpractice/testng/TestNGReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/theoryinpractice/testng/TestNGReferenceContributor$3", "getReferencesByElement"));
                }
                DataProviderReference[] dataProviderReferenceArray = new DataProviderReference[]{new DataProviderReference((PsiLiteral)element)};
                if (dataProviderReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$3", "getReferencesByElement"));
                }
                return dataProviderReferenceArray;
            }
        });
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("groups"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/theoryinpractice/testng/TestNGReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/theoryinpractice/testng/TestNGReferenceContributor$4", "getReferencesByElement"));
                }
                GroupReference[] groupReferenceArray = new GroupReference[]{new GroupReference(element.getProject(), (PsiLiteral)element)};
                if (groupReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$4", "getReferencesByElement"));
                }
                return groupReferenceArray;
            }
        });
        registrar.registerReferenceProvider(TestNGReferenceContributor.getElementPattern("dependsOnGroups"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/theoryinpractice/testng/TestNGReferenceContributor$5", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/theoryinpractice/testng/TestNGReferenceContributor$5", "getReferencesByElement"));
                }
                GroupReference[] groupReferenceArray = new GroupReference[]{new GroupReference(element.getProject(), (PsiLiteral)element)};
                if (groupReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$5", "getReferencesByElement"));
                }
                return groupReferenceArray;
            }
        });
    }

    private static class GroupReference
    extends PsiReferenceBase<PsiLiteral> {
        private final Project myProject;

        public GroupReference(Project project, PsiLiteral element) {
            super((PsiElement)element, false);
            this.myProject = project;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList<Object> list = new ArrayList<Object>();
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getInspectionProfile();
            DependsOnGroupsInspection inspection = (DependsOnGroupsInspection)inspectionProfile.getUnwrappedTool("groupsTestNG", this.myElement);
            for (String groupName : inspection.groups) {
                list.add(LookupValueFactory.createLookupValue((String)groupName, null));
            }
            if (!list.isEmpty()) {
                Object[] objectArray = list.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$GroupReference", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$GroupReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private static class MethodReference
    extends PsiReferenceBase<PsiLiteral> {
        public MethodReference(PsiLiteral element) {
            super((PsiElement)element, false);
        }

        @Nullable
        public PsiElement resolve() {
            String val = this.getValue();
            String methodName = StringUtil.getShortName((String)val);
            PsiClass cls = this.getDependsClass(val);
            if (cls != null) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = cls.findMethodsByName(methodName, true)) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)method, false) && !TestNGUtil.hasConfig((PsiModifierListOwner)method)) continue;
                    return method;
                }
            }
            return null;
        }

        @Nullable
        private PsiClass getDependsClass(String val) {
            String className = StringUtil.getPackageName((String)val);
            PsiLiteral element = (PsiLiteral)this.getElement();
            return StringUtil.isEmpty((String)className) ? PsiUtil.getTopLevelClass((PsiElement)element) : JavaPsiFacade.getInstance((Project)element.getProject()).findClass(className, element.getResolveScope());
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList<LookupElementBuilder> list = new ArrayList<LookupElementBuilder>();
            String val = this.getValue();
            int hackIndex = val.indexOf("IntellijIdeaRulezzz ");
            if (hackIndex > -1) {
                val = val.substring(0, hackIndex);
            }
            String className = StringUtil.getPackageName((String)val);
            PsiClass cls = this.getDependsClass(val);
            if (cls != null) {
                PsiMethod[] methods;
                PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
                String configAnnotation = TestNGUtil.getConfigAnnotation(current);
                for (PsiMethod method : methods = cls.getMethods()) {
                    String methodName = method.getName();
                    if (current != null && methodName.equals(current.getName()) || (configAnnotation != null || !TestNGUtil.hasTest((PsiModifierListOwner)method)) && (configAnnotation == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)configAnnotation, (boolean)true))) continue;
                    String nameToInsert = StringUtil.isEmpty((String)className) ? methodName : StringUtil.getQualifiedName((String)cls.getQualifiedName(), (String)methodName);
                    list.add(LookupElementBuilder.create((String)nameToInsert));
                }
            }
            Object[] objectArray = list.toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGReferenceContributor$MethodReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

