/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.configuration.TestNGPatternConfigurationProducer;
import com.theoryinpractice.testng.model.TestNGTestObject;

public abstract class TestNGConfigurationProducer
extends JavaRunConfigurationProducerBase<TestNGConfiguration>
implements Cloneable {
    public TestNGConfigurationProducer() {
        super((ConfigurationType)TestNGConfigurationType.getInstance());
    }

    public boolean isConfigurationFromContext(TestNGConfiguration testNGConfiguration, ConfigurationContext context) {
        String paramSetName;
        String vmParameters;
        if (((TestNGPatternConfigurationProducer)RunConfigurationProducer.getInstance(TestNGPatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)TestNGConfigurationType.getInstance());
        Location contextLocation = context.getLocation();
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        RunnerAndConfigurationSettings template = RunManager.getInstance((Project)location.getProject()).getConfigurationTemplate(this.getConfigurationFactory());
        Module predefinedModule = ((JavaRunConfigurationModule)((TestNGConfiguration)template.getConfiguration()).getConfigurationModule()).getModule();
        String string = vmParameters = predefinedConfiguration instanceof TestNGConfiguration ? ((TestNGConfiguration)predefinedConfiguration).getVMParameters() : null;
        if (vmParameters != null && !Comparing.strEqual((String)vmParameters, (String)testNGConfiguration.getVMParameters())) {
            return false;
        }
        String string2 = paramSetName = contextLocation instanceof PsiMemberParameterizedLocation ? TestNGConfigurationProducer.getInvocationNumber(((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) : null;
        if (paramSetName != null && !Comparing.strEqual((String)paramSetName, (String)testNGConfiguration.getProgramParameters())) {
            return false;
        }
        TestNGTestObject testobject = TestNGTestObject.fromConfig(testNGConfiguration);
        if (testobject != null && testobject.isConfiguredByElement(element)) {
            Module configurationModule = ((JavaRunConfigurationModule)testNGConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    public static String getInvocationNumber(String str) {
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)str, (String)"["), (String)"]");
    }
}

