/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BreakInstruction;
import freemarker.core.Case;
import freemarker.core.ComparisonExpression;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

final class SwitchBlock
extends TemplateElement {
    private Case defaultCase;
    private Expression testExpression;

    SwitchBlock(Expression testExpression) {
        this.testExpression = testExpression;
        this.nestedElements = new LinkedList();
    }

    void addCase(Case cas) {
        if (cas.isDefault) {
            this.defaultCase = cas;
        }
        this.nestedElements.add(cas);
    }

    void accept(Environment env) throws TemplateException, IOException {
        boolean processedCase = false;
        Iterator iterator = this.nestedElements.iterator();
        try {
            while (iterator.hasNext()) {
                Case cas = (Case)iterator.next();
                boolean processCase = false;
                if (processedCase) {
                    processCase = true;
                } else if (!cas.isDefault) {
                    ComparisonExpression equalsOp = new ComparisonExpression(this.testExpression, cas.expression, "==");
                    processCase = equalsOp.isTrue(env);
                }
                if (!processCase) continue;
                env.visit(cas);
                processedCase = true;
            }
            if (!processedCase && this.defaultCase != null) {
                env.visit(this.defaultCase);
            }
        }
        catch (BreakInstruction.Break br) {
            // empty catch block
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#switch ");
        buf.append(this.testExpression.getCanonicalForm());
        buf.append(">");
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Case cas = (Case)this.nestedElements.get(i);
            buf.append(cas.getCanonicalForm());
        }
        if (this.defaultCase != null) {
            buf.append(this.defaultCase.getCanonicalForm());
        }
        buf.append("</#switch>");
        return buf.toString();
    }

    public String getDescription() {
        return "switch " + this.testExpression;
    }
}

