/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.KeychainPackage$CredentialsStore$c1b97ea9;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"c\u0004)!b)\u001b7f\u0007J,G-\u001a8uS\u0006d7o\u0015;pe\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0005lKf\u001c\u0007.Y5o\u0015A\u0019%/\u001a3f]RL\u0017\r\\:Ti>\u0014XM\u0003\u0004=S:LGO\u0010\u0006\ngR|'/\u001a$jY\u0016TAAR5mK*!!.\u0019<b\u0015\tIwNC\u0006de\u0016$WM\u001c;jC2\u001c(bC\"sK\u0012,g\u000e^5bYNT!\u0002Z1uC2{\u0017\rZ3e\u0015\u001d\u0011un\u001c7fC:Taa[8uY&t'\u0002D3ogV\u0014X\rT8bI\u0016$'\u0002B+oSRT1aZ3u\u0015\u0011Awn\u001d;\u000b\rM#(/\u001b8h\u0015)\u00198\u000f[&fs\u001aKG.\u001a\u0006\u0005Y\u0006twMC\u0003sKN,GO\u0003\u0003tCZ,gN\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001\u0005\u0003\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u0015\u0001\u0012B\u0003\u0004\t\rA9\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u0001rA\u0003\u0004\t\u0005AY\u0001\u0004\u0001\u0006\u0005\u0011\t\u00012B\u0003\u0002\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001Qa\u0001C\u0006\u0011!a\u0001!B\u0002\u0005\f!MA\u0002A\u0003\u0003\t\u000bA)\"\u0002\u0002\u0005\u0010!MA\u0001\u0001G\u00023\t)\u0011\u0001\u0003\u0002.\u0019\u0011\tM\u0002G\u0003\"\u0007\u0015\t\u0001\u0012\u0002G\u0001+\u000e!Qa\u0001\u0003\u0006\u0013\u0005AQ!L\u0006\u0005\u00034Ab!\t\u0002\u0006\u0003!1Qk\u0001\u0003\u0006\u0007\u00111\u0011\"\u0001C\u0001[-!\u0011\r\u0002\r\u0004C\t)\u0011\u0001c\u0002V\u0007\u0011)1\u0001B\u0002\n\u0003!!Q6\u0003\u0003\u00021\u001f\t#!B\u0001\t\u000eE\u001b1\u0001b\u0004\n\u0003\u0011\u0001Qv\b\u0003\f1#iz\u0001\u0002\u0001\t\u00135\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0001AO\b\t\u0001A!\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005\u001aQ!\u0001E\u0005\u0019\u0003\t6a\u0002C\t\u0013\u0005AQ!D\u0001\t\u00115\t\u0001\u0002C\u0017\u0014\t-A2\"(\u0004\u0005\u0001!IQBA\u0003\u0002\u0011\u001d\u00016\u0001A\u0011\u0003\u000b\u0005Ai!U\u0002\u0006\t-I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\u0006\u000b\u0003\f1/iz\u0001\u0002\u0001\t\u00135\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0001AO\u0007\t\u0001AQ!\u0004\u0002\u0006\u0003!%\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0005\t#!B\u0001\t\u000eE\u001b\u0011\u0002b\u0006\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005AQ!D\u0001\t\u0011U&Rq\u0005\u0003d\u0002a\u0015QT\u0002\u0003\u0001\u0011\ri!!B\u0001\t\bA\u001b\u0001!\t\u0002\u0006\u0003!\r\u0011kA\u0003\u0005\u0006%\tA\u0001A\u0007\u0002\u0011\u0011\u0001"})
public final class FileCredentialsStore
implements CredentialsStore {
    public static final /* synthetic */ KClass $kotlinClass;
    private Credentials credentials;
    private boolean dataLoaded;
    private final File storeFile;

    static {
        $kotlinClass = Reflection.createKotlinClass(FileCredentialsStore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureLoaded() {
        if (this.dataLoaded) {
            return;
        }
        this.dataLoaded = true;
        if (this.storeFile.exists()) {
            try {
                boolean hasErrors = true;
                DataInputStream in = new DataInputStream(IoPackage.buffered$default((InputStream)new FileInputStream(this.storeFile), (int)0, (int)1));
                try {
                    this.credentials = new Credentials(PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)), PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)));
                    hasErrors = false;
                }
                finally {
                    if (hasErrors) {
                        this.storeFile.delete();
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                KeychainPackage$CredentialsStore$c1b97ea9.getLOG().error((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public Credentials get(@JetValueParameter(name="host", type="?") @Nullable String host, @JetValueParameter(name="sshKeyFile", type="?") @Nullable String sshKeyFile) {
        this.ensureLoaded();
        return this.credentials;
    }

    @Override
    public void reset(@JetValueParameter(name="host") @NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.credentials != null) {
            this.dataLoaded = true;
            this.storeFile.delete();
            Credentials credentials = this.credentials;
            if (credentials == null) {
                Intrinsics.throwNpe();
            }
            this.credentials = new Credentials(credentials.getId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@JetValueParameter(name="host", type="?") @Nullable String host, @JetValueParameter(name="credentials") @NotNull Credentials credentials, @JetValueParameter(name="sshKeyFile", type="?") @Nullable String sshKeyFile) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        if (credentials.equals(this.credentials)) {
            return;
        }
        this.credentials = credentials;
        try {
            FileUtil.createParentDirs((File)this.storeFile);
            DataOutputStream out = new DataOutputStream(IoPackage.buffered$default((OutputStream)new FileOutputStream(this.storeFile), (int)0, (int)1));
            try {
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getId()), (DataOutput)out);
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getToken()), (DataOutput)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            KeychainPackage$CredentialsStore$c1b97ea9.getLOG().error((Throwable)e);
        }
    }

    public FileCredentialsStore(@JetValueParameter(name="storeFile") @NotNull File storeFile) {
        Intrinsics.checkParameterIsNotNull((Object)storeFile, (String)"storeFile");
        this.storeFile = storeFile;
        this.dataLoaded = !this.storeFile.exists();
    }
}

