/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class SettingsRepositoryPackage$copyAppSettingsToRepository$03a85a14 {
    public static final void copyLocalConfig() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        StateStorageManager stateStorageManager = ComponentsPackage.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
        StreamProvider streamProvider = stateStorageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("com.intellij.openapi.components.impl.stores.StreamProvider cannot be cast to org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        MultiMap fileToComponents = ExportSettingsAction.getExportableComponentsMap((boolean)true, (boolean)false);
        for (File file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
            String fileSpec = stateStorageManager.collapseMacros(absolutePath);
            if (fileSpec.equals(absolutePath) && !(canonicalPath = FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath())).equals(absolutePath)) {
                fileSpec = stateStorageManager.collapseMacros(canonicalPath);
            }
            Collection collection = fileToComponents.get((Object)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fileToComponents.get(file)");
            RoamingType roamingType = SettingsRepositoryPackage$copyAppSettingsToRepository$03a85a14.getRoamingType(collection);
            if (file.isFile()) {
                byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                String string = fileSpec;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileSpec");
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(string, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            String string = fileSpec;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileSpec");
            SettingsRepositoryPackage$copyAppSettingsToRepository$03a85a14.saveDirectory(file2, string, roamingType, streamProvider2);
        }
    }

    public static final void saveDirectory(@JetValueParameter(name="parent") @NotNull File parent, @JetValueParameter(name="parentFileSpec") @NotNull String parentFileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType, @JetValueParameter(name="streamProvider") @NotNull IcsManager.IcsStreamProvider streamProvider) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)parentFileSpec, (String)"parentFileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)streamProvider, (String)"streamProvider");
        File[] files2 = parent.listFiles();
        if (files2 != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                String childFileSpec = parentFileSpec + '/' + file.getName();
                if (file.isFile()) {
                    byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                    streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                SettingsRepositoryPackage$copyAppSettingsToRepository$03a85a14.saveDirectory(file2, childFileSpec, roamingType, streamProvider);
            }
        }
    }

    @NotNull
    public static final RoamingType getRoamingType(@JetValueParameter(name="components") @NotNull Collection<? extends ExportableComponent> components) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        for (ExportableComponent exportableComponent : components) {
            Storage[] storages;
            State stateAnnotation;
            if (exportableComponent instanceof ExportSettingsAction.ExportableComponentItem) {
                RoamingType roamingType = ((ExportSettingsAction.ExportableComponentItem)exportableComponent).getRoamingType();
                Intrinsics.checkExpressionValueIsNotNull((Object)roamingType, (String)"component.getRoamingType()");
                return roamingType;
            }
            if (!(exportableComponent instanceof PersistentStateComponent) || (stateAnnotation = ((PersistentStateComponent)exportableComponent).getClass().getAnnotation(State.class)) == null || KotlinPackage.isEmpty((Object[])(storages = stateAnnotation.storages()))) continue;
            return storages[0].roamingType();
        }
        return RoamingType.PER_USER;
    }
}

