/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.UUID;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.CommitToIcsDialog;
import org.jetbrains.settingsRepository.ProjectId;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$01ecd992;
import org.jetbrains.settingsRepository.actions.ActionsPackage$CommitToIcsAction$d94fff8a;
import org.jetbrains.settingsRepository.actions.ProjectChangeCollectConsumer;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ActionsPackage$CommitToIcsAction$d94fff8a {
    @Nullable
    public static final String getProjectId(@JetValueParameter(name="project") @NotNull Project project) {
        ProjectId projectId;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = ServiceManager.getService((Project)project, ProjectId.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if ((projectId = (ProjectId)object).getUid() == null && ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Settings Server Project Mapping", (String)"Project is not mapped on Settings Server. Would you like to map?").project(project)).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.PropertyDoNotAskOption(""){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(getProjectId.1.class);
            }

            public void setToBeShown(@JetValueParameter(name="value") boolean value, @JetValueParameter(name="exitCode") int exitCode) {
                SettingsRepositoryPackage$IcsManager$01ecd992.getIcsManager().getSettings().setDoNoAskMapProject(!value);
            }

            public boolean isToBeShown() {
                return !SettingsRepositoryPackage$IcsManager$01ecd992.getIcsManager().getSettings().getDoNoAskMapProject();
            }

            public boolean canBeHidden() {
                return true;
            }
        })).show() == 0) {
            projectId.setUid(UUID.randomUUID().toString());
        }
        return projectId.getUid();
    }

    public static final void showDialog(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="collectConsumer") @NotNull ProjectChangeCollectConsumer collectConsumer, @JetValueParameter(name="projectId", type="?") @Nullable String projectId) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)collectConsumer, (String)"collectConsumer");
        if (!collectConsumer.hasResult()) {
            return;
        }
        String effectiveProjectId = projectId;
        if (effectiveProjectId == null && (effectiveProjectId = ActionsPackage$CommitToIcsAction$d94fff8a.getProjectId(project)) == null) {
            return;
        }
        new CommitToIcsDialog(project, effectiveProjectId, collectConsumer.getResult()).show();
    }

    public static final void collectProjectChanges(@JetValueParameter(name="changes") @NotNull Collection<? extends Change> changes, @JetValueParameter(name="collectConsumer") @NotNull ProjectChangeCollectConsumer collectConsumer) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)collectConsumer, (String)"collectConsumer");
        for (Change change : changes) {
            collectConsumer.consume(change);
        }
    }

    public static final boolean isProjectConfigFile(@JetValueParameter(name="file", type="?") @Nullable VirtualFile file, @JetValueParameter(name="project") @NotNull Project project) {
        VirtualFile projectFile;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = projectFile = project.getProjectFile();
        VirtualFile projectConfigDir = virtualFile != null ? virtualFile.getParent() : null;
        return projectConfigDir != null && VfsUtilCore.isAncestor((VirtualFile)projectConfigDir, (VirtualFile)file, (boolean)true);
    }
}

