/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$01ecd992;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class GitPackage$gitCredential$b4bc0ca9 {
    static boolean canUseGitExe = true;

    public static final boolean getCanUseGitExe() {
        return canUseGitExe;
    }

    public static final void setCanUseGitExe(@JetValueParameter(name="<set-?>") boolean bl) {
        canUseGitExe = bl;
    }

    @Nullable
    public static final Credentials getCredentialsUsingGit(@JetValueParameter(name="uri") @NotNull URIish uri, @JetValueParameter(name="repository") @NotNull Repository repository) {
        Process process;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        if (!canUseGitExe || repository.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath("git");
        commandLine.addParameter("credential");
        commandLine.addParameter("fill");
        commandLine.setPassParentEnvironment(true);
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"commandLine.createProcess()");
            process = process2;
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStreamWriter writer = IoPackage.writer$default((OutputStream)process.getOutputStream(), null, (int)1);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        BufferedReader reader = IoPackage.buffered$default((Reader)IoPackage.reader$default((InputStream)process.getInputStream(), null, (int)1), (int)0, (int)1);
        Object username = null;
        Object password = null;
        while (true) {
            String line;
            String string = reader.readLine();
            String string2 = line = string != null ? KotlinPackage.trim((String)string) : null;
            if (line == null || KotlinPackage.isEmpty((String)line)) break;
            Function0<String> readValue$ = new Function0<String>(line){
                final /* synthetic */ String $line;

                @NotNull
                public final String invoke() {
                    return KotlinPackage.trim((String)KotlinPackage.substring((String)this.$line, (int)(KotlinPackage.indexOf$default((String)this.$line, (char)'=', (int)0, (boolean)false, (int)6) + 1)));
                }
                {
                    this.$line = string;
                    super(0);
                }
            };
            if (KotlinPackage.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2)) {
                username = readValue$.invoke();
                continue;
            }
            if (!KotlinPackage.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2)) continue;
            password = readValue$.invoke();
        }
        reader.close();
        String errorText = IoPackage.readText((Reader)IoPackage.reader$default((InputStream)process.getErrorStream(), null, (int)1));
        if (!StringUtil.isEmpty((String)errorText)) {
            SettingsRepositoryPackage$IcsManager$01ecd992.getLOG().warn(errorText);
        }
        return username == null && password == null ? (Credentials)null : new Credentials((String)username, (String)password);
    }
}

